// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.eventbridge.endpoints.internal

import aws.sdk.kotlin.services.eventbridge.EventBridgeClient
import aws.sdk.kotlin.services.eventbridge.endpoints.EventBridgeEndpointParameters
import aws.sdk.kotlin.services.eventbridge.model.PutEventsRequest
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.client.endpoints.Endpoint
import aws.smithy.kotlin.runtime.collections.get
import aws.smithy.kotlin.runtime.http.operation.EndpointResolver
import aws.smithy.kotlin.runtime.http.operation.HttpOperationContext
import aws.smithy.kotlin.runtime.http.operation.ResolveEndpointRequest

internal class EndpointResolverAdapter(
    private val config: EventBridgeClient.Config
): EndpointResolver {

    override suspend fun resolve(request: ResolveEndpointRequest): Endpoint {
        val params = resolveEndpointParams(config, request)
        val endpoint = config.endpointProvider.resolveEndpoint(params)
        return endpoint
    }
}

internal fun resolveEndpointParams(config: EventBridgeClient.Config, request: ResolveEndpointRequest): EventBridgeEndpointParameters {
    return EventBridgeEndpointParameters {
        region = config.region
        bindAwsBuiltins(config, request)
        endpoint = config.endpointUrl?.toString()
        val opName = request.context[SdkClientOption.OperationName]
        opContextBindings[opName]?.invoke(this, request)
    }
}
private typealias BindOperationContextParamsFn = (EventBridgeEndpointParameters.Builder, ResolveEndpointRequest) -> Unit

private val opContextBindings = mapOf<String, BindOperationContextParamsFn> (
    "PutEvents" to ::bindPutEventsEndpointContext,
)

private fun EventBridgeEndpointParameters.Builder.bindAwsBuiltins(config: EventBridgeClient.Config, request: ResolveEndpointRequest) {
    useDualStack = config.useDualStack
    useFips = config.useFips
}

private fun bindPutEventsEndpointContext(builder: EventBridgeEndpointParameters.Builder, request: ResolveEndpointRequest): Unit {
    @Suppress("UNCHECKED_CAST")
    val input = request.context[HttpOperationContext.OperationInput] as PutEventsRequest
    builder.endpointId = input.endpointId
}
