// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.eventbridge.serde

import aws.sdk.kotlin.services.eventbridge.model.DescribeReplayResponse
import aws.sdk.kotlin.services.eventbridge.model.EventBridgeException
import aws.sdk.kotlin.services.eventbridge.model.ReplayDestination
import aws.sdk.kotlin.services.eventbridge.model.ReplayState
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant


internal class DescribeReplayOperationDeserializer: HttpDeserialize<DescribeReplayResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): DescribeReplayResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeReplayError(context, call)
        }
        val builder = DescribeReplayResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeReplayOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwDescribeReplayError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw EventBridgeException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalException" -> InternalExceptionDeserializer().deserialize(context, wrappedCall)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        else -> EventBridgeException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeReplayOperationBody(builder: DescribeReplayResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Description"))
    val DESTINATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Destination"))
    val EVENTENDTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("EventEndTime"))
    val EVENTLASTREPLAYEDTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("EventLastReplayedTime"))
    val EVENTSOURCEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("EventSourceArn"))
    val EVENTSTARTTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("EventStartTime"))
    val REPLAYARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ReplayArn"))
    val REPLAYENDTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("ReplayEndTime"))
    val REPLAYNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ReplayName"))
    val REPLAYSTARTTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("ReplayStartTime"))
    val STATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("State"))
    val STATEREASON_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("StateReason"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(DESCRIPTION_DESCRIPTOR)
        field(DESTINATION_DESCRIPTOR)
        field(EVENTENDTIME_DESCRIPTOR)
        field(EVENTLASTREPLAYEDTIME_DESCRIPTOR)
        field(EVENTSOURCEARN_DESCRIPTOR)
        field(EVENTSTARTTIME_DESCRIPTOR)
        field(REPLAYARN_DESCRIPTOR)
        field(REPLAYENDTIME_DESCRIPTOR)
        field(REPLAYNAME_DESCRIPTOR)
        field(REPLAYSTARTTIME_DESCRIPTOR)
        field(STATE_DESCRIPTOR)
        field(STATEREASON_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                DESCRIPTION_DESCRIPTOR.index -> builder.description = deserializeString()
                DESTINATION_DESCRIPTOR.index -> builder.destination = deserializeReplayDestinationDocument(deserializer)
                EVENTENDTIME_DESCRIPTOR.index -> builder.eventEndTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                EVENTLASTREPLAYEDTIME_DESCRIPTOR.index -> builder.eventLastReplayedTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                EVENTSOURCEARN_DESCRIPTOR.index -> builder.eventSourceArn = deserializeString()
                EVENTSTARTTIME_DESCRIPTOR.index -> builder.eventStartTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                REPLAYARN_DESCRIPTOR.index -> builder.replayArn = deserializeString()
                REPLAYENDTIME_DESCRIPTOR.index -> builder.replayEndTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                REPLAYNAME_DESCRIPTOR.index -> builder.replayName = deserializeString()
                REPLAYSTARTTIME_DESCRIPTOR.index -> builder.replayStartTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                STATE_DESCRIPTOR.index -> builder.state = deserializeString().let { ReplayState.fromValue(it) }
                STATEREASON_DESCRIPTOR.index -> builder.stateReason = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
