// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.eventbridge.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * A `Replay` object that contains details about a replay.
 */
public class Replay private constructor(builder: Builder) {
    /**
     * A time stamp for the time to start replaying events. Any event with a creation time prior to the `EventEndTime` specified is replayed.
     */
    public val eventEndTime: aws.smithy.kotlin.runtime.time.Instant? = builder.eventEndTime
    /**
     * A time stamp for the time that the last event was replayed.
     */
    public val eventLastReplayedTime: aws.smithy.kotlin.runtime.time.Instant? = builder.eventLastReplayedTime
    /**
     * The ARN of the archive to replay event from.
     */
    public val eventSourceArn: kotlin.String? = builder.eventSourceArn
    /**
     * A time stamp for the time to start replaying events. This is determined by the time in the event as described in [Time](https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_PutEventsRequestEntry.html#eventbridge-Type-PutEventsRequestEntry-Time).
     */
    public val eventStartTime: aws.smithy.kotlin.runtime.time.Instant? = builder.eventStartTime
    /**
     * A time stamp for the time that the replay completed.
     */
    public val replayEndTime: aws.smithy.kotlin.runtime.time.Instant? = builder.replayEndTime
    /**
     * The name of the replay.
     */
    public val replayName: kotlin.String? = builder.replayName
    /**
     * A time stamp for the time that the replay started.
     */
    public val replayStartTime: aws.smithy.kotlin.runtime.time.Instant? = builder.replayStartTime
    /**
     * The current state of the replay.
     */
    public val state: aws.sdk.kotlin.services.eventbridge.model.ReplayState? = builder.state
    /**
     * A description of why the replay is in the current state.
     */
    public val stateReason: kotlin.String? = builder.stateReason

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.eventbridge.model.Replay = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Replay(")
        append("eventEndTime=$eventEndTime,")
        append("eventLastReplayedTime=$eventLastReplayedTime,")
        append("eventSourceArn=$eventSourceArn,")
        append("eventStartTime=$eventStartTime,")
        append("replayEndTime=$replayEndTime,")
        append("replayName=$replayName,")
        append("replayStartTime=$replayStartTime,")
        append("state=$state,")
        append("stateReason=$stateReason")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = eventEndTime?.hashCode() ?: 0
        result = 31 * result + (eventLastReplayedTime?.hashCode() ?: 0)
        result = 31 * result + (eventSourceArn?.hashCode() ?: 0)
        result = 31 * result + (eventStartTime?.hashCode() ?: 0)
        result = 31 * result + (replayEndTime?.hashCode() ?: 0)
        result = 31 * result + (replayName?.hashCode() ?: 0)
        result = 31 * result + (replayStartTime?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        result = 31 * result + (stateReason?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Replay

        if (eventEndTime != other.eventEndTime) return false
        if (eventLastReplayedTime != other.eventLastReplayedTime) return false
        if (eventSourceArn != other.eventSourceArn) return false
        if (eventStartTime != other.eventStartTime) return false
        if (replayEndTime != other.replayEndTime) return false
        if (replayName != other.replayName) return false
        if (replayStartTime != other.replayStartTime) return false
        if (state != other.state) return false
        if (stateReason != other.stateReason) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.eventbridge.model.Replay = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A time stamp for the time to start replaying events. Any event with a creation time prior to the `EventEndTime` specified is replayed.
         */
        public var eventEndTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * A time stamp for the time that the last event was replayed.
         */
        public var eventLastReplayedTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The ARN of the archive to replay event from.
         */
        public var eventSourceArn: kotlin.String? = null
        /**
         * A time stamp for the time to start replaying events. This is determined by the time in the event as described in [Time](https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_PutEventsRequestEntry.html#eventbridge-Type-PutEventsRequestEntry-Time).
         */
        public var eventStartTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * A time stamp for the time that the replay completed.
         */
        public var replayEndTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of the replay.
         */
        public var replayName: kotlin.String? = null
        /**
         * A time stamp for the time that the replay started.
         */
        public var replayStartTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The current state of the replay.
         */
        public var state: aws.sdk.kotlin.services.eventbridge.model.ReplayState? = null
        /**
         * A description of why the replay is in the current state.
         */
        public var stateReason: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.eventbridge.model.Replay) : this() {
            this.eventEndTime = x.eventEndTime
            this.eventLastReplayedTime = x.eventLastReplayedTime
            this.eventSourceArn = x.eventSourceArn
            this.eventStartTime = x.eventStartTime
            this.replayEndTime = x.replayEndTime
            this.replayName = x.replayName
            this.replayStartTime = x.replayStartTime
            this.state = x.state
            this.stateReason = x.stateReason
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.eventbridge.model.Replay = Replay(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
