// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.eventbridge.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * A global endpoint used to improve your application's availability by making it regional-fault tolerant. For more information about global endpoints, see [Making applications Regional-fault tolerant with global endpoints and event replication](https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-global-endpoints.html) in the *Amazon EventBridge User Guide*.
 */
public class Endpoint private constructor(builder: Builder) {
    /**
     * The ARN of the endpoint.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * The time the endpoint was created.
     */
    public val creationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTime
    /**
     * A description for the endpoint.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The URL subdomain of the endpoint. For example, if the URL for Endpoint is https://abcde.veo.endpoints.event.amazonaws.com, then the EndpointId is `abcde.veo`.
     */
    public val endpointId: kotlin.String? = builder.endpointId
    /**
     * The URL of the endpoint.
     */
    public val endpointUrl: kotlin.String? = builder.endpointUrl
    /**
     * The event buses being used by the endpoint.
     */
    public val eventBuses: List<EndpointEventBus>? = builder.eventBuses
    /**
     * The last time the endpoint was modified.
     */
    public val lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastModifiedTime
    /**
     * The name of the endpoint.
     */
    public val name: kotlin.String? = builder.name
    /**
     * Whether event replication was enabled or disabled for this endpoint. The default state is `ENABLED` which means you must supply a `RoleArn`. If you don't have a `RoleArn` or you don't want event replication enabled, set the state to `DISABLED`.
     */
    public val replicationConfig: aws.sdk.kotlin.services.eventbridge.model.ReplicationConfig? = builder.replicationConfig
    /**
     * The ARN of the role used by event replication for the endpoint.
     */
    public val roleArn: kotlin.String? = builder.roleArn
    /**
     * The routing configuration of the endpoint.
     */
    public val routingConfig: aws.sdk.kotlin.services.eventbridge.model.RoutingConfig? = builder.routingConfig
    /**
     * The current state of the endpoint.
     */
    public val state: aws.sdk.kotlin.services.eventbridge.model.EndpointState? = builder.state
    /**
     * The reason the endpoint is in its current state.
     */
    public val stateReason: kotlin.String? = builder.stateReason

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.eventbridge.model.Endpoint = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Endpoint(")
        append("arn=$arn,")
        append("creationTime=$creationTime,")
        append("description=$description,")
        append("endpointId=$endpointId,")
        append("endpointUrl=$endpointUrl,")
        append("eventBuses=$eventBuses,")
        append("lastModifiedTime=$lastModifiedTime,")
        append("name=$name,")
        append("replicationConfig=$replicationConfig,")
        append("roleArn=$roleArn,")
        append("routingConfig=$routingConfig,")
        append("state=$state,")
        append("stateReason=$stateReason")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (creationTime?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (endpointId?.hashCode() ?: 0)
        result = 31 * result + (endpointUrl?.hashCode() ?: 0)
        result = 31 * result + (eventBuses?.hashCode() ?: 0)
        result = 31 * result + (lastModifiedTime?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (replicationConfig?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (routingConfig?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        result = 31 * result + (stateReason?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Endpoint

        if (arn != other.arn) return false
        if (creationTime != other.creationTime) return false
        if (description != other.description) return false
        if (endpointId != other.endpointId) return false
        if (endpointUrl != other.endpointUrl) return false
        if (eventBuses != other.eventBuses) return false
        if (lastModifiedTime != other.lastModifiedTime) return false
        if (name != other.name) return false
        if (replicationConfig != other.replicationConfig) return false
        if (roleArn != other.roleArn) return false
        if (routingConfig != other.routingConfig) return false
        if (state != other.state) return false
        if (stateReason != other.stateReason) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.eventbridge.model.Endpoint = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The ARN of the endpoint.
         */
        public var arn: kotlin.String? = null
        /**
         * The time the endpoint was created.
         */
        public var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * A description for the endpoint.
         */
        public var description: kotlin.String? = null
        /**
         * The URL subdomain of the endpoint. For example, if the URL for Endpoint is https://abcde.veo.endpoints.event.amazonaws.com, then the EndpointId is `abcde.veo`.
         */
        public var endpointId: kotlin.String? = null
        /**
         * The URL of the endpoint.
         */
        public var endpointUrl: kotlin.String? = null
        /**
         * The event buses being used by the endpoint.
         */
        public var eventBuses: List<EndpointEventBus>? = null
        /**
         * The last time the endpoint was modified.
         */
        public var lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of the endpoint.
         */
        public var name: kotlin.String? = null
        /**
         * Whether event replication was enabled or disabled for this endpoint. The default state is `ENABLED` which means you must supply a `RoleArn`. If you don't have a `RoleArn` or you don't want event replication enabled, set the state to `DISABLED`.
         */
        public var replicationConfig: aws.sdk.kotlin.services.eventbridge.model.ReplicationConfig? = null
        /**
         * The ARN of the role used by event replication for the endpoint.
         */
        public var roleArn: kotlin.String? = null
        /**
         * The routing configuration of the endpoint.
         */
        public var routingConfig: aws.sdk.kotlin.services.eventbridge.model.RoutingConfig? = null
        /**
         * The current state of the endpoint.
         */
        public var state: aws.sdk.kotlin.services.eventbridge.model.EndpointState? = null
        /**
         * The reason the endpoint is in its current state.
         */
        public var stateReason: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.eventbridge.model.Endpoint) : this() {
            this.arn = x.arn
            this.creationTime = x.creationTime
            this.description = x.description
            this.endpointId = x.endpointId
            this.endpointUrl = x.endpointUrl
            this.eventBuses = x.eventBuses
            this.lastModifiedTime = x.lastModifiedTime
            this.name = x.name
            this.replicationConfig = x.replicationConfig
            this.roleArn = x.roleArn
            this.routingConfig = x.routingConfig
            this.state = x.state
            this.stateReason = x.stateReason
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.eventbridge.model.Endpoint = Endpoint(this)

        /**
         * construct an [aws.sdk.kotlin.services.eventbridge.model.ReplicationConfig] inside the given [block]
         */
        public fun replicationConfig(block: aws.sdk.kotlin.services.eventbridge.model.ReplicationConfig.Builder.() -> kotlin.Unit) {
            this.replicationConfig = aws.sdk.kotlin.services.eventbridge.model.ReplicationConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.eventbridge.model.RoutingConfig] inside the given [block]
         */
        public fun routingConfig(block: aws.sdk.kotlin.services.eventbridge.model.RoutingConfig.Builder.() -> kotlin.Unit) {
            this.routingConfig = aws.sdk.kotlin.services.eventbridge.model.RoutingConfig.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
