// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.eventbridge.model



/**
 * The custom parameters to be used when the target is an Batch job.
 */
public class BatchParameters private constructor(builder: Builder) {
    /**
     * The array properties for the submitted job, such as the size of the array. The array size can be between 2 and 10,000. If you specify array properties for a job, it becomes an array job. This parameter is used only if the target is an Batch job.
     */
    public val arrayProperties: aws.sdk.kotlin.services.eventbridge.model.BatchArrayProperties? = builder.arrayProperties
    /**
     * The ARN or name of the job definition to use if the event target is an Batch job. This job definition must already exist.
     */
    public val jobDefinition: kotlin.String = requireNotNull(builder.jobDefinition) { "A non-null value must be provided for jobDefinition" }
    /**
     * The name to use for this execution of the job, if the target is an Batch job.
     */
    public val jobName: kotlin.String = requireNotNull(builder.jobName) { "A non-null value must be provided for jobName" }
    /**
     * The retry strategy to use for failed jobs, if the target is an Batch job. The retry strategy is the number of times to retry the failed job execution. Valid values are 1–10. When you specify a retry strategy here, it overrides the retry strategy defined in the job definition.
     */
    public val retryStrategy: aws.sdk.kotlin.services.eventbridge.model.BatchRetryStrategy? = builder.retryStrategy

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.eventbridge.model.BatchParameters = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("BatchParameters(")
        append("arrayProperties=$arrayProperties,")
        append("jobDefinition=$jobDefinition,")
        append("jobName=$jobName,")
        append("retryStrategy=$retryStrategy")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arrayProperties?.hashCode() ?: 0
        result = 31 * result + (jobDefinition.hashCode())
        result = 31 * result + (jobName.hashCode())
        result = 31 * result + (retryStrategy?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as BatchParameters

        if (arrayProperties != other.arrayProperties) return false
        if (jobDefinition != other.jobDefinition) return false
        if (jobName != other.jobName) return false
        if (retryStrategy != other.retryStrategy) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.eventbridge.model.BatchParameters = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The array properties for the submitted job, such as the size of the array. The array size can be between 2 and 10,000. If you specify array properties for a job, it becomes an array job. This parameter is used only if the target is an Batch job.
         */
        public var arrayProperties: aws.sdk.kotlin.services.eventbridge.model.BatchArrayProperties? = null
        /**
         * The ARN or name of the job definition to use if the event target is an Batch job. This job definition must already exist.
         */
        public var jobDefinition: kotlin.String? = null
        /**
         * The name to use for this execution of the job, if the target is an Batch job.
         */
        public var jobName: kotlin.String? = null
        /**
         * The retry strategy to use for failed jobs, if the target is an Batch job. The retry strategy is the number of times to retry the failed job execution. Valid values are 1–10. When you specify a retry strategy here, it overrides the retry strategy defined in the job definition.
         */
        public var retryStrategy: aws.sdk.kotlin.services.eventbridge.model.BatchRetryStrategy? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.eventbridge.model.BatchParameters) : this() {
            this.arrayProperties = x.arrayProperties
            this.jobDefinition = x.jobDefinition
            this.jobName = x.jobName
            this.retryStrategy = x.retryStrategy
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.eventbridge.model.BatchParameters = BatchParameters(this)

        /**
         * construct an [aws.sdk.kotlin.services.eventbridge.model.BatchArrayProperties] inside the given [block]
         */
        public fun arrayProperties(block: aws.sdk.kotlin.services.eventbridge.model.BatchArrayProperties.Builder.() -> kotlin.Unit) {
            this.arrayProperties = aws.sdk.kotlin.services.eventbridge.model.BatchArrayProperties.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.eventbridge.model.BatchRetryStrategy] inside the given [block]
         */
        public fun retryStrategy(block: aws.sdk.kotlin.services.eventbridge.model.BatchRetryStrategy.Builder.() -> kotlin.Unit) {
            this.retryStrategy = aws.sdk.kotlin.services.eventbridge.model.BatchRetryStrategy.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (jobDefinition == null) jobDefinition = ""
            if (jobName == null) jobName = ""
            return this
        }
    }
}
