// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.eventbridge.model



/**
 * This structure specifies the VPC subnets and security groups for the task, and whether a public IP address is to be used. This structure is relevant only for ECS tasks that use the `awsvpc` network mode.
 */
public class AwsVpcConfiguration private constructor(builder: Builder) {
    /**
     * Specifies whether the task's elastic network interface receives a public IP address. You can specify `ENABLED` only when `LaunchType` in `EcsParameters` is set to `FARGATE`.
     */
    public val assignPublicIp: aws.sdk.kotlin.services.eventbridge.model.AssignPublicIp? = builder.assignPublicIp
    /**
     * Specifies the security groups associated with the task. These security groups must all be in the same VPC. You can specify as many as five security groups. If you do not specify a security group, the default security group for the VPC is used.
     */
    public val securityGroups: List<String>? = builder.securityGroups
    /**
     * Specifies the subnets associated with the task. These subnets must all be in the same VPC. You can specify as many as 16 subnets.
     */
    public val subnets: List<String> = requireNotNull(builder.subnets) { "A non-null value must be provided for subnets" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.eventbridge.model.AwsVpcConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AwsVpcConfiguration(")
        append("assignPublicIp=$assignPublicIp,")
        append("securityGroups=$securityGroups,")
        append("subnets=$subnets")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = assignPublicIp?.hashCode() ?: 0
        result = 31 * result + (securityGroups?.hashCode() ?: 0)
        result = 31 * result + (subnets.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AwsVpcConfiguration

        if (assignPublicIp != other.assignPublicIp) return false
        if (securityGroups != other.securityGroups) return false
        if (subnets != other.subnets) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.eventbridge.model.AwsVpcConfiguration = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Specifies whether the task's elastic network interface receives a public IP address. You can specify `ENABLED` only when `LaunchType` in `EcsParameters` is set to `FARGATE`.
         */
        public var assignPublicIp: aws.sdk.kotlin.services.eventbridge.model.AssignPublicIp? = null
        /**
         * Specifies the security groups associated with the task. These security groups must all be in the same VPC. You can specify as many as five security groups. If you do not specify a security group, the default security group for the VPC is used.
         */
        public var securityGroups: List<String>? = null
        /**
         * Specifies the subnets associated with the task. These subnets must all be in the same VPC. You can specify as many as 16 subnets.
         */
        public var subnets: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.eventbridge.model.AwsVpcConfiguration) : this() {
            this.assignPublicIp = x.assignPublicIp
            this.securityGroups = x.securityGroups
            this.subnets = x.subnets
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.eventbridge.model.AwsVpcConfiguration = AwsVpcConfiguration(this)

        internal fun correctErrors(): Builder {
            if (subnets == null) subnets = emptyList()
            return this
        }
    }
}
