// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.entityresolution.serde

import aws.sdk.kotlin.services.entityresolution.model.EntityResolutionException
import aws.sdk.kotlin.services.entityresolution.model.IncrementalRunConfig
import aws.sdk.kotlin.services.entityresolution.model.InputSource
import aws.sdk.kotlin.services.entityresolution.model.OutputSource
import aws.sdk.kotlin.services.entityresolution.model.ResolutionTechniques
import aws.sdk.kotlin.services.entityresolution.model.UpdateMatchingWorkflowResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class UpdateMatchingWorkflowOperationDeserializer: HttpDeserializer.NonStreaming<UpdateMatchingWorkflowResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): UpdateMatchingWorkflowResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwUpdateMatchingWorkflowError(context, call, payload)
        }
        val builder = UpdateMatchingWorkflowResponse.Builder()

        if (payload != null) {
            deserializeUpdateMatchingWorkflowOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwUpdateMatchingWorkflowError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw EntityResolutionException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> EntityResolutionException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeUpdateMatchingWorkflowOperationBody(builder: UpdateMatchingWorkflowResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("description"))
    val INCREMENTALRUNCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("incrementalRunConfig"))
    val INPUTSOURCECONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("inputSourceConfig"))
    val OUTPUTSOURCECONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("outputSourceConfig"))
    val RESOLUTIONTECHNIQUES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("resolutionTechniques"))
    val ROLEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("roleArn"))
    val WORKFLOWNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("workflowName"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(DESCRIPTION_DESCRIPTOR)
        field(INCREMENTALRUNCONFIG_DESCRIPTOR)
        field(INPUTSOURCECONFIG_DESCRIPTOR)
        field(OUTPUTSOURCECONFIG_DESCRIPTOR)
        field(RESOLUTIONTECHNIQUES_DESCRIPTOR)
        field(ROLEARN_DESCRIPTOR)
        field(WORKFLOWNAME_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                DESCRIPTION_DESCRIPTOR.index -> builder.description = deserializeString()
                INCREMENTALRUNCONFIG_DESCRIPTOR.index -> builder.incrementalRunConfig = deserializeIncrementalRunConfigDocument(deserializer)
                INPUTSOURCECONFIG_DESCRIPTOR.index -> builder.inputSourceConfig =
                    deserializer.deserializeList(INPUTSOURCECONFIG_DESCRIPTOR) {
                        val col0 = mutableListOf<InputSource>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeInputSourceDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                OUTPUTSOURCECONFIG_DESCRIPTOR.index -> builder.outputSourceConfig =
                    deserializer.deserializeList(OUTPUTSOURCECONFIG_DESCRIPTOR) {
                        val col0 = mutableListOf<OutputSource>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeOutputSourceDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                RESOLUTIONTECHNIQUES_DESCRIPTOR.index -> builder.resolutionTechniques = deserializeResolutionTechniquesDocument(deserializer)
                ROLEARN_DESCRIPTOR.index -> builder.roleArn = deserializeString()
                WORKFLOWNAME_DESCRIPTOR.index -> builder.workflowName = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
