// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.entityresolution.serde

import aws.sdk.kotlin.services.entityresolution.model.EntityResolutionException
import aws.sdk.kotlin.services.entityresolution.model.GetSchemaMappingResponse
import aws.sdk.kotlin.services.entityresolution.model.SchemaInputAttribute
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat
import kotlin.collections.mutableListOf
import kotlin.collections.mutableMapOf


internal class GetSchemaMappingOperationDeserializer: HttpDeserializer.NonStreaming<GetSchemaMappingResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): GetSchemaMappingResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetSchemaMappingError(context, call, payload)
        }
        val builder = GetSchemaMappingResponse.Builder()

        if (payload != null) {
            deserializeGetSchemaMappingOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwGetSchemaMappingError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw EntityResolutionException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> EntityResolutionException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetSchemaMappingOperationBody(builder: GetSchemaMappingResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CREATEDAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("createdAt"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("description"))
    val HASWORKFLOWS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("hasWorkflows"))
    val MAPPEDINPUTFIELDS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("mappedInputFields"))
    val SCHEMAARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("schemaArn"))
    val SCHEMANAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("schemaName"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("tags"))
    val UPDATEDAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("updatedAt"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CREATEDAT_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(HASWORKFLOWS_DESCRIPTOR)
        field(MAPPEDINPUTFIELDS_DESCRIPTOR)
        field(SCHEMAARN_DESCRIPTOR)
        field(SCHEMANAME_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
        field(UPDATEDAT_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CREATEDAT_DESCRIPTOR.index -> builder.createdAt = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                DESCRIPTION_DESCRIPTOR.index -> builder.description = deserializeString()
                HASWORKFLOWS_DESCRIPTOR.index -> builder.hasWorkflows = deserializeBoolean()
                MAPPEDINPUTFIELDS_DESCRIPTOR.index -> builder.mappedInputFields =
                    deserializer.deserializeList(MAPPEDINPUTFIELDS_DESCRIPTOR) {
                        val col0 = mutableListOf<SchemaInputAttribute>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeSchemaInputAttributeDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                SCHEMAARN_DESCRIPTOR.index -> builder.schemaArn = deserializeString()
                SCHEMANAME_DESCRIPTOR.index -> builder.schemaName = deserializeString()
                TAGS_DESCRIPTOR.index -> builder.tags =
                    deserializer.deserializeMap(TAGS_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, String>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                UPDATEDAT_DESCRIPTOR.index -> builder.updatedAt = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
