// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.entityresolution.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * An object containing `SchemaName`, `SchemaArn`, `CreatedAt`, and`UpdatedAt`.
 */
public class SchemaMappingSummary private constructor(builder: Builder) {
    /**
     * The timestamp of when the `SchemaMapping` was created.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.createdAt) { "A non-null value must be provided for createdAt" }
    /**
     * Specifies whether the schema mapping has been applied to a workflow.
     */
    public val hasWorkflows: kotlin.Boolean = requireNotNull(builder.hasWorkflows) { "A non-null value must be provided for hasWorkflows" }
    /**
     * The ARN (Amazon Resource Name) that Entity Resolution generated for the `SchemaMapping`.
     */
    public val schemaArn: kotlin.String = requireNotNull(builder.schemaArn) { "A non-null value must be provided for schemaArn" }
    /**
     * The name of the schema.
     */
    public val schemaName: kotlin.String = requireNotNull(builder.schemaName) { "A non-null value must be provided for schemaName" }
    /**
     * The timestamp of when the `SchemaMapping` was last updated.
     */
    public val updatedAt: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.updatedAt) { "A non-null value must be provided for updatedAt" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.entityresolution.model.SchemaMappingSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SchemaMappingSummary(")
        append("createdAt=$createdAt,")
        append("hasWorkflows=$hasWorkflows,")
        append("schemaArn=$schemaArn,")
        append("schemaName=$schemaName,")
        append("updatedAt=$updatedAt")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = createdAt.hashCode()
        result = 31 * result + (hasWorkflows.hashCode())
        result = 31 * result + (schemaArn.hashCode())
        result = 31 * result + (schemaName.hashCode())
        result = 31 * result + (updatedAt.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SchemaMappingSummary

        if (createdAt != other.createdAt) return false
        if (hasWorkflows != other.hasWorkflows) return false
        if (schemaArn != other.schemaArn) return false
        if (schemaName != other.schemaName) return false
        if (updatedAt != other.updatedAt) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.entityresolution.model.SchemaMappingSummary = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The timestamp of when the `SchemaMapping` was created.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Specifies whether the schema mapping has been applied to a workflow.
         */
        public var hasWorkflows: kotlin.Boolean? = null
        /**
         * The ARN (Amazon Resource Name) that Entity Resolution generated for the `SchemaMapping`.
         */
        public var schemaArn: kotlin.String? = null
        /**
         * The name of the schema.
         */
        public var schemaName: kotlin.String? = null
        /**
         * The timestamp of when the `SchemaMapping` was last updated.
         */
        public var updatedAt: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.entityresolution.model.SchemaMappingSummary) : this() {
            this.createdAt = x.createdAt
            this.hasWorkflows = x.hasWorkflows
            this.schemaArn = x.schemaArn
            this.schemaName = x.schemaName
            this.updatedAt = x.updatedAt
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.entityresolution.model.SchemaMappingSummary = SchemaMappingSummary(this)

        internal fun correctErrors(): Builder {
            if (createdAt == null) createdAt = Instant.fromEpochSeconds(0)
            if (hasWorkflows == null) hasWorkflows = false
            if (schemaArn == null) schemaArn = ""
            if (schemaName == null) schemaName = ""
            if (updatedAt == null) updatedAt = Instant.fromEpochSeconds(0)
            return this
        }
    }
}
