// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.entityresolution.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * An object containing `KMSArn`, `OutputS3Path`, and `RoleArn`.
 */
public class JobOutputSource private constructor(builder: Builder) {
    /**
     * Customer KMS ARN for encryption at rest. If not provided, system will use an Entity Resolution managed KMS key.
     */
    public val kmsArn: kotlin.String? = builder.kmsArn
    /**
     * The S3 path to which Entity Resolution will write the output table.
     */
    public val outputS3Path: kotlin.String = requireNotNull(builder.outputS3Path) { "A non-null value must be provided for outputS3Path" }
    /**
     * The Amazon Resource Name (ARN) of the IAM role. Entity Resolution assumes this role to access Amazon Web Services resources on your behalf as part of workflow execution.
     */
    public val roleArn: kotlin.String = requireNotNull(builder.roleArn) { "A non-null value must be provided for roleArn" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.entityresolution.model.JobOutputSource = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("JobOutputSource(")
        append("kmsArn=$kmsArn,")
        append("outputS3Path=$outputS3Path,")
        append("roleArn=$roleArn")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = kmsArn?.hashCode() ?: 0
        result = 31 * result + (outputS3Path.hashCode())
        result = 31 * result + (roleArn.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as JobOutputSource

        if (kmsArn != other.kmsArn) return false
        if (outputS3Path != other.outputS3Path) return false
        if (roleArn != other.roleArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.entityresolution.model.JobOutputSource = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Customer KMS ARN for encryption at rest. If not provided, system will use an Entity Resolution managed KMS key.
         */
        public var kmsArn: kotlin.String? = null
        /**
         * The S3 path to which Entity Resolution will write the output table.
         */
        public var outputS3Path: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the IAM role. Entity Resolution assumes this role to access Amazon Web Services resources on your behalf as part of workflow execution.
         */
        public var roleArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.entityresolution.model.JobOutputSource) : this() {
            this.kmsArn = x.kmsArn
            this.outputS3Path = x.outputS3Path
            this.roleArn = x.roleArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.entityresolution.model.JobOutputSource = JobOutputSource(this)

        internal fun correctErrors(): Builder {
            if (outputS3Path == null) outputS3Path = ""
            if (roleArn == null) roleArn = ""
            return this
        }
    }
}
