// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.entityresolution.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * A summary of ID namespaces.
 */
public class IdNamespaceSummary private constructor(builder: Builder) {
    /**
     * The timestamp of when the ID namespace was created.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.createdAt) { "A non-null value must be provided for createdAt" }
    /**
     * The description of the ID namespace.
     */
    public val description: kotlin.String? = builder.description
    /**
     * An object which defines any additional configurations required by the ID mapping workflow.
     */
    public val idMappingWorkflowProperties: List<IdNamespaceIdMappingWorkflowMetadata>? = builder.idMappingWorkflowProperties
    /**
     * The Amazon Resource Name (ARN) of the ID namespace.
     */
    public val idNamespaceArn: kotlin.String = requireNotNull(builder.idNamespaceArn) { "A non-null value must be provided for idNamespaceArn" }
    /**
     * The name of the ID namespace.
     */
    public val idNamespaceName: kotlin.String = requireNotNull(builder.idNamespaceName) { "A non-null value must be provided for idNamespaceName" }
    /**
     * The type of ID namespace. There are two types: `SOURCE` and `TARGET`.
     *
     * The `SOURCE` contains configurations for `sourceId` data that will be processed in an ID mapping workflow.
     *
     * The `TARGET` contains a configuration of `targetId` which all `sourceIds` will resolve to.
     */
    public val type: aws.sdk.kotlin.services.entityresolution.model.IdNamespaceType = requireNotNull(builder.type) { "A non-null value must be provided for type" }
    /**
     * The timestamp of when the ID namespace was last updated.
     */
    public val updatedAt: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.updatedAt) { "A non-null value must be provided for updatedAt" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.entityresolution.model.IdNamespaceSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("IdNamespaceSummary(")
        append("createdAt=$createdAt,")
        append("description=$description,")
        append("idMappingWorkflowProperties=$idMappingWorkflowProperties,")
        append("idNamespaceArn=$idNamespaceArn,")
        append("idNamespaceName=$idNamespaceName,")
        append("type=$type,")
        append("updatedAt=$updatedAt")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = createdAt.hashCode()
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (idMappingWorkflowProperties?.hashCode() ?: 0)
        result = 31 * result + (idNamespaceArn.hashCode())
        result = 31 * result + (idNamespaceName.hashCode())
        result = 31 * result + (type.hashCode())
        result = 31 * result + (updatedAt.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as IdNamespaceSummary

        if (createdAt != other.createdAt) return false
        if (description != other.description) return false
        if (idMappingWorkflowProperties != other.idMappingWorkflowProperties) return false
        if (idNamespaceArn != other.idNamespaceArn) return false
        if (idNamespaceName != other.idNamespaceName) return false
        if (type != other.type) return false
        if (updatedAt != other.updatedAt) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.entityresolution.model.IdNamespaceSummary = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The timestamp of when the ID namespace was created.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The description of the ID namespace.
         */
        public var description: kotlin.String? = null
        /**
         * An object which defines any additional configurations required by the ID mapping workflow.
         */
        public var idMappingWorkflowProperties: List<IdNamespaceIdMappingWorkflowMetadata>? = null
        /**
         * The Amazon Resource Name (ARN) of the ID namespace.
         */
        public var idNamespaceArn: kotlin.String? = null
        /**
         * The name of the ID namespace.
         */
        public var idNamespaceName: kotlin.String? = null
        /**
         * The type of ID namespace. There are two types: `SOURCE` and `TARGET`.
         *
         * The `SOURCE` contains configurations for `sourceId` data that will be processed in an ID mapping workflow.
         *
         * The `TARGET` contains a configuration of `targetId` which all `sourceIds` will resolve to.
         */
        public var type: aws.sdk.kotlin.services.entityresolution.model.IdNamespaceType? = null
        /**
         * The timestamp of when the ID namespace was last updated.
         */
        public var updatedAt: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.entityresolution.model.IdNamespaceSummary) : this() {
            this.createdAt = x.createdAt
            this.description = x.description
            this.idMappingWorkflowProperties = x.idMappingWorkflowProperties
            this.idNamespaceArn = x.idNamespaceArn
            this.idNamespaceName = x.idNamespaceName
            this.type = x.type
            this.updatedAt = x.updatedAt
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.entityresolution.model.IdNamespaceSummary = IdNamespaceSummary(this)

        internal fun correctErrors(): Builder {
            if (createdAt == null) createdAt = Instant.fromEpochSeconds(0)
            if (idNamespaceArn == null) idNamespaceArn = ""
            if (idNamespaceName == null) idNamespaceName = ""
            if (type == null) type = IdNamespaceType.SdkUnknown("no value provided")
            if (updatedAt == null) updatedAt = Instant.fromEpochSeconds(0)
            return this
        }
    }
}
