// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.entityresolution.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * An object containing `InputSourceARN`, `SchemaName`, and `Type`.
 */
public class IdMappingWorkflowInputSource private constructor(builder: Builder) {
    /**
     * An Glue table Amazon Resource Name (ARN) or a matching workflow ARN for the input source table.
     */
    public val inputSourceArn: kotlin.String = requireNotNull(builder.inputSourceArn) { "A non-null value must be provided for inputSourceArn" }
    /**
     * The name of the schema to be retrieved.
     */
    public val schemaName: kotlin.String? = builder.schemaName
    /**
     * The type of ID namespace. There are two types: `SOURCE` and `TARGET`.
     *
     * The `SOURCE` contains configurations for `sourceId` data that will be processed in an ID mapping workflow.
     *
     * The `TARGET` contains a configuration of `targetId` which all `sourceIds` will resolve to.
     */
    public val type: aws.sdk.kotlin.services.entityresolution.model.IdNamespaceType? = builder.type

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.entityresolution.model.IdMappingWorkflowInputSource = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("IdMappingWorkflowInputSource(")
        append("inputSourceArn=$inputSourceArn,")
        append("schemaName=$schemaName,")
        append("type=$type")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = inputSourceArn.hashCode()
        result = 31 * result + (schemaName?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as IdMappingWorkflowInputSource

        if (inputSourceArn != other.inputSourceArn) return false
        if (schemaName != other.schemaName) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.entityresolution.model.IdMappingWorkflowInputSource = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * An Glue table Amazon Resource Name (ARN) or a matching workflow ARN for the input source table.
         */
        public var inputSourceArn: kotlin.String? = null
        /**
         * The name of the schema to be retrieved.
         */
        public var schemaName: kotlin.String? = null
        /**
         * The type of ID namespace. There are two types: `SOURCE` and `TARGET`.
         *
         * The `SOURCE` contains configurations for `sourceId` data that will be processed in an ID mapping workflow.
         *
         * The `TARGET` contains a configuration of `targetId` which all `sourceIds` will resolve to.
         */
        public var type: aws.sdk.kotlin.services.entityresolution.model.IdNamespaceType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.entityresolution.model.IdMappingWorkflowInputSource) : this() {
            this.inputSourceArn = x.inputSourceArn
            this.schemaName = x.schemaName
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.entityresolution.model.IdMappingWorkflowInputSource = IdMappingWorkflowInputSource(this)

        internal fun correctErrors(): Builder {
            if (inputSourceArn == null) inputSourceArn = ""
            return this
        }
    }
}
