// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.entityresolution.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * An object that defines the list of matching rules to run in an ID mapping workflow.
 */
public class IdMappingRuleBasedProperties private constructor(builder: Builder) {
    /**
     * The comparison type. You can either choose `ONE_TO_ONE` or `MANY_TO_MANY` as the `attributeMatchingModel`.
     *
     * If you choose `MANY_TO_MANY`, the system can match attributes across the sub-types of an attribute type. For example, if the value of the `Email` field of Profile A matches the value of the `BusinessEmail` field of Profile B, the two profiles are matched on the `Email` attribute type.
     *
     * If you choose `ONE_TO_ONE`, the system can only match attributes if the sub-types are an exact match. For example, for the `Email` attribute type, the system will only consider it a match if the value of the `Email` field of Profile A matches the value of the `Email` field of Profile B.
     */
    public val attributeMatchingModel: aws.sdk.kotlin.services.entityresolution.model.AttributeMatchingModel = requireNotNull(builder.attributeMatchingModel) { "A non-null value must be provided for attributeMatchingModel" }
    /**
     * The type of matching record that is allowed to be used in an ID mapping workflow.
     *
     * If the value is set to `ONE_SOURCE_TO_ONE_TARGET`, only one record in the source can be matched to the same record in the target.
     *
     * If the value is set to `MANY_SOURCE_TO_ONE_TARGET`, multiple records in the source can be matched to one record in the target.
     */
    public val recordMatchingModel: aws.sdk.kotlin.services.entityresolution.model.RecordMatchingModel = requireNotNull(builder.recordMatchingModel) { "A non-null value must be provided for recordMatchingModel" }
    /**
     * The set of rules you can use in an ID mapping workflow. The limitations specified for the source or target to define the match rules must be compatible.
     */
    public val ruleDefinitionType: aws.sdk.kotlin.services.entityresolution.model.IdMappingWorkflowRuleDefinitionType = requireNotNull(builder.ruleDefinitionType) { "A non-null value must be provided for ruleDefinitionType" }
    /**
     * The rules that can be used for ID mapping.
     */
    public val rules: List<Rule>? = builder.rules

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.entityresolution.model.IdMappingRuleBasedProperties = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("IdMappingRuleBasedProperties(")
        append("attributeMatchingModel=$attributeMatchingModel,")
        append("recordMatchingModel=$recordMatchingModel,")
        append("ruleDefinitionType=$ruleDefinitionType,")
        append("rules=$rules")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = attributeMatchingModel.hashCode()
        result = 31 * result + (recordMatchingModel.hashCode())
        result = 31 * result + (ruleDefinitionType.hashCode())
        result = 31 * result + (rules?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as IdMappingRuleBasedProperties

        if (attributeMatchingModel != other.attributeMatchingModel) return false
        if (recordMatchingModel != other.recordMatchingModel) return false
        if (ruleDefinitionType != other.ruleDefinitionType) return false
        if (rules != other.rules) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.entityresolution.model.IdMappingRuleBasedProperties = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The comparison type. You can either choose `ONE_TO_ONE` or `MANY_TO_MANY` as the `attributeMatchingModel`.
         *
         * If you choose `MANY_TO_MANY`, the system can match attributes across the sub-types of an attribute type. For example, if the value of the `Email` field of Profile A matches the value of the `BusinessEmail` field of Profile B, the two profiles are matched on the `Email` attribute type.
         *
         * If you choose `ONE_TO_ONE`, the system can only match attributes if the sub-types are an exact match. For example, for the `Email` attribute type, the system will only consider it a match if the value of the `Email` field of Profile A matches the value of the `Email` field of Profile B.
         */
        public var attributeMatchingModel: aws.sdk.kotlin.services.entityresolution.model.AttributeMatchingModel? = null
        /**
         * The type of matching record that is allowed to be used in an ID mapping workflow.
         *
         * If the value is set to `ONE_SOURCE_TO_ONE_TARGET`, only one record in the source can be matched to the same record in the target.
         *
         * If the value is set to `MANY_SOURCE_TO_ONE_TARGET`, multiple records in the source can be matched to one record in the target.
         */
        public var recordMatchingModel: aws.sdk.kotlin.services.entityresolution.model.RecordMatchingModel? = null
        /**
         * The set of rules you can use in an ID mapping workflow. The limitations specified for the source or target to define the match rules must be compatible.
         */
        public var ruleDefinitionType: aws.sdk.kotlin.services.entityresolution.model.IdMappingWorkflowRuleDefinitionType? = null
        /**
         * The rules that can be used for ID mapping.
         */
        public var rules: List<Rule>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.entityresolution.model.IdMappingRuleBasedProperties) : this() {
            this.attributeMatchingModel = x.attributeMatchingModel
            this.recordMatchingModel = x.recordMatchingModel
            this.ruleDefinitionType = x.ruleDefinitionType
            this.rules = x.rules
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.entityresolution.model.IdMappingRuleBasedProperties = IdMappingRuleBasedProperties(this)

        internal fun correctErrors(): Builder {
            if (attributeMatchingModel == null) attributeMatchingModel = AttributeMatchingModel.SdkUnknown("no value provided")
            if (recordMatchingModel == null) recordMatchingModel = RecordMatchingModel.SdkUnknown("no value provided")
            if (ruleDefinitionType == null) ruleDefinitionType = IdMappingWorkflowRuleDefinitionType.SdkUnknown("no value provided")
            return this
        }
    }
}
