// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.entityresolution

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.client.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.config.endpoints.resolveEndpointUrl
import aws.sdk.kotlin.runtime.config.profile.AwsProfile
import aws.sdk.kotlin.runtime.config.profile.AwsSharedConfig
import aws.sdk.kotlin.runtime.http.retries.AwsRetryPolicy
import aws.sdk.kotlin.services.entityresolution.auth.DefaultEntityResolutionAuthSchemeProvider
import aws.sdk.kotlin.services.entityresolution.auth.EntityResolutionAuthSchemeProvider
import aws.sdk.kotlin.services.entityresolution.endpoints.DefaultEntityResolutionEndpointProvider
import aws.sdk.kotlin.services.entityresolution.endpoints.EntityResolutionEndpointParameters
import aws.sdk.kotlin.services.entityresolution.endpoints.EntityResolutionEndpointProvider
import aws.sdk.kotlin.services.entityresolution.model.AddPolicyStatementRequest
import aws.sdk.kotlin.services.entityresolution.model.AddPolicyStatementResponse
import aws.sdk.kotlin.services.entityresolution.model.BatchDeleteUniqueIdRequest
import aws.sdk.kotlin.services.entityresolution.model.BatchDeleteUniqueIdResponse
import aws.sdk.kotlin.services.entityresolution.model.CreateIdMappingWorkflowRequest
import aws.sdk.kotlin.services.entityresolution.model.CreateIdMappingWorkflowResponse
import aws.sdk.kotlin.services.entityresolution.model.CreateIdNamespaceRequest
import aws.sdk.kotlin.services.entityresolution.model.CreateIdNamespaceResponse
import aws.sdk.kotlin.services.entityresolution.model.CreateMatchingWorkflowRequest
import aws.sdk.kotlin.services.entityresolution.model.CreateMatchingWorkflowResponse
import aws.sdk.kotlin.services.entityresolution.model.CreateSchemaMappingRequest
import aws.sdk.kotlin.services.entityresolution.model.CreateSchemaMappingResponse
import aws.sdk.kotlin.services.entityresolution.model.DeleteIdMappingWorkflowRequest
import aws.sdk.kotlin.services.entityresolution.model.DeleteIdMappingWorkflowResponse
import aws.sdk.kotlin.services.entityresolution.model.DeleteIdNamespaceRequest
import aws.sdk.kotlin.services.entityresolution.model.DeleteIdNamespaceResponse
import aws.sdk.kotlin.services.entityresolution.model.DeleteMatchingWorkflowRequest
import aws.sdk.kotlin.services.entityresolution.model.DeleteMatchingWorkflowResponse
import aws.sdk.kotlin.services.entityresolution.model.DeletePolicyStatementRequest
import aws.sdk.kotlin.services.entityresolution.model.DeletePolicyStatementResponse
import aws.sdk.kotlin.services.entityresolution.model.DeleteSchemaMappingRequest
import aws.sdk.kotlin.services.entityresolution.model.DeleteSchemaMappingResponse
import aws.sdk.kotlin.services.entityresolution.model.GetIdMappingJobRequest
import aws.sdk.kotlin.services.entityresolution.model.GetIdMappingJobResponse
import aws.sdk.kotlin.services.entityresolution.model.GetIdMappingWorkflowRequest
import aws.sdk.kotlin.services.entityresolution.model.GetIdMappingWorkflowResponse
import aws.sdk.kotlin.services.entityresolution.model.GetIdNamespaceRequest
import aws.sdk.kotlin.services.entityresolution.model.GetIdNamespaceResponse
import aws.sdk.kotlin.services.entityresolution.model.GetMatchIdRequest
import aws.sdk.kotlin.services.entityresolution.model.GetMatchIdResponse
import aws.sdk.kotlin.services.entityresolution.model.GetMatchingJobRequest
import aws.sdk.kotlin.services.entityresolution.model.GetMatchingJobResponse
import aws.sdk.kotlin.services.entityresolution.model.GetMatchingWorkflowRequest
import aws.sdk.kotlin.services.entityresolution.model.GetMatchingWorkflowResponse
import aws.sdk.kotlin.services.entityresolution.model.GetPolicyRequest
import aws.sdk.kotlin.services.entityresolution.model.GetPolicyResponse
import aws.sdk.kotlin.services.entityresolution.model.GetProviderServiceRequest
import aws.sdk.kotlin.services.entityresolution.model.GetProviderServiceResponse
import aws.sdk.kotlin.services.entityresolution.model.GetSchemaMappingRequest
import aws.sdk.kotlin.services.entityresolution.model.GetSchemaMappingResponse
import aws.sdk.kotlin.services.entityresolution.model.ListIdMappingJobsRequest
import aws.sdk.kotlin.services.entityresolution.model.ListIdMappingJobsResponse
import aws.sdk.kotlin.services.entityresolution.model.ListIdMappingWorkflowsRequest
import aws.sdk.kotlin.services.entityresolution.model.ListIdMappingWorkflowsResponse
import aws.sdk.kotlin.services.entityresolution.model.ListIdNamespacesRequest
import aws.sdk.kotlin.services.entityresolution.model.ListIdNamespacesResponse
import aws.sdk.kotlin.services.entityresolution.model.ListMatchingJobsRequest
import aws.sdk.kotlin.services.entityresolution.model.ListMatchingJobsResponse
import aws.sdk.kotlin.services.entityresolution.model.ListMatchingWorkflowsRequest
import aws.sdk.kotlin.services.entityresolution.model.ListMatchingWorkflowsResponse
import aws.sdk.kotlin.services.entityresolution.model.ListProviderServicesRequest
import aws.sdk.kotlin.services.entityresolution.model.ListProviderServicesResponse
import aws.sdk.kotlin.services.entityresolution.model.ListSchemaMappingsRequest
import aws.sdk.kotlin.services.entityresolution.model.ListSchemaMappingsResponse
import aws.sdk.kotlin.services.entityresolution.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.entityresolution.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.entityresolution.model.PutPolicyRequest
import aws.sdk.kotlin.services.entityresolution.model.PutPolicyResponse
import aws.sdk.kotlin.services.entityresolution.model.StartIdMappingJobRequest
import aws.sdk.kotlin.services.entityresolution.model.StartIdMappingJobResponse
import aws.sdk.kotlin.services.entityresolution.model.StartMatchingJobRequest
import aws.sdk.kotlin.services.entityresolution.model.StartMatchingJobResponse
import aws.sdk.kotlin.services.entityresolution.model.TagResourceRequest
import aws.sdk.kotlin.services.entityresolution.model.TagResourceResponse
import aws.sdk.kotlin.services.entityresolution.model.UntagResourceRequest
import aws.sdk.kotlin.services.entityresolution.model.UntagResourceResponse
import aws.sdk.kotlin.services.entityresolution.model.UpdateIdMappingWorkflowRequest
import aws.sdk.kotlin.services.entityresolution.model.UpdateIdMappingWorkflowResponse
import aws.sdk.kotlin.services.entityresolution.model.UpdateIdNamespaceRequest
import aws.sdk.kotlin.services.entityresolution.model.UpdateIdNamespaceResponse
import aws.sdk.kotlin.services.entityresolution.model.UpdateMatchingWorkflowRequest
import aws.sdk.kotlin.services.entityresolution.model.UpdateMatchingWorkflowResponse
import aws.sdk.kotlin.services.entityresolution.model.UpdateSchemaMappingRequest
import aws.sdk.kotlin.services.entityresolution.model.UpdateSchemaMappingResponse
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.awsprotocol.ClockSkewInterceptor
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.AbstractSdkClientFactory
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.url.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.telemetry.Global
import aws.smithy.kotlin.runtime.telemetry.TelemetryConfig
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider
import aws.smithy.kotlin.runtime.util.LazyAsyncValue
import kotlin.collections.List
import kotlin.jvm.JvmStatic


public const val ServiceId: String = "EntityResolution"
public const val SdkVersion: String = "1.3.42"
public const val ServiceApiVersion: String = "2018-05-10"

/**
 * Welcome to the *Entity Resolution API Reference*.
 *
 * Entity Resolution is an Amazon Web Services service that provides pre-configured entity resolution capabilities that enable developers and analysts at advertising and marketing companies to build an accurate and complete view of their consumers.
 *
 *  With Entity Resolution, you can match source records containing consumer identifiers, such as name, email address, and phone number. This is true even when these records have incomplete or conflicting identifiers. For example, Entity Resolution can effectively match a source record from a customer relationship management (CRM) system with a source record from a marketing system containing campaign information.
 *
 * To learn more about Entity Resolution concepts, procedures, and best practices, see the [Entity Resolution User Guide](https://docs.aws.amazon.com/entityresolution/latest/userguide/what-is-service.html).
 */
public interface EntityResolutionClient : SdkClient {
    /**
     * EntityResolutionClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, EntityResolutionClient, Builder>()
     {
        @JvmStatic
        override fun builder(): Builder = Builder()

        override fun finalizeConfig(builder: Builder) {
            super.finalizeConfig(builder)
            builder.config.interceptors.add(0, ClockSkewInterceptor())
        }

        override suspend fun finalizeEnvironmentalConfig(builder: Builder, sharedConfig: LazyAsyncValue<AwsSharedConfig>, activeProfile: LazyAsyncValue<AwsProfile>) {
            super.finalizeEnvironmentalConfig(builder, sharedConfig, activeProfile)
            builder.config.endpointUrl = builder.config.endpointUrl ?: resolveEndpointUrl(
                sharedConfig,
                "EntityResolution",
                "ENTITYRESOLUTION",
                "entityresolution",
            )
        }
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, EntityResolutionClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): EntityResolutionClient = DefaultEntityResolutionClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TelemetryConfig {
        override val clientName: String = builder.clientName
        override val region: String? = builder.region
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = builder.authSchemes
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointProvider: EntityResolutionEndpointProvider = builder.endpointProvider ?: DefaultEntityResolutionEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsRetryPolicy.Default
        override val telemetryProvider: TelemetryProvider = builder.telemetryProvider ?: TelemetryProvider.Global
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        override val applicationId: String? = builder.applicationId
        public val authSchemeProvider: EntityResolutionAuthSchemeProvider = builder.authSchemeProvider ?: DefaultEntityResolutionAuthSchemeProvider()
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            authSchemes = this@Config.authSchemes
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            telemetryProvider = this@Config.telemetryProvider
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
            applicationId = this@Config.applicationId
            authSchemeProvider = this@Config.authSchemeProvider
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TelemetryConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "EntityResolution"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more
             * information
             */
            override var region: String? = null

            /**
             * Register new or override default [AuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = emptyList()

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: EntityResolutionEndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The telemetry provider used to instrument the SDK operations with. By default, the global telemetry
             * provider will be used.
             */
            override var telemetryProvider: TelemetryProvider? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            /**
             * An optional application specific identifier.
             * When set it will be appended to the User-Agent header of every request in the form of: `app/{applicationId}`.
             * When not explicitly set, the value will be loaded from the following locations:
             *
             * - JVM System Property: `aws.userAgentAppId`
             * - Environment variable: `AWS_SDK_UA_APP_ID`
             * - Shared configuration profile attribute: `sdk_ua_app_id`
             *
             * See [shared configuration settings](https://docs.aws.amazon.com/sdkref/latest/guide/settings-reference.html)
             * reference for more information on environment variables and shared config settings.
             */
            override var applicationId: String? = null

            /**
             * Configure the provider used to resolve the authentication scheme to use for a particular operation.
             */
            public var authSchemeProvider: EntityResolutionAuthSchemeProvider? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Adds a policy statement object. To retrieve a list of existing policy statements, use the `GetPolicy` API.
     */
    public suspend fun addPolicyStatement(input: AddPolicyStatementRequest): AddPolicyStatementResponse

    /**
     * Deletes multiple unique IDs in a matching workflow.
     */
    public suspend fun batchDeleteUniqueId(input: BatchDeleteUniqueIdRequest): BatchDeleteUniqueIdResponse

    /**
     * Creates an `IdMappingWorkflow` object which stores the configuration of the data processing job to be run. Each `IdMappingWorkflow` must have a unique workflow name. To modify an existing workflow, use the `UpdateIdMappingWorkflow` API.
     */
    public suspend fun createIdMappingWorkflow(input: CreateIdMappingWorkflowRequest): CreateIdMappingWorkflowResponse

    /**
     * Creates an ID namespace object which will help customers provide metadata explaining their dataset and how to use it. Each ID namespace must have a unique name. To modify an existing ID namespace, use the `UpdateIdNamespace` API.
     */
    public suspend fun createIdNamespace(input: CreateIdNamespaceRequest): CreateIdNamespaceResponse

    /**
     * Creates a `MatchingWorkflow` object which stores the configuration of the data processing job to be run. It is important to note that there should not be a pre-existing `MatchingWorkflow` with the same name. To modify an existing workflow, utilize the `UpdateMatchingWorkflow` API.
     */
    public suspend fun createMatchingWorkflow(input: CreateMatchingWorkflowRequest): CreateMatchingWorkflowResponse

    /**
     * Creates a schema mapping, which defines the schema of the input customer records table. The `SchemaMapping` also provides Entity Resolution with some metadata about the table, such as the attribute types of the columns and which columns to match on.
     */
    public suspend fun createSchemaMapping(input: CreateSchemaMappingRequest): CreateSchemaMappingResponse

    /**
     * Deletes the `IdMappingWorkflow` with a given name. This operation will succeed even if a workflow with the given name does not exist.
     */
    public suspend fun deleteIdMappingWorkflow(input: DeleteIdMappingWorkflowRequest): DeleteIdMappingWorkflowResponse

    /**
     * Deletes the `IdNamespace` with a given name.
     */
    public suspend fun deleteIdNamespace(input: DeleteIdNamespaceRequest): DeleteIdNamespaceResponse

    /**
     * Deletes the `MatchingWorkflow` with a given name. This operation will succeed even if a workflow with the given name does not exist.
     */
    public suspend fun deleteMatchingWorkflow(input: DeleteMatchingWorkflowRequest): DeleteMatchingWorkflowResponse

    /**
     * Deletes the policy statement.
     */
    public suspend fun deletePolicyStatement(input: DeletePolicyStatementRequest): DeletePolicyStatementResponse

    /**
     * Deletes the `SchemaMapping` with a given name. This operation will succeed even if a schema with the given name does not exist. This operation will fail if there is a `MatchingWorkflow` object that references the `SchemaMapping` in the workflow's `InputSourceConfig`.
     */
    public suspend fun deleteSchemaMapping(input: DeleteSchemaMappingRequest): DeleteSchemaMappingResponse

    /**
     * Gets the status, metrics, and errors (if there are any) that are associated with a job.
     */
    public suspend fun getIdMappingJob(input: GetIdMappingJobRequest): GetIdMappingJobResponse

    /**
     * Returns the `IdMappingWorkflow` with a given name, if it exists.
     */
    public suspend fun getIdMappingWorkflow(input: GetIdMappingWorkflowRequest): GetIdMappingWorkflowResponse

    /**
     * Returns the `IdNamespace` with a given name, if it exists.
     */
    public suspend fun getIdNamespace(input: GetIdNamespaceRequest): GetIdNamespaceResponse

    /**
     * Returns the corresponding Match ID of a customer record if the record has been processed.
     */
    public suspend fun getMatchId(input: GetMatchIdRequest): GetMatchIdResponse

    /**
     * Gets the status, metrics, and errors (if there are any) that are associated with a job.
     */
    public suspend fun getMatchingJob(input: GetMatchingJobRequest): GetMatchingJobResponse

    /**
     * Returns the `MatchingWorkflow` with a given name, if it exists.
     */
    public suspend fun getMatchingWorkflow(input: GetMatchingWorkflowRequest): GetMatchingWorkflowResponse

    /**
     * Returns the resource-based policy.
     */
    public suspend fun getPolicy(input: GetPolicyRequest): GetPolicyResponse

    /**
     * Returns the `ProviderService` of a given name.
     */
    public suspend fun getProviderService(input: GetProviderServiceRequest): GetProviderServiceResponse

    /**
     * Returns the SchemaMapping of a given name.
     */
    public suspend fun getSchemaMapping(input: GetSchemaMappingRequest): GetSchemaMappingResponse

    /**
     * Lists all ID mapping jobs for a given workflow.
     */
    public suspend fun listIdMappingJobs(input: ListIdMappingJobsRequest): ListIdMappingJobsResponse

    /**
     * Returns a list of all the `IdMappingWorkflows` that have been created for an Amazon Web Services account.
     */
    public suspend fun listIdMappingWorkflows(input: ListIdMappingWorkflowsRequest = ListIdMappingWorkflowsRequest { }): ListIdMappingWorkflowsResponse

    /**
     * Returns a list of all ID namespaces.
     */
    public suspend fun listIdNamespaces(input: ListIdNamespacesRequest = ListIdNamespacesRequest { }): ListIdNamespacesResponse

    /**
     * Lists all jobs for a given workflow.
     */
    public suspend fun listMatchingJobs(input: ListMatchingJobsRequest): ListMatchingJobsResponse

    /**
     * Returns a list of all the `MatchingWorkflows` that have been created for an Amazon Web Services account.
     */
    public suspend fun listMatchingWorkflows(input: ListMatchingWorkflowsRequest = ListMatchingWorkflowsRequest { }): ListMatchingWorkflowsResponse

    /**
     * Returns a list of all the `ProviderServices` that are available in this Amazon Web Services Region.
     */
    public suspend fun listProviderServices(input: ListProviderServicesRequest = ListProviderServicesRequest { }): ListProviderServicesResponse

    /**
     * Returns a list of all the `SchemaMappings` that have been created for an Amazon Web Services account.
     */
    public suspend fun listSchemaMappings(input: ListSchemaMappingsRequest = ListSchemaMappingsRequest { }): ListSchemaMappingsResponse

    /**
     * Displays the tags associated with an Entity Resolution resource. In Entity Resolution, `SchemaMapping`, and `MatchingWorkflow` can be tagged.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Updates the resource-based policy.
     */
    public suspend fun putPolicy(input: PutPolicyRequest): PutPolicyResponse

    /**
     * Starts the `IdMappingJob` of a workflow. The workflow must have previously been created using the `CreateIdMappingWorkflow` endpoint.
     */
    public suspend fun startIdMappingJob(input: StartIdMappingJobRequest): StartIdMappingJobResponse

    /**
     * Starts the `MatchingJob` of a workflow. The workflow must have previously been created using the `CreateMatchingWorkflow` endpoint.
     */
    public suspend fun startMatchingJob(input: StartMatchingJobRequest): StartMatchingJobResponse

    /**
     * Assigns one or more tags (key-value pairs) to the specified Entity Resolution resource. Tags can help you organize and categorize your resources. You can also use them to scope user permissions by granting a user permission to access or change only resources with certain tag values. In Entity Resolution, `SchemaMapping` and `MatchingWorkflow` can be tagged. Tags don't have any semantic meaning to Amazon Web Services and are interpreted strictly as strings of characters. You can use the `TagResource` action with a resource that already has tags. If you specify a new tag key, this tag is appended to the list of tags associated with the resource. If you specify a tag key that is already associated with the resource, the new tag value that you specify replaces the previous value for that tag.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Removes one or more tags from the specified Entity Resolution resource. In Entity Resolution, `SchemaMapping`, and `MatchingWorkflow` can be tagged.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Updates an existing `IdMappingWorkflow`. This method is identical to `CreateIdMappingWorkflow`, except it uses an HTTP `PUT` request instead of a `POST` request, and the `IdMappingWorkflow` must already exist for the method to succeed.
     */
    public suspend fun updateIdMappingWorkflow(input: UpdateIdMappingWorkflowRequest): UpdateIdMappingWorkflowResponse

    /**
     * Updates an existing ID namespace.
     */
    public suspend fun updateIdNamespace(input: UpdateIdNamespaceRequest): UpdateIdNamespaceResponse

    /**
     * Updates an existing `MatchingWorkflow`. This method is identical to `CreateMatchingWorkflow`, except it uses an HTTP `PUT` request instead of a `POST` request, and the `MatchingWorkflow` must already exist for the method to succeed.
     */
    public suspend fun updateMatchingWorkflow(input: UpdateMatchingWorkflowRequest): UpdateMatchingWorkflowResponse

    /**
     * Updates a schema mapping.
     *
     * A schema is immutable if it is being used by a workflow. Therefore, you can't update a schema mapping if it's associated with a workflow.
     */
    public suspend fun updateSchemaMapping(input: UpdateSchemaMappingRequest): UpdateSchemaMappingResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun EntityResolutionClient.withConfig(block: EntityResolutionClient.Config.Builder.() -> Unit): EntityResolutionClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultEntityResolutionClient(newConfig)
}

/**
 * Adds a policy statement object. To retrieve a list of existing policy statements, use the `GetPolicy` API.
 */
public suspend inline fun EntityResolutionClient.addPolicyStatement(crossinline block: AddPolicyStatementRequest.Builder.() -> Unit): AddPolicyStatementResponse = addPolicyStatement(AddPolicyStatementRequest.Builder().apply(block).build())

/**
 * Deletes multiple unique IDs in a matching workflow.
 */
public suspend inline fun EntityResolutionClient.batchDeleteUniqueId(crossinline block: BatchDeleteUniqueIdRequest.Builder.() -> Unit): BatchDeleteUniqueIdResponse = batchDeleteUniqueId(BatchDeleteUniqueIdRequest.Builder().apply(block).build())

/**
 * Creates an `IdMappingWorkflow` object which stores the configuration of the data processing job to be run. Each `IdMappingWorkflow` must have a unique workflow name. To modify an existing workflow, use the `UpdateIdMappingWorkflow` API.
 */
public suspend inline fun EntityResolutionClient.createIdMappingWorkflow(crossinline block: CreateIdMappingWorkflowRequest.Builder.() -> Unit): CreateIdMappingWorkflowResponse = createIdMappingWorkflow(CreateIdMappingWorkflowRequest.Builder().apply(block).build())

/**
 * Creates an ID namespace object which will help customers provide metadata explaining their dataset and how to use it. Each ID namespace must have a unique name. To modify an existing ID namespace, use the `UpdateIdNamespace` API.
 */
public suspend inline fun EntityResolutionClient.createIdNamespace(crossinline block: CreateIdNamespaceRequest.Builder.() -> Unit): CreateIdNamespaceResponse = createIdNamespace(CreateIdNamespaceRequest.Builder().apply(block).build())

/**
 * Creates a `MatchingWorkflow` object which stores the configuration of the data processing job to be run. It is important to note that there should not be a pre-existing `MatchingWorkflow` with the same name. To modify an existing workflow, utilize the `UpdateMatchingWorkflow` API.
 */
public suspend inline fun EntityResolutionClient.createMatchingWorkflow(crossinline block: CreateMatchingWorkflowRequest.Builder.() -> Unit): CreateMatchingWorkflowResponse = createMatchingWorkflow(CreateMatchingWorkflowRequest.Builder().apply(block).build())

/**
 * Creates a schema mapping, which defines the schema of the input customer records table. The `SchemaMapping` also provides Entity Resolution with some metadata about the table, such as the attribute types of the columns and which columns to match on.
 */
public suspend inline fun EntityResolutionClient.createSchemaMapping(crossinline block: CreateSchemaMappingRequest.Builder.() -> Unit): CreateSchemaMappingResponse = createSchemaMapping(CreateSchemaMappingRequest.Builder().apply(block).build())

/**
 * Deletes the `IdMappingWorkflow` with a given name. This operation will succeed even if a workflow with the given name does not exist.
 */
public suspend inline fun EntityResolutionClient.deleteIdMappingWorkflow(crossinline block: DeleteIdMappingWorkflowRequest.Builder.() -> Unit): DeleteIdMappingWorkflowResponse = deleteIdMappingWorkflow(DeleteIdMappingWorkflowRequest.Builder().apply(block).build())

/**
 * Deletes the `IdNamespace` with a given name.
 */
public suspend inline fun EntityResolutionClient.deleteIdNamespace(crossinline block: DeleteIdNamespaceRequest.Builder.() -> Unit): DeleteIdNamespaceResponse = deleteIdNamespace(DeleteIdNamespaceRequest.Builder().apply(block).build())

/**
 * Deletes the `MatchingWorkflow` with a given name. This operation will succeed even if a workflow with the given name does not exist.
 */
public suspend inline fun EntityResolutionClient.deleteMatchingWorkflow(crossinline block: DeleteMatchingWorkflowRequest.Builder.() -> Unit): DeleteMatchingWorkflowResponse = deleteMatchingWorkflow(DeleteMatchingWorkflowRequest.Builder().apply(block).build())

/**
 * Deletes the policy statement.
 */
public suspend inline fun EntityResolutionClient.deletePolicyStatement(crossinline block: DeletePolicyStatementRequest.Builder.() -> Unit): DeletePolicyStatementResponse = deletePolicyStatement(DeletePolicyStatementRequest.Builder().apply(block).build())

/**
 * Deletes the `SchemaMapping` with a given name. This operation will succeed even if a schema with the given name does not exist. This operation will fail if there is a `MatchingWorkflow` object that references the `SchemaMapping` in the workflow's `InputSourceConfig`.
 */
public suspend inline fun EntityResolutionClient.deleteSchemaMapping(crossinline block: DeleteSchemaMappingRequest.Builder.() -> Unit): DeleteSchemaMappingResponse = deleteSchemaMapping(DeleteSchemaMappingRequest.Builder().apply(block).build())

/**
 * Gets the status, metrics, and errors (if there are any) that are associated with a job.
 */
public suspend inline fun EntityResolutionClient.getIdMappingJob(crossinline block: GetIdMappingJobRequest.Builder.() -> Unit): GetIdMappingJobResponse = getIdMappingJob(GetIdMappingJobRequest.Builder().apply(block).build())

/**
 * Returns the `IdMappingWorkflow` with a given name, if it exists.
 */
public suspend inline fun EntityResolutionClient.getIdMappingWorkflow(crossinline block: GetIdMappingWorkflowRequest.Builder.() -> Unit): GetIdMappingWorkflowResponse = getIdMappingWorkflow(GetIdMappingWorkflowRequest.Builder().apply(block).build())

/**
 * Returns the `IdNamespace` with a given name, if it exists.
 */
public suspend inline fun EntityResolutionClient.getIdNamespace(crossinline block: GetIdNamespaceRequest.Builder.() -> Unit): GetIdNamespaceResponse = getIdNamespace(GetIdNamespaceRequest.Builder().apply(block).build())

/**
 * Returns the corresponding Match ID of a customer record if the record has been processed.
 */
public suspend inline fun EntityResolutionClient.getMatchId(crossinline block: GetMatchIdRequest.Builder.() -> Unit): GetMatchIdResponse = getMatchId(GetMatchIdRequest.Builder().apply(block).build())

/**
 * Gets the status, metrics, and errors (if there are any) that are associated with a job.
 */
public suspend inline fun EntityResolutionClient.getMatchingJob(crossinline block: GetMatchingJobRequest.Builder.() -> Unit): GetMatchingJobResponse = getMatchingJob(GetMatchingJobRequest.Builder().apply(block).build())

/**
 * Returns the `MatchingWorkflow` with a given name, if it exists.
 */
public suspend inline fun EntityResolutionClient.getMatchingWorkflow(crossinline block: GetMatchingWorkflowRequest.Builder.() -> Unit): GetMatchingWorkflowResponse = getMatchingWorkflow(GetMatchingWorkflowRequest.Builder().apply(block).build())

/**
 * Returns the resource-based policy.
 */
public suspend inline fun EntityResolutionClient.getPolicy(crossinline block: GetPolicyRequest.Builder.() -> Unit): GetPolicyResponse = getPolicy(GetPolicyRequest.Builder().apply(block).build())

/**
 * Returns the `ProviderService` of a given name.
 */
public suspend inline fun EntityResolutionClient.getProviderService(crossinline block: GetProviderServiceRequest.Builder.() -> Unit): GetProviderServiceResponse = getProviderService(GetProviderServiceRequest.Builder().apply(block).build())

/**
 * Returns the SchemaMapping of a given name.
 */
public suspend inline fun EntityResolutionClient.getSchemaMapping(crossinline block: GetSchemaMappingRequest.Builder.() -> Unit): GetSchemaMappingResponse = getSchemaMapping(GetSchemaMappingRequest.Builder().apply(block).build())

/**
 * Lists all ID mapping jobs for a given workflow.
 */
public suspend inline fun EntityResolutionClient.listIdMappingJobs(crossinline block: ListIdMappingJobsRequest.Builder.() -> Unit): ListIdMappingJobsResponse = listIdMappingJobs(ListIdMappingJobsRequest.Builder().apply(block).build())

/**
 * Returns a list of all the `IdMappingWorkflows` that have been created for an Amazon Web Services account.
 */
public suspend inline fun EntityResolutionClient.listIdMappingWorkflows(crossinline block: ListIdMappingWorkflowsRequest.Builder.() -> Unit): ListIdMappingWorkflowsResponse = listIdMappingWorkflows(ListIdMappingWorkflowsRequest.Builder().apply(block).build())

/**
 * Returns a list of all ID namespaces.
 */
public suspend inline fun EntityResolutionClient.listIdNamespaces(crossinline block: ListIdNamespacesRequest.Builder.() -> Unit): ListIdNamespacesResponse = listIdNamespaces(ListIdNamespacesRequest.Builder().apply(block).build())

/**
 * Lists all jobs for a given workflow.
 */
public suspend inline fun EntityResolutionClient.listMatchingJobs(crossinline block: ListMatchingJobsRequest.Builder.() -> Unit): ListMatchingJobsResponse = listMatchingJobs(ListMatchingJobsRequest.Builder().apply(block).build())

/**
 * Returns a list of all the `MatchingWorkflows` that have been created for an Amazon Web Services account.
 */
public suspend inline fun EntityResolutionClient.listMatchingWorkflows(crossinline block: ListMatchingWorkflowsRequest.Builder.() -> Unit): ListMatchingWorkflowsResponse = listMatchingWorkflows(ListMatchingWorkflowsRequest.Builder().apply(block).build())

/**
 * Returns a list of all the `ProviderServices` that are available in this Amazon Web Services Region.
 */
public suspend inline fun EntityResolutionClient.listProviderServices(crossinline block: ListProviderServicesRequest.Builder.() -> Unit): ListProviderServicesResponse = listProviderServices(ListProviderServicesRequest.Builder().apply(block).build())

/**
 * Returns a list of all the `SchemaMappings` that have been created for an Amazon Web Services account.
 */
public suspend inline fun EntityResolutionClient.listSchemaMappings(crossinline block: ListSchemaMappingsRequest.Builder.() -> Unit): ListSchemaMappingsResponse = listSchemaMappings(ListSchemaMappingsRequest.Builder().apply(block).build())

/**
 * Displays the tags associated with an Entity Resolution resource. In Entity Resolution, `SchemaMapping`, and `MatchingWorkflow` can be tagged.
 */
public suspend inline fun EntityResolutionClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Updates the resource-based policy.
 */
public suspend inline fun EntityResolutionClient.putPolicy(crossinline block: PutPolicyRequest.Builder.() -> Unit): PutPolicyResponse = putPolicy(PutPolicyRequest.Builder().apply(block).build())

/**
 * Starts the `IdMappingJob` of a workflow. The workflow must have previously been created using the `CreateIdMappingWorkflow` endpoint.
 */
public suspend inline fun EntityResolutionClient.startIdMappingJob(crossinline block: StartIdMappingJobRequest.Builder.() -> Unit): StartIdMappingJobResponse = startIdMappingJob(StartIdMappingJobRequest.Builder().apply(block).build())

/**
 * Starts the `MatchingJob` of a workflow. The workflow must have previously been created using the `CreateMatchingWorkflow` endpoint.
 */
public suspend inline fun EntityResolutionClient.startMatchingJob(crossinline block: StartMatchingJobRequest.Builder.() -> Unit): StartMatchingJobResponse = startMatchingJob(StartMatchingJobRequest.Builder().apply(block).build())

/**
 * Assigns one or more tags (key-value pairs) to the specified Entity Resolution resource. Tags can help you organize and categorize your resources. You can also use them to scope user permissions by granting a user permission to access or change only resources with certain tag values. In Entity Resolution, `SchemaMapping` and `MatchingWorkflow` can be tagged. Tags don't have any semantic meaning to Amazon Web Services and are interpreted strictly as strings of characters. You can use the `TagResource` action with a resource that already has tags. If you specify a new tag key, this tag is appended to the list of tags associated with the resource. If you specify a tag key that is already associated with the resource, the new tag value that you specify replaces the previous value for that tag.
 */
public suspend inline fun EntityResolutionClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Removes one or more tags from the specified Entity Resolution resource. In Entity Resolution, `SchemaMapping`, and `MatchingWorkflow` can be tagged.
 */
public suspend inline fun EntityResolutionClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Updates an existing `IdMappingWorkflow`. This method is identical to `CreateIdMappingWorkflow`, except it uses an HTTP `PUT` request instead of a `POST` request, and the `IdMappingWorkflow` must already exist for the method to succeed.
 */
public suspend inline fun EntityResolutionClient.updateIdMappingWorkflow(crossinline block: UpdateIdMappingWorkflowRequest.Builder.() -> Unit): UpdateIdMappingWorkflowResponse = updateIdMappingWorkflow(UpdateIdMappingWorkflowRequest.Builder().apply(block).build())

/**
 * Updates an existing ID namespace.
 */
public suspend inline fun EntityResolutionClient.updateIdNamespace(crossinline block: UpdateIdNamespaceRequest.Builder.() -> Unit): UpdateIdNamespaceResponse = updateIdNamespace(UpdateIdNamespaceRequest.Builder().apply(block).build())

/**
 * Updates an existing `MatchingWorkflow`. This method is identical to `CreateMatchingWorkflow`, except it uses an HTTP `PUT` request instead of a `POST` request, and the `MatchingWorkflow` must already exist for the method to succeed.
 */
public suspend inline fun EntityResolutionClient.updateMatchingWorkflow(crossinline block: UpdateMatchingWorkflowRequest.Builder.() -> Unit): UpdateMatchingWorkflowResponse = updateMatchingWorkflow(UpdateMatchingWorkflowRequest.Builder().apply(block).build())

/**
 * Updates a schema mapping.
 *
 * A schema is immutable if it is being used by a workflow. Therefore, you can't update a schema mapping if it's associated with a workflow.
 */
public suspend inline fun EntityResolutionClient.updateSchemaMapping(crossinline block: UpdateSchemaMappingRequest.Builder.() -> Unit): UpdateSchemaMappingResponse = updateSchemaMapping(UpdateSchemaMappingRequest.Builder().apply(block).build())
