// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.entityresolution.serde

import aws.sdk.kotlin.services.entityresolution.model.IdMappingTechniques
import aws.sdk.kotlin.services.entityresolution.model.IdMappingWorkflowInputSource
import aws.sdk.kotlin.services.entityresolution.model.IdMappingWorkflowOutputSource
import aws.sdk.kotlin.services.entityresolution.model.UpdateIdMappingWorkflowRequest
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class UpdateIdMappingWorkflowOperationSerializer: HttpSerializer.NonStreaming<UpdateIdMappingWorkflowRequest> {
    override fun serialize(context: ExecutionContext, input: UpdateIdMappingWorkflowRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.PUT

        builder.url {
            requireNotNull(input.workflowName) { "workflowName is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("idmappingworkflows"))
                add(PercentEncoding.SmithyLabel.encode("${input.workflowName}"))
            }
        }

        val payload = serializeUpdateIdMappingWorkflowOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeUpdateIdMappingWorkflowOperationBody(context: ExecutionContext, input: UpdateIdMappingWorkflowRequest): ByteArray {
    val serializer = JsonSerializer()
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("description"))
    val IDMAPPINGTECHNIQUES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("idMappingTechniques"))
    val INPUTSOURCECONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("inputSourceConfig"))
    val OUTPUTSOURCECONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("outputSourceConfig"))
    val ROLEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("roleArn"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(DESCRIPTION_DESCRIPTOR)
        field(IDMAPPINGTECHNIQUES_DESCRIPTOR)
        field(INPUTSOURCECONFIG_DESCRIPTOR)
        field(OUTPUTSOURCECONFIG_DESCRIPTOR)
        field(ROLEARN_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.description?.let { field(DESCRIPTION_DESCRIPTOR, it) }
        input.idMappingTechniques?.let { field(IDMAPPINGTECHNIQUES_DESCRIPTOR, it, ::serializeIdMappingTechniquesDocument) }
        if (input.inputSourceConfig != null) {
            listField(INPUTSOURCECONFIG_DESCRIPTOR) {
                for (el0 in input.inputSourceConfig) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeIdMappingWorkflowInputSourceDocument))
                }
            }
        }
        if (input.outputSourceConfig != null) {
            listField(OUTPUTSOURCECONFIG_DESCRIPTOR) {
                for (el0 in input.outputSourceConfig) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeIdMappingWorkflowOutputSourceDocument))
                }
            }
        }
        input.roleArn?.let { field(ROLEARN_DESCRIPTOR, it) }
    }
    return serializer.toByteArray()
}
