// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.entityresolution.serde

import aws.sdk.kotlin.services.entityresolution.model.EntityResolutionException
import aws.sdk.kotlin.services.entityresolution.model.ErrorDetails
import aws.sdk.kotlin.services.entityresolution.model.GetIdMappingJobResponse
import aws.sdk.kotlin.services.entityresolution.model.IdMappingJobMetrics
import aws.sdk.kotlin.services.entityresolution.model.IdMappingJobOutputSource
import aws.sdk.kotlin.services.entityresolution.model.JobStatus
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import kotlin.collections.mutableListOf


internal class GetIdMappingJobOperationDeserializer: HttpDeserializer.NonStreaming<GetIdMappingJobResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): GetIdMappingJobResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetIdMappingJobError(context, call, payload)
        }
        val builder = GetIdMappingJobResponse.Builder()

        if (payload != null) {
            deserializeGetIdMappingJobOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwGetIdMappingJobError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw EntityResolutionException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> EntityResolutionException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetIdMappingJobOperationBody(builder: GetIdMappingJobResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ENDTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("endTime"))
    val ERRORDETAILS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("errorDetails"))
    val JOBID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("jobId"))
    val METRICS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("metrics"))
    val OUTPUTSOURCECONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("outputSourceConfig"))
    val STARTTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("startTime"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("status"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ENDTIME_DESCRIPTOR)
        field(ERRORDETAILS_DESCRIPTOR)
        field(JOBID_DESCRIPTOR)
        field(METRICS_DESCRIPTOR)
        field(OUTPUTSOURCECONFIG_DESCRIPTOR)
        field(STARTTIME_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ENDTIME_DESCRIPTOR.index -> builder.endTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                ERRORDETAILS_DESCRIPTOR.index -> builder.errorDetails = deserializeErrorDetailsDocument(deserializer)
                JOBID_DESCRIPTOR.index -> builder.jobId = deserializeString()
                METRICS_DESCRIPTOR.index -> builder.metrics = deserializeIdMappingJobMetricsDocument(deserializer)
                OUTPUTSOURCECONFIG_DESCRIPTOR.index -> builder.outputSourceConfig =
                    deserializer.deserializeList(OUTPUTSOURCECONFIG_DESCRIPTOR) {
                        val col0 = mutableListOf<IdMappingJobOutputSource>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeIdMappingJobOutputSourceDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                STARTTIME_DESCRIPTOR.index -> builder.startTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString().let { JobStatus.fromValue(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
