// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.entityresolution.serde

import aws.sdk.kotlin.services.entityresolution.model.CreateIdMappingWorkflowResponse
import aws.sdk.kotlin.services.entityresolution.model.EntityResolutionException
import aws.sdk.kotlin.services.entityresolution.model.IdMappingTechniques
import aws.sdk.kotlin.services.entityresolution.model.IdMappingWorkflowInputSource
import aws.sdk.kotlin.services.entityresolution.model.IdMappingWorkflowOutputSource
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class CreateIdMappingWorkflowOperationDeserializer: HttpDeserializer.NonStreaming<CreateIdMappingWorkflowResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): CreateIdMappingWorkflowResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwCreateIdMappingWorkflowError(context, call, payload)
        }
        val builder = CreateIdMappingWorkflowResponse.Builder()

        if (payload != null) {
            deserializeCreateIdMappingWorkflowOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwCreateIdMappingWorkflowError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw EntityResolutionException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ExceedsLimitException" -> ExceedsLimitExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ConflictException" -> ConflictExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> EntityResolutionException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateIdMappingWorkflowOperationBody(builder: CreateIdMappingWorkflowResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("description"))
    val IDMAPPINGTECHNIQUES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("idMappingTechniques"))
    val INPUTSOURCECONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("inputSourceConfig"))
    val OUTPUTSOURCECONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("outputSourceConfig"))
    val ROLEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("roleArn"))
    val WORKFLOWARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("workflowArn"))
    val WORKFLOWNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("workflowName"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(DESCRIPTION_DESCRIPTOR)
        field(IDMAPPINGTECHNIQUES_DESCRIPTOR)
        field(INPUTSOURCECONFIG_DESCRIPTOR)
        field(OUTPUTSOURCECONFIG_DESCRIPTOR)
        field(ROLEARN_DESCRIPTOR)
        field(WORKFLOWARN_DESCRIPTOR)
        field(WORKFLOWNAME_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                DESCRIPTION_DESCRIPTOR.index -> builder.description = deserializeString()
                IDMAPPINGTECHNIQUES_DESCRIPTOR.index -> builder.idMappingTechniques = deserializeIdMappingTechniquesDocument(deserializer)
                INPUTSOURCECONFIG_DESCRIPTOR.index -> builder.inputSourceConfig =
                    deserializer.deserializeList(INPUTSOURCECONFIG_DESCRIPTOR) {
                        val col0 = mutableListOf<IdMappingWorkflowInputSource>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeIdMappingWorkflowInputSourceDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                OUTPUTSOURCECONFIG_DESCRIPTOR.index -> builder.outputSourceConfig =
                    deserializer.deserializeList(OUTPUTSOURCECONFIG_DESCRIPTOR) {
                        val col0 = mutableListOf<IdMappingWorkflowOutputSource>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeIdMappingWorkflowOutputSourceDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                ROLEARN_DESCRIPTOR.index -> builder.roleArn = deserializeString()
                WORKFLOWARN_DESCRIPTOR.index -> builder.workflowArn = deserializeString()
                WORKFLOWNAME_DESCRIPTOR.index -> builder.workflowName = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
