// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.entityresolution.paginators

import aws.sdk.kotlin.services.entityresolution.EntityResolutionClient
import aws.sdk.kotlin.services.entityresolution.model.IdMappingWorkflowSummary
import aws.sdk.kotlin.services.entityresolution.model.IdNamespaceSummary
import aws.sdk.kotlin.services.entityresolution.model.JobSummary
import aws.sdk.kotlin.services.entityresolution.model.ListIdMappingJobsRequest
import aws.sdk.kotlin.services.entityresolution.model.ListIdMappingJobsResponse
import aws.sdk.kotlin.services.entityresolution.model.ListIdMappingWorkflowsRequest
import aws.sdk.kotlin.services.entityresolution.model.ListIdMappingWorkflowsResponse
import aws.sdk.kotlin.services.entityresolution.model.ListIdNamespacesRequest
import aws.sdk.kotlin.services.entityresolution.model.ListIdNamespacesResponse
import aws.sdk.kotlin.services.entityresolution.model.ListMatchingJobsRequest
import aws.sdk.kotlin.services.entityresolution.model.ListMatchingJobsResponse
import aws.sdk.kotlin.services.entityresolution.model.ListMatchingWorkflowsRequest
import aws.sdk.kotlin.services.entityresolution.model.ListMatchingWorkflowsResponse
import aws.sdk.kotlin.services.entityresolution.model.ListProviderServicesRequest
import aws.sdk.kotlin.services.entityresolution.model.ListProviderServicesResponse
import aws.sdk.kotlin.services.entityresolution.model.ListSchemaMappingsRequest
import aws.sdk.kotlin.services.entityresolution.model.ListSchemaMappingsResponse
import aws.sdk.kotlin.services.entityresolution.model.MatchingWorkflowSummary
import aws.sdk.kotlin.services.entityresolution.model.ProviderServiceSummary
import aws.sdk.kotlin.services.entityresolution.model.SchemaMappingSummary
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [ListIdMappingJobsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListIdMappingJobsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListIdMappingJobsResponse]
 */
public fun EntityResolutionClient.listIdMappingJobsPaginated(initialRequest: ListIdMappingJobsRequest): Flow<ListIdMappingJobsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listIdMappingJobsPaginated.listIdMappingJobs(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListIdMappingJobsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListIdMappingJobsResponse]
 */
public fun EntityResolutionClient.listIdMappingJobsPaginated(block: ListIdMappingJobsRequest.Builder.() -> Unit): Flow<ListIdMappingJobsResponse> =
    listIdMappingJobsPaginated(ListIdMappingJobsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listIdMappingJobsPaginated]
 * to access the nested member [JobSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [JobSummary]
 */
@JvmName("listIdMappingJobsResponseJobSummary")
public fun Flow<ListIdMappingJobsResponse>.jobs(): Flow<JobSummary> =
    transform() { response ->
        response.jobs?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListIdMappingWorkflowsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListIdMappingWorkflowsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListIdMappingWorkflowsResponse]
 */
public fun EntityResolutionClient.listIdMappingWorkflowsPaginated(initialRequest: ListIdMappingWorkflowsRequest = ListIdMappingWorkflowsRequest { }): Flow<ListIdMappingWorkflowsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listIdMappingWorkflowsPaginated.listIdMappingWorkflows(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListIdMappingWorkflowsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListIdMappingWorkflowsResponse]
 */
public fun EntityResolutionClient.listIdMappingWorkflowsPaginated(block: ListIdMappingWorkflowsRequest.Builder.() -> Unit): Flow<ListIdMappingWorkflowsResponse> =
    listIdMappingWorkflowsPaginated(ListIdMappingWorkflowsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listIdMappingWorkflowsPaginated]
 * to access the nested member [IdMappingWorkflowSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [IdMappingWorkflowSummary]
 */
@JvmName("listIdMappingWorkflowsResponseIdMappingWorkflowSummary")
public fun Flow<ListIdMappingWorkflowsResponse>.workflowSummaries(): Flow<IdMappingWorkflowSummary> =
    transform() { response ->
        response.workflowSummaries?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListIdNamespacesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListIdNamespacesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListIdNamespacesResponse]
 */
public fun EntityResolutionClient.listIdNamespacesPaginated(initialRequest: ListIdNamespacesRequest = ListIdNamespacesRequest { }): Flow<ListIdNamespacesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listIdNamespacesPaginated.listIdNamespaces(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListIdNamespacesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListIdNamespacesResponse]
 */
public fun EntityResolutionClient.listIdNamespacesPaginated(block: ListIdNamespacesRequest.Builder.() -> Unit): Flow<ListIdNamespacesResponse> =
    listIdNamespacesPaginated(ListIdNamespacesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listIdNamespacesPaginated]
 * to access the nested member [IdNamespaceSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [IdNamespaceSummary]
 */
@JvmName("listIdNamespacesResponseIdNamespaceSummary")
public fun Flow<ListIdNamespacesResponse>.idNamespaceSummaries(): Flow<IdNamespaceSummary> =
    transform() { response ->
        response.idNamespaceSummaries?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListMatchingJobsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListMatchingJobsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListMatchingJobsResponse]
 */
public fun EntityResolutionClient.listMatchingJobsPaginated(initialRequest: ListMatchingJobsRequest): Flow<ListMatchingJobsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listMatchingJobsPaginated.listMatchingJobs(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListMatchingJobsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListMatchingJobsResponse]
 */
public fun EntityResolutionClient.listMatchingJobsPaginated(block: ListMatchingJobsRequest.Builder.() -> Unit): Flow<ListMatchingJobsResponse> =
    listMatchingJobsPaginated(ListMatchingJobsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listMatchingJobsPaginated]
 * to access the nested member [JobSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [JobSummary]
 */
@JvmName("listMatchingJobsResponseJobSummary")
public fun Flow<ListMatchingJobsResponse>.jobs(): Flow<JobSummary> =
    transform() { response ->
        response.jobs?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListMatchingWorkflowsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListMatchingWorkflowsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListMatchingWorkflowsResponse]
 */
public fun EntityResolutionClient.listMatchingWorkflowsPaginated(initialRequest: ListMatchingWorkflowsRequest = ListMatchingWorkflowsRequest { }): Flow<ListMatchingWorkflowsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listMatchingWorkflowsPaginated.listMatchingWorkflows(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListMatchingWorkflowsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListMatchingWorkflowsResponse]
 */
public fun EntityResolutionClient.listMatchingWorkflowsPaginated(block: ListMatchingWorkflowsRequest.Builder.() -> Unit): Flow<ListMatchingWorkflowsResponse> =
    listMatchingWorkflowsPaginated(ListMatchingWorkflowsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listMatchingWorkflowsPaginated]
 * to access the nested member [MatchingWorkflowSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [MatchingWorkflowSummary]
 */
@JvmName("listMatchingWorkflowsResponseMatchingWorkflowSummary")
public fun Flow<ListMatchingWorkflowsResponse>.workflowSummaries(): Flow<MatchingWorkflowSummary> =
    transform() { response ->
        response.workflowSummaries?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListProviderServicesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListProviderServicesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListProviderServicesResponse]
 */
public fun EntityResolutionClient.listProviderServicesPaginated(initialRequest: ListProviderServicesRequest = ListProviderServicesRequest { }): Flow<ListProviderServicesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listProviderServicesPaginated.listProviderServices(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListProviderServicesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListProviderServicesResponse]
 */
public fun EntityResolutionClient.listProviderServicesPaginated(block: ListProviderServicesRequest.Builder.() -> Unit): Flow<ListProviderServicesResponse> =
    listProviderServicesPaginated(ListProviderServicesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listProviderServicesPaginated]
 * to access the nested member [ProviderServiceSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ProviderServiceSummary]
 */
@JvmName("listProviderServicesResponseProviderServiceSummary")
public fun Flow<ListProviderServicesResponse>.providerServiceSummaries(): Flow<ProviderServiceSummary> =
    transform() { response ->
        response.providerServiceSummaries?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListSchemaMappingsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListSchemaMappingsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListSchemaMappingsResponse]
 */
public fun EntityResolutionClient.listSchemaMappingsPaginated(initialRequest: ListSchemaMappingsRequest = ListSchemaMappingsRequest { }): Flow<ListSchemaMappingsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listSchemaMappingsPaginated.listSchemaMappings(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListSchemaMappingsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListSchemaMappingsResponse]
 */
public fun EntityResolutionClient.listSchemaMappingsPaginated(block: ListSchemaMappingsRequest.Builder.() -> Unit): Flow<ListSchemaMappingsResponse> =
    listSchemaMappingsPaginated(ListSchemaMappingsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listSchemaMappingsPaginated]
 * to access the nested member [SchemaMappingSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [SchemaMappingSummary]
 */
@JvmName("listSchemaMappingsResponseSchemaMappingSummary")
public fun Flow<ListSchemaMappingsResponse>.schemaList(): Flow<SchemaMappingSummary> =
    transform() { response ->
        response.schemaList?.forEach {
            emit(it)
        }
    }
