// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.entityresolution.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * An object containing the `JobId`, `Status`, `StartTime`, and `EndTime` of a job.
 */
public class JobSummary private constructor(builder: Builder) {
    /**
     * The time at which the job has finished.
     */
    public val endTime: aws.smithy.kotlin.runtime.time.Instant? = builder.endTime
    /**
     * The ID of the job.
     */
    public val jobId: kotlin.String = requireNotNull(builder.jobId) { "A non-null value must be provided for jobId" }
    /**
     * The time at which the job was started.
     */
    public val startTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.startTime) { "A non-null value must be provided for startTime" }
    /**
     * The current status of the job.
     */
    public val status: aws.sdk.kotlin.services.entityresolution.model.JobStatus = requireNotNull(builder.status) { "A non-null value must be provided for status" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.entityresolution.model.JobSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("JobSummary(")
        append("endTime=$endTime,")
        append("jobId=$jobId,")
        append("startTime=$startTime,")
        append("status=$status")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = endTime?.hashCode() ?: 0
        result = 31 * result + (jobId.hashCode())
        result = 31 * result + (startTime.hashCode())
        result = 31 * result + (status.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as JobSummary

        if (endTime != other.endTime) return false
        if (jobId != other.jobId) return false
        if (startTime != other.startTime) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.entityresolution.model.JobSummary = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The time at which the job has finished.
         */
        public var endTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The ID of the job.
         */
        public var jobId: kotlin.String? = null
        /**
         * The time at which the job was started.
         */
        public var startTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The current status of the job.
         */
        public var status: aws.sdk.kotlin.services.entityresolution.model.JobStatus? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.entityresolution.model.JobSummary) : this() {
            this.endTime = x.endTime
            this.jobId = x.jobId
            this.startTime = x.startTime
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.entityresolution.model.JobSummary = JobSummary(this)

        internal fun correctErrors(): Builder {
            if (jobId == null) jobId = ""
            if (startTime == null) startTime = Instant.fromEpochSeconds(0)
            if (status == null) status = JobStatus.SdkUnknown("no value provided")
            return this
        }
    }
}
