// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.entityresolution.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

public class CreateIdNamespaceResponse private constructor(builder: Builder) {
    /**
     * The timestamp of when the ID namespace was created.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.createdAt) { "A non-null value must be provided for createdAt" }
    /**
     * The description of the ID namespace.
     */
    public val description: kotlin.String? = builder.description
    /**
     * Determines the properties of `IdMappingWorkflow` where this `IdNamespace` can be used as a `Source` or a `Target`.
     */
    public val idMappingWorkflowProperties: List<IdNamespaceIdMappingWorkflowProperties>? = builder.idMappingWorkflowProperties
    /**
     * The Amazon Resource Name (ARN) of the ID namespace.
     */
    public val idNamespaceArn: kotlin.String = requireNotNull(builder.idNamespaceArn) { "A non-null value must be provided for idNamespaceArn" }
    /**
     * The name of the ID namespace.
     */
    public val idNamespaceName: kotlin.String = requireNotNull(builder.idNamespaceName) { "A non-null value must be provided for idNamespaceName" }
    /**
     * A list of `InputSource` objects, which have the fields `InputSourceARN` and `SchemaName`.
     */
    public val inputSourceConfig: List<IdNamespaceInputSource>? = builder.inputSourceConfig
    /**
     * The Amazon Resource Name (ARN) of the IAM role. Entity Resolution assumes this role to access the resources defined in `inputSourceConfig` on your behalf as part of the workflow run.
     */
    public val roleArn: kotlin.String? = builder.roleArn
    /**
     * The tags used to organize, track, or control access for this resource.
     */
    public val tags: Map<String, String>? = builder.tags
    /**
     * The type of ID namespace. There are two types: `SOURCE` and `TARGET`.
     *
     * The `SOURCE` contains configurations for `sourceId` data that will be processed in an ID mapping workflow.
     *
     * The `TARGET` contains a configuration of `targetId` to which all `sourceIds` will resolve to.
     */
    public val type: aws.sdk.kotlin.services.entityresolution.model.IdNamespaceType = requireNotNull(builder.type) { "A non-null value must be provided for type" }
    /**
     * The timestamp of when the ID namespace was last updated.
     */
    public val updatedAt: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.updatedAt) { "A non-null value must be provided for updatedAt" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.entityresolution.model.CreateIdNamespaceResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateIdNamespaceResponse(")
        append("createdAt=$createdAt,")
        append("description=$description,")
        append("idMappingWorkflowProperties=$idMappingWorkflowProperties,")
        append("idNamespaceArn=$idNamespaceArn,")
        append("idNamespaceName=$idNamespaceName,")
        append("inputSourceConfig=$inputSourceConfig,")
        append("roleArn=$roleArn,")
        append("tags=$tags,")
        append("type=$type,")
        append("updatedAt=$updatedAt")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = createdAt.hashCode()
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (idMappingWorkflowProperties?.hashCode() ?: 0)
        result = 31 * result + (idNamespaceArn.hashCode())
        result = 31 * result + (idNamespaceName.hashCode())
        result = 31 * result + (inputSourceConfig?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (type.hashCode())
        result = 31 * result + (updatedAt.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateIdNamespaceResponse

        if (createdAt != other.createdAt) return false
        if (description != other.description) return false
        if (idMappingWorkflowProperties != other.idMappingWorkflowProperties) return false
        if (idNamespaceArn != other.idNamespaceArn) return false
        if (idNamespaceName != other.idNamespaceName) return false
        if (inputSourceConfig != other.inputSourceConfig) return false
        if (roleArn != other.roleArn) return false
        if (tags != other.tags) return false
        if (type != other.type) return false
        if (updatedAt != other.updatedAt) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.entityresolution.model.CreateIdNamespaceResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The timestamp of when the ID namespace was created.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The description of the ID namespace.
         */
        public var description: kotlin.String? = null
        /**
         * Determines the properties of `IdMappingWorkflow` where this `IdNamespace` can be used as a `Source` or a `Target`.
         */
        public var idMappingWorkflowProperties: List<IdNamespaceIdMappingWorkflowProperties>? = null
        /**
         * The Amazon Resource Name (ARN) of the ID namespace.
         */
        public var idNamespaceArn: kotlin.String? = null
        /**
         * The name of the ID namespace.
         */
        public var idNamespaceName: kotlin.String? = null
        /**
         * A list of `InputSource` objects, which have the fields `InputSourceARN` and `SchemaName`.
         */
        public var inputSourceConfig: List<IdNamespaceInputSource>? = null
        /**
         * The Amazon Resource Name (ARN) of the IAM role. Entity Resolution assumes this role to access the resources defined in `inputSourceConfig` on your behalf as part of the workflow run.
         */
        public var roleArn: kotlin.String? = null
        /**
         * The tags used to organize, track, or control access for this resource.
         */
        public var tags: Map<String, String>? = null
        /**
         * The type of ID namespace. There are two types: `SOURCE` and `TARGET`.
         *
         * The `SOURCE` contains configurations for `sourceId` data that will be processed in an ID mapping workflow.
         *
         * The `TARGET` contains a configuration of `targetId` to which all `sourceIds` will resolve to.
         */
        public var type: aws.sdk.kotlin.services.entityresolution.model.IdNamespaceType? = null
        /**
         * The timestamp of when the ID namespace was last updated.
         */
        public var updatedAt: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.entityresolution.model.CreateIdNamespaceResponse) : this() {
            this.createdAt = x.createdAt
            this.description = x.description
            this.idMappingWorkflowProperties = x.idMappingWorkflowProperties
            this.idNamespaceArn = x.idNamespaceArn
            this.idNamespaceName = x.idNamespaceName
            this.inputSourceConfig = x.inputSourceConfig
            this.roleArn = x.roleArn
            this.tags = x.tags
            this.type = x.type
            this.updatedAt = x.updatedAt
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.entityresolution.model.CreateIdNamespaceResponse = CreateIdNamespaceResponse(this)

        internal fun correctErrors(): Builder {
            if (createdAt == null) createdAt = Instant.fromEpochSeconds(0)
            if (idNamespaceArn == null) idNamespaceArn = ""
            if (idNamespaceName == null) idNamespaceName = ""
            if (type == null) type = IdNamespaceType.SdkUnknown("no value provided")
            if (updatedAt == null) updatedAt = Instant.fromEpochSeconds(0)
            return this
        }
    }
}
