// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.entityresolution.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * A list of `MatchingWorkflowSummary` objects, each of which contain the fields `WorkflowName`, `WorkflowArn`, `CreatedAt`, `UpdatedAt`.
 */
public class MatchingWorkflowSummary private constructor(builder: Builder) {
    /**
     * The timestamp of when the workflow was created.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.createdAt) { "A non-null value must be provided for createdAt" }
    /**
     * The method that has been specified for data matching, either using matching provided by Entity Resolution or through a provider service.
     */
    public val resolutionType: aws.sdk.kotlin.services.entityresolution.model.ResolutionType = requireNotNull(builder.resolutionType) { "A non-null value must be provided for resolutionType" }
    /**
     * The timestamp of when the workflow was last updated.
     */
    public val updatedAt: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.updatedAt) { "A non-null value must be provided for updatedAt" }
    /**
     * The ARN (Amazon Resource Name) that Entity Resolution generated for the `MatchingWorkflow`.
     */
    public val workflowArn: kotlin.String = requireNotNull(builder.workflowArn) { "A non-null value must be provided for workflowArn" }
    /**
     * The name of the workflow.
     */
    public val workflowName: kotlin.String = requireNotNull(builder.workflowName) { "A non-null value must be provided for workflowName" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.entityresolution.model.MatchingWorkflowSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("MatchingWorkflowSummary(")
        append("createdAt=$createdAt,")
        append("resolutionType=$resolutionType,")
        append("updatedAt=$updatedAt,")
        append("workflowArn=$workflowArn,")
        append("workflowName=$workflowName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = createdAt.hashCode()
        result = 31 * result + (resolutionType.hashCode())
        result = 31 * result + (updatedAt.hashCode())
        result = 31 * result + (workflowArn.hashCode())
        result = 31 * result + (workflowName.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as MatchingWorkflowSummary

        if (createdAt != other.createdAt) return false
        if (resolutionType != other.resolutionType) return false
        if (updatedAt != other.updatedAt) return false
        if (workflowArn != other.workflowArn) return false
        if (workflowName != other.workflowName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.entityresolution.model.MatchingWorkflowSummary = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The timestamp of when the workflow was created.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The method that has been specified for data matching, either using matching provided by Entity Resolution or through a provider service.
         */
        public var resolutionType: aws.sdk.kotlin.services.entityresolution.model.ResolutionType? = null
        /**
         * The timestamp of when the workflow was last updated.
         */
        public var updatedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The ARN (Amazon Resource Name) that Entity Resolution generated for the `MatchingWorkflow`.
         */
        public var workflowArn: kotlin.String? = null
        /**
         * The name of the workflow.
         */
        public var workflowName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.entityresolution.model.MatchingWorkflowSummary) : this() {
            this.createdAt = x.createdAt
            this.resolutionType = x.resolutionType
            this.updatedAt = x.updatedAt
            this.workflowArn = x.workflowArn
            this.workflowName = x.workflowName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.entityresolution.model.MatchingWorkflowSummary = MatchingWorkflowSummary(this)

        internal fun correctErrors(): Builder {
            if (createdAt == null) createdAt = Instant.fromEpochSeconds(0)
            if (resolutionType == null) resolutionType = ResolutionType.SdkUnknown("no value provided")
            if (updatedAt == null) updatedAt = Instant.fromEpochSeconds(0)
            if (workflowArn == null) workflowArn = ""
            if (workflowName == null) workflowName = ""
            return this
        }
    }
}
