// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.entityresolution.model

import aws.smithy.kotlin.runtime.time.Instant

public class GetMatchingJobResponse private constructor(builder: Builder) {
    /**
     * The time at which the job has finished.
     */
    public val endTime: aws.smithy.kotlin.runtime.time.Instant? = builder.endTime
    /**
     * An object containing an error message, if there was an error.
     */
    public val errorDetails: aws.sdk.kotlin.services.entityresolution.model.ErrorDetails? = builder.errorDetails
    /**
     * The ID of the job.
     */
    public val jobId: kotlin.String = requireNotNull(builder.jobId) { "A non-null value must be provided for jobId" }
    /**
     * Metrics associated with the execution, specifically total records processed, unique IDs generated, and records the execution skipped.
     */
    public val metrics: aws.sdk.kotlin.services.entityresolution.model.JobMetrics? = builder.metrics
    /**
     * The time at which the job was started.
     */
    public val startTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.startTime) { "A non-null value must be provided for startTime" }
    /**
     * The current status of the job.
     */
    public val status: aws.sdk.kotlin.services.entityresolution.model.JobStatus = requireNotNull(builder.status) { "A non-null value must be provided for status" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.entityresolution.model.GetMatchingJobResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetMatchingJobResponse(")
        append("endTime=$endTime,")
        append("errorDetails=$errorDetails,")
        append("jobId=$jobId,")
        append("metrics=$metrics,")
        append("startTime=$startTime,")
        append("status=$status")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = endTime?.hashCode() ?: 0
        result = 31 * result + (errorDetails?.hashCode() ?: 0)
        result = 31 * result + (jobId.hashCode())
        result = 31 * result + (metrics?.hashCode() ?: 0)
        result = 31 * result + (startTime.hashCode())
        result = 31 * result + (status.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetMatchingJobResponse

        if (endTime != other.endTime) return false
        if (errorDetails != other.errorDetails) return false
        if (jobId != other.jobId) return false
        if (metrics != other.metrics) return false
        if (startTime != other.startTime) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.entityresolution.model.GetMatchingJobResponse = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The time at which the job has finished.
         */
        public var endTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * An object containing an error message, if there was an error.
         */
        public var errorDetails: aws.sdk.kotlin.services.entityresolution.model.ErrorDetails? = null
        /**
         * The ID of the job.
         */
        public var jobId: kotlin.String? = null
        /**
         * Metrics associated with the execution, specifically total records processed, unique IDs generated, and records the execution skipped.
         */
        public var metrics: aws.sdk.kotlin.services.entityresolution.model.JobMetrics? = null
        /**
         * The time at which the job was started.
         */
        public var startTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The current status of the job.
         */
        public var status: aws.sdk.kotlin.services.entityresolution.model.JobStatus? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.entityresolution.model.GetMatchingJobResponse) : this() {
            this.endTime = x.endTime
            this.errorDetails = x.errorDetails
            this.jobId = x.jobId
            this.metrics = x.metrics
            this.startTime = x.startTime
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.entityresolution.model.GetMatchingJobResponse = GetMatchingJobResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.entityresolution.model.ErrorDetails] inside the given [block]
         */
        public fun errorDetails(block: aws.sdk.kotlin.services.entityresolution.model.ErrorDetails.Builder.() -> kotlin.Unit) {
            this.errorDetails = aws.sdk.kotlin.services.entityresolution.model.ErrorDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.entityresolution.model.JobMetrics] inside the given [block]
         */
        public fun metrics(block: aws.sdk.kotlin.services.entityresolution.model.JobMetrics.Builder.() -> kotlin.Unit) {
            this.metrics = aws.sdk.kotlin.services.entityresolution.model.JobMetrics.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (jobId == null) jobId = ""
            if (startTime == null) startTime = Instant.fromEpochSeconds(0)
            if (status == null) status = JobStatus.SdkUnknown("no value provided")
            return this
        }
    }
}
