// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.entityresolution.serde

import aws.sdk.kotlin.services.entityresolution.model.EntityResolutionException
import aws.sdk.kotlin.services.entityresolution.model.SchemaInputAttribute
import aws.sdk.kotlin.services.entityresolution.model.UpdateSchemaMappingResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class UpdateSchemaMappingOperationDeserializer: HttpDeserialize<UpdateSchemaMappingResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): UpdateSchemaMappingResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwUpdateSchemaMappingError(context, call)
        }
        val builder = UpdateSchemaMappingResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeUpdateSchemaMappingOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwUpdateSchemaMappingError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw EntityResolutionException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall)
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall)
        "ConflictException" -> ConflictExceptionDeserializer().deserialize(context, wrappedCall)
        else -> EntityResolutionException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeUpdateSchemaMappingOperationBody(builder: UpdateSchemaMappingResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("description"))
    val MAPPEDINPUTFIELDS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("mappedInputFields"))
    val SCHEMAARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("schemaArn"))
    val SCHEMANAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("schemaName"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(DESCRIPTION_DESCRIPTOR)
        field(MAPPEDINPUTFIELDS_DESCRIPTOR)
        field(SCHEMAARN_DESCRIPTOR)
        field(SCHEMANAME_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                DESCRIPTION_DESCRIPTOR.index -> builder.description = deserializeString()
                MAPPEDINPUTFIELDS_DESCRIPTOR.index -> builder.mappedInputFields =
                    deserializer.deserializeList(MAPPEDINPUTFIELDS_DESCRIPTOR) {
                        val col0 = mutableListOf<SchemaInputAttribute>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeSchemaInputAttributeDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                SCHEMAARN_DESCRIPTOR.index -> builder.schemaArn = deserializeString()
                SCHEMANAME_DESCRIPTOR.index -> builder.schemaName = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
