// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.entityresolution.model



/**
 * An object containing `FieldName`, `Type`, `GroupName`, and `MatchKey`.
 */
public class SchemaInputAttribute private constructor(builder: Builder) {
    /**
     * A string containing the field name.
     */
    public val fieldName: kotlin.String = requireNotNull(builder.fieldName) { "A non-null value must be provided for fieldName" }
    /**
     * Instruct Entity Resolution to combine several columns into a unified column with the identical attribute type. For example, when working with columns such as first_name, middle_name, and last_name, assigning them a common `GroupName` will prompt Entity Resolution to concatenate them into a single value.
     */
    public val groupName: kotlin.String? = builder.groupName
    /**
     * A key that allows grouping of multiple input attributes into a unified matching group. For example, let's consider a scenario where the source table contains various addresses, such as `business_address` and `shipping_address`. By assigning the `MatchKey`*Address* to both attributes, Entity Resolution will match records across these fields to create a consolidated matching group. If no `MatchKey` is specified for a column, it won't be utilized for matching purposes but will still be included in the output table.
     */
    public val matchKey: kotlin.String? = builder.matchKey
    /**
     * The subtype of the attribute, selected from a list of values.
     */
    public val subType: kotlin.String? = builder.subType
    /**
     * The type of the attribute, selected from a list of values.
     */
    public val type: aws.sdk.kotlin.services.entityresolution.model.SchemaAttributeType = requireNotNull(builder.type) { "A non-null value must be provided for type" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.entityresolution.model.SchemaInputAttribute = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SchemaInputAttribute(")
        append("fieldName=$fieldName,")
        append("groupName=$groupName,")
        append("matchKey=$matchKey,")
        append("subType=$subType,")
        append("type=$type")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = fieldName.hashCode()
        result = 31 * result + (groupName?.hashCode() ?: 0)
        result = 31 * result + (matchKey?.hashCode() ?: 0)
        result = 31 * result + (subType?.hashCode() ?: 0)
        result = 31 * result + (type.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SchemaInputAttribute

        if (fieldName != other.fieldName) return false
        if (groupName != other.groupName) return false
        if (matchKey != other.matchKey) return false
        if (subType != other.subType) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.entityresolution.model.SchemaInputAttribute = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A string containing the field name.
         */
        public var fieldName: kotlin.String? = null
        /**
         * Instruct Entity Resolution to combine several columns into a unified column with the identical attribute type. For example, when working with columns such as first_name, middle_name, and last_name, assigning them a common `GroupName` will prompt Entity Resolution to concatenate them into a single value.
         */
        public var groupName: kotlin.String? = null
        /**
         * A key that allows grouping of multiple input attributes into a unified matching group. For example, let's consider a scenario where the source table contains various addresses, such as `business_address` and `shipping_address`. By assigning the `MatchKey`*Address* to both attributes, Entity Resolution will match records across these fields to create a consolidated matching group. If no `MatchKey` is specified for a column, it won't be utilized for matching purposes but will still be included in the output table.
         */
        public var matchKey: kotlin.String? = null
        /**
         * The subtype of the attribute, selected from a list of values.
         */
        public var subType: kotlin.String? = null
        /**
         * The type of the attribute, selected from a list of values.
         */
        public var type: aws.sdk.kotlin.services.entityresolution.model.SchemaAttributeType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.entityresolution.model.SchemaInputAttribute) : this() {
            this.fieldName = x.fieldName
            this.groupName = x.groupName
            this.matchKey = x.matchKey
            this.subType = x.subType
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.entityresolution.model.SchemaInputAttribute = SchemaInputAttribute(this)

        internal fun correctErrors(): Builder {
            if (fieldName == null) fieldName = ""
            if (type == null) type = SchemaAttributeType.SdkUnknown("no value provided")
            return this
        }
    }
}
