// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.entityresolution.model



/**
 * A list of `OutputAttribute` objects, each of which have the fields `Name` and `Hashed`. Each of these objects selects a column to be included in the output table, and whether the values of the column should be hashed.
 */
public class OutputSource private constructor(builder: Builder) {
    /**
     * Normalizes the attributes defined in the schema in the input data. For example, if an attribute has an `AttributeType` of `PHONE_NUMBER`, and the data in the input table is in a format of 1234567890, Entity Resolution will normalize this field in the output to (123)-456-7890.
     */
    public val applyNormalization: kotlin.Boolean? = builder.applyNormalization
    /**
     * Customer KMS ARN for encryption at rest. If not provided, system will use an Entity Resolution managed KMS key.
     */
    public val kmsArn: kotlin.String? = builder.kmsArn
    /**
     * A list of `OutputAttribute` objects, each of which have the fields `Name` and `Hashed`. Each of these objects selects a column to be included in the output table, and whether the values of the column should be hashed.
     */
    public val output: List<OutputAttribute> = requireNotNull(builder.output) { "A non-null value must be provided for output" }
    /**
     * The S3 path to which Entity Resolution will write the output table.
     */
    public val outputS3Path: kotlin.String = requireNotNull(builder.outputS3Path) { "A non-null value must be provided for outputS3Path" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.entityresolution.model.OutputSource = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("OutputSource(")
        append("applyNormalization=$applyNormalization,")
        append("kmsArn=$kmsArn,")
        append("output=$output,")
        append("outputS3Path=$outputS3Path")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = applyNormalization?.hashCode() ?: 0
        result = 31 * result + (kmsArn?.hashCode() ?: 0)
        result = 31 * result + (output.hashCode())
        result = 31 * result + (outputS3Path.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as OutputSource

        if (applyNormalization != other.applyNormalization) return false
        if (kmsArn != other.kmsArn) return false
        if (output != other.output) return false
        if (outputS3Path != other.outputS3Path) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.entityresolution.model.OutputSource = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Normalizes the attributes defined in the schema in the input data. For example, if an attribute has an `AttributeType` of `PHONE_NUMBER`, and the data in the input table is in a format of 1234567890, Entity Resolution will normalize this field in the output to (123)-456-7890.
         */
        public var applyNormalization: kotlin.Boolean? = null
        /**
         * Customer KMS ARN for encryption at rest. If not provided, system will use an Entity Resolution managed KMS key.
         */
        public var kmsArn: kotlin.String? = null
        /**
         * A list of `OutputAttribute` objects, each of which have the fields `Name` and `Hashed`. Each of these objects selects a column to be included in the output table, and whether the values of the column should be hashed.
         */
        public var output: List<OutputAttribute>? = null
        /**
         * The S3 path to which Entity Resolution will write the output table.
         */
        public var outputS3Path: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.entityresolution.model.OutputSource) : this() {
            this.applyNormalization = x.applyNormalization
            this.kmsArn = x.kmsArn
            this.output = x.output
            this.outputS3Path = x.outputS3Path
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.entityresolution.model.OutputSource = OutputSource(this)

        internal fun correctErrors(): Builder {
            if (output == null) output = emptyList()
            if (outputS3Path == null) outputS3Path = ""
            return this
        }
    }
}
