// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.entityresolution.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * A list of `IdMappingWorkflowSummary` objects, each of which contain the fields `WorkflowName`, `WorkflowArn`, `CreatedAt`, and `UpdatedAt`.
 */
public class IdMappingWorkflowSummary private constructor(builder: Builder) {
    /**
     * The timestamp of when the workflow was created.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.createdAt) { "A non-null value must be provided for createdAt" }
    /**
     * The timestamp of when the workflow was last updated.
     */
    public val updatedAt: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.updatedAt) { "A non-null value must be provided for updatedAt" }
    /**
     * The ARN (Amazon Resource Name) that Entity Resolution generated for the `IdMappingWorkflow`.
     */
    public val workflowArn: kotlin.String = requireNotNull(builder.workflowArn) { "A non-null value must be provided for workflowArn" }
    /**
     * The name of the workflow.
     */
    public val workflowName: kotlin.String = requireNotNull(builder.workflowName) { "A non-null value must be provided for workflowName" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.entityresolution.model.IdMappingWorkflowSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("IdMappingWorkflowSummary(")
        append("createdAt=$createdAt,")
        append("updatedAt=$updatedAt,")
        append("workflowArn=$workflowArn,")
        append("workflowName=$workflowName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = createdAt.hashCode()
        result = 31 * result + (updatedAt.hashCode())
        result = 31 * result + (workflowArn.hashCode())
        result = 31 * result + (workflowName.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as IdMappingWorkflowSummary

        if (createdAt != other.createdAt) return false
        if (updatedAt != other.updatedAt) return false
        if (workflowArn != other.workflowArn) return false
        if (workflowName != other.workflowName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.entityresolution.model.IdMappingWorkflowSummary = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The timestamp of when the workflow was created.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The timestamp of when the workflow was last updated.
         */
        public var updatedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The ARN (Amazon Resource Name) that Entity Resolution generated for the `IdMappingWorkflow`.
         */
        public var workflowArn: kotlin.String? = null
        /**
         * The name of the workflow.
         */
        public var workflowName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.entityresolution.model.IdMappingWorkflowSummary) : this() {
            this.createdAt = x.createdAt
            this.updatedAt = x.updatedAt
            this.workflowArn = x.workflowArn
            this.workflowName = x.workflowName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.entityresolution.model.IdMappingWorkflowSummary = IdMappingWorkflowSummary(this)

        internal fun correctErrors(): Builder {
            if (createdAt == null) createdAt = Instant.fromEpochSeconds(0)
            if (updatedAt == null) updatedAt = Instant.fromEpochSeconds(0)
            if (workflowArn == null) workflowArn = ""
            if (workflowName == null) workflowName = ""
            return this
        }
    }
}
