// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.emrserverless.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * The summary of attributes associated with a job run attempt.
 */
public class JobRunAttemptSummary private constructor(builder: Builder) {
    /**
     * The ID of the application the job is running on.
     */
    public val applicationId: kotlin.String = requireNotNull(builder.applicationId) { "A non-null value must be provided for applicationId" }
    /**
     * The Amazon Resource Name (ARN) of the job run.
     */
    public val arn: kotlin.String = requireNotNull(builder.arn) { "A non-null value must be provided for arn" }
    /**
     * The attempt number of the job run execution.
     */
    public val attempt: kotlin.Int? = builder.attempt
    /**
     * The date and time when the job run attempt was created.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.createdAt) { "A non-null value must be provided for createdAt" }
    /**
     * The user who created the job run.
     */
    public val createdBy: kotlin.String = requireNotNull(builder.createdBy) { "A non-null value must be provided for createdBy" }
    /**
     * The Amazon Resource Name (ARN) of the execution role of the job run..
     */
    public val executionRole: kotlin.String = requireNotNull(builder.executionRole) { "A non-null value must be provided for executionRole" }
    /**
     * The ID of the job run attempt.
     */
    public val id: kotlin.String = requireNotNull(builder.id) { "A non-null value must be provided for id" }
    /**
     * The date and time of when the job run was created.
     */
    public val jobCreatedAt: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.jobCreatedAt) { "A non-null value must be provided for jobCreatedAt" }
    /**
     * The mode of the job run attempt.
     */
    public val mode: aws.sdk.kotlin.services.emrserverless.model.JobRunMode? = builder.mode
    /**
     * The name of the job run attempt.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The Amazon EMR release label of the job run attempt.
     */
    public val releaseLabel: kotlin.String = requireNotNull(builder.releaseLabel) { "A non-null value must be provided for releaseLabel" }
    /**
     * The state of the job run attempt.
     */
    public val state: aws.sdk.kotlin.services.emrserverless.model.JobRunState = requireNotNull(builder.state) { "A non-null value must be provided for state" }
    /**
     * The state details of the job run attempt.
     */
    public val stateDetails: kotlin.String = requireNotNull(builder.stateDetails) { "A non-null value must be provided for stateDetails" }
    /**
     * The type of the job run, such as Spark or Hive.
     */
    public val type: kotlin.String? = builder.type
    /**
     * The date and time of when the job run attempt was last updated.
     */
    public val updatedAt: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.updatedAt) { "A non-null value must be provided for updatedAt" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.emrserverless.model.JobRunAttemptSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("JobRunAttemptSummary(")
        append("applicationId=$applicationId,")
        append("arn=$arn,")
        append("attempt=$attempt,")
        append("createdAt=$createdAt,")
        append("createdBy=$createdBy,")
        append("executionRole=$executionRole,")
        append("id=$id,")
        append("jobCreatedAt=$jobCreatedAt,")
        append("mode=$mode,")
        append("name=$name,")
        append("releaseLabel=$releaseLabel,")
        append("state=$state,")
        append("stateDetails=$stateDetails,")
        append("type=$type,")
        append("updatedAt=$updatedAt")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = applicationId.hashCode()
        result = 31 * result + (arn.hashCode())
        result = 31 * result + (attempt ?: 0)
        result = 31 * result + (createdAt.hashCode())
        result = 31 * result + (createdBy.hashCode())
        result = 31 * result + (executionRole.hashCode())
        result = 31 * result + (id.hashCode())
        result = 31 * result + (jobCreatedAt.hashCode())
        result = 31 * result + (mode?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (releaseLabel.hashCode())
        result = 31 * result + (state.hashCode())
        result = 31 * result + (stateDetails.hashCode())
        result = 31 * result + (type?.hashCode() ?: 0)
        result = 31 * result + (updatedAt.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as JobRunAttemptSummary

        if (applicationId != other.applicationId) return false
        if (arn != other.arn) return false
        if (attempt != other.attempt) return false
        if (createdAt != other.createdAt) return false
        if (createdBy != other.createdBy) return false
        if (executionRole != other.executionRole) return false
        if (id != other.id) return false
        if (jobCreatedAt != other.jobCreatedAt) return false
        if (mode != other.mode) return false
        if (name != other.name) return false
        if (releaseLabel != other.releaseLabel) return false
        if (state != other.state) return false
        if (stateDetails != other.stateDetails) return false
        if (type != other.type) return false
        if (updatedAt != other.updatedAt) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.emrserverless.model.JobRunAttemptSummary = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The ID of the application the job is running on.
         */
        public var applicationId: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the job run.
         */
        public var arn: kotlin.String? = null
        /**
         * The attempt number of the job run execution.
         */
        public var attempt: kotlin.Int? = null
        /**
         * The date and time when the job run attempt was created.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The user who created the job run.
         */
        public var createdBy: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the execution role of the job run..
         */
        public var executionRole: kotlin.String? = null
        /**
         * The ID of the job run attempt.
         */
        public var id: kotlin.String? = null
        /**
         * The date and time of when the job run was created.
         */
        public var jobCreatedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The mode of the job run attempt.
         */
        public var mode: aws.sdk.kotlin.services.emrserverless.model.JobRunMode? = null
        /**
         * The name of the job run attempt.
         */
        public var name: kotlin.String? = null
        /**
         * The Amazon EMR release label of the job run attempt.
         */
        public var releaseLabel: kotlin.String? = null
        /**
         * The state of the job run attempt.
         */
        public var state: aws.sdk.kotlin.services.emrserverless.model.JobRunState? = null
        /**
         * The state details of the job run attempt.
         */
        public var stateDetails: kotlin.String? = null
        /**
         * The type of the job run, such as Spark or Hive.
         */
        public var type: kotlin.String? = null
        /**
         * The date and time of when the job run attempt was last updated.
         */
        public var updatedAt: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.emrserverless.model.JobRunAttemptSummary) : this() {
            this.applicationId = x.applicationId
            this.arn = x.arn
            this.attempt = x.attempt
            this.createdAt = x.createdAt
            this.createdBy = x.createdBy
            this.executionRole = x.executionRole
            this.id = x.id
            this.jobCreatedAt = x.jobCreatedAt
            this.mode = x.mode
            this.name = x.name
            this.releaseLabel = x.releaseLabel
            this.state = x.state
            this.stateDetails = x.stateDetails
            this.type = x.type
            this.updatedAt = x.updatedAt
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.emrserverless.model.JobRunAttemptSummary = JobRunAttemptSummary(this)

        internal fun correctErrors(): Builder {
            if (applicationId == null) applicationId = ""
            if (arn == null) arn = ""
            if (createdAt == null) createdAt = Instant.fromEpochSeconds(0)
            if (createdBy == null) createdBy = ""
            if (executionRole == null) executionRole = ""
            if (id == null) id = ""
            if (jobCreatedAt == null) jobCreatedAt = Instant.fromEpochSeconds(0)
            if (releaseLabel == null) releaseLabel = ""
            if (state == null) state = JobRunState.SdkUnknown("no value provided")
            if (stateDetails == null) stateDetails = ""
            if (updatedAt == null) updatedAt = Instant.fromEpochSeconds(0)
            return this
        }
    }
}
