// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.emrserverless.paginators

import aws.sdk.kotlin.services.emrserverless.EmrServerlessClient
import aws.sdk.kotlin.services.emrserverless.model.ApplicationSummary
import aws.sdk.kotlin.services.emrserverless.model.JobRunAttemptSummary
import aws.sdk.kotlin.services.emrserverless.model.JobRunSummary
import aws.sdk.kotlin.services.emrserverless.model.ListApplicationsRequest
import aws.sdk.kotlin.services.emrserverless.model.ListApplicationsResponse
import aws.sdk.kotlin.services.emrserverless.model.ListJobRunAttemptsRequest
import aws.sdk.kotlin.services.emrserverless.model.ListJobRunAttemptsResponse
import aws.sdk.kotlin.services.emrserverless.model.ListJobRunsRequest
import aws.sdk.kotlin.services.emrserverless.model.ListJobRunsResponse
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [ListApplicationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListApplicationsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListApplicationsResponse]
 */
public fun EmrServerlessClient.listApplicationsPaginated(initialRequest: ListApplicationsRequest = ListApplicationsRequest { }): Flow<ListApplicationsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listApplicationsPaginated.listApplications(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListApplicationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListApplicationsResponse]
 */
public fun EmrServerlessClient.listApplicationsPaginated(block: ListApplicationsRequest.Builder.() -> Unit): Flow<ListApplicationsResponse> =
    listApplicationsPaginated(ListApplicationsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listApplicationsPaginated]
 * to access the nested member [ApplicationSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ApplicationSummary]
 */
@JvmName("listApplicationsResponseApplicationSummary")
public fun Flow<ListApplicationsResponse>.applications(): Flow<ApplicationSummary> =
    transform() { response ->
        response.applications?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListJobRunAttemptsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListJobRunAttemptsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListJobRunAttemptsResponse]
 */
public fun EmrServerlessClient.listJobRunAttemptsPaginated(initialRequest: ListJobRunAttemptsRequest): Flow<ListJobRunAttemptsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listJobRunAttemptsPaginated.listJobRunAttempts(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListJobRunAttemptsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListJobRunAttemptsResponse]
 */
public fun EmrServerlessClient.listJobRunAttemptsPaginated(block: ListJobRunAttemptsRequest.Builder.() -> Unit): Flow<ListJobRunAttemptsResponse> =
    listJobRunAttemptsPaginated(ListJobRunAttemptsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listJobRunAttemptsPaginated]
 * to access the nested member [JobRunAttemptSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [JobRunAttemptSummary]
 */
@JvmName("listJobRunAttemptsResponseJobRunAttemptSummary")
public fun Flow<ListJobRunAttemptsResponse>.jobRunAttempts(): Flow<JobRunAttemptSummary> =
    transform() { response ->
        response.jobRunAttempts?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListJobRunsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListJobRunsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListJobRunsResponse]
 */
public fun EmrServerlessClient.listJobRunsPaginated(initialRequest: ListJobRunsRequest): Flow<ListJobRunsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listJobRunsPaginated.listJobRuns(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListJobRunsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListJobRunsResponse]
 */
public fun EmrServerlessClient.listJobRunsPaginated(block: ListJobRunsRequest.Builder.() -> Unit): Flow<ListJobRunsResponse> =
    listJobRunsPaginated(ListJobRunsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listJobRunsPaginated]
 * to access the nested member [JobRunSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [JobRunSummary]
 */
@JvmName("listJobRunsResponseJobRunSummary")
public fun Flow<ListJobRunsResponse>.jobRuns(): Flow<JobRunSummary> =
    transform() { response ->
        response.jobRuns?.forEach {
            emit(it)
        }
    }
