// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.emrserverless.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The scheduler configuration for batch and streaming jobs running on this application. Supported with release labels emr-7.0.0 and above.
 */
public class SchedulerConfiguration private constructor(builder: Builder) {
    /**
     * The maximum concurrent job runs on this application. If scheduler configuration is enabled on your application, the default value is 15. The valid range is 1 to 1000.
     */
    public val maxConcurrentRuns: kotlin.Int? = builder.maxConcurrentRuns
    /**
     * The maximum duration in minutes for the job in QUEUED state. If scheduler configuration is enabled on your application, the default value is 360 minutes (6 hours). The valid range is from 15 to 720.
     */
    public val queueTimeoutMinutes: kotlin.Int? = builder.queueTimeoutMinutes

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.emrserverless.model.SchedulerConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SchedulerConfiguration(")
        append("maxConcurrentRuns=$maxConcurrentRuns,")
        append("queueTimeoutMinutes=$queueTimeoutMinutes")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = maxConcurrentRuns ?: 0
        result = 31 * result + (queueTimeoutMinutes ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SchedulerConfiguration

        if (maxConcurrentRuns != other.maxConcurrentRuns) return false
        if (queueTimeoutMinutes != other.queueTimeoutMinutes) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.emrserverless.model.SchedulerConfiguration = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The maximum concurrent job runs on this application. If scheduler configuration is enabled on your application, the default value is 15. The valid range is 1 to 1000.
         */
        public var maxConcurrentRuns: kotlin.Int? = null
        /**
         * The maximum duration in minutes for the job in QUEUED state. If scheduler configuration is enabled on your application, the default value is 360 minutes (6 hours). The valid range is from 15 to 720.
         */
        public var queueTimeoutMinutes: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.emrserverless.model.SchedulerConfiguration) : this() {
            this.maxConcurrentRuns = x.maxConcurrentRuns
            this.queueTimeoutMinutes = x.queueTimeoutMinutes
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.emrserverless.model.SchedulerConfiguration = SchedulerConfiguration(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
