// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.emrserverless.model

import aws.smithy.kotlin.runtime.SdkDsl

public class CreateApplicationRequest private constructor(builder: Builder) {
    /**
     * The CPU architecture of an application.
     */
    public val architecture: aws.sdk.kotlin.services.emrserverless.model.Architecture? = builder.architecture
    /**
     * The configuration for an application to automatically start on job submission.
     */
    public val autoStartConfiguration: aws.sdk.kotlin.services.emrserverless.model.AutoStartConfig? = builder.autoStartConfiguration
    /**
     * The configuration for an application to automatically stop after a certain amount of time being idle.
     */
    public val autoStopConfiguration: aws.sdk.kotlin.services.emrserverless.model.AutoStopConfig? = builder.autoStopConfiguration
    /**
     * The client idempotency token of the application to create. Its value must be unique for each request.
     */
    public val clientToken: kotlin.String = requireNotNull(builder.clientToken) { "A non-null value must be provided for clientToken" }
    /**
     * The image configuration for all worker types. You can either set this parameter or `imageConfiguration` for each worker type in `workerTypeSpecifications`.
     */
    public val imageConfiguration: aws.sdk.kotlin.services.emrserverless.model.ImageConfigurationInput? = builder.imageConfiguration
    /**
     * The capacity to initialize when the application is created.
     */
    public val initialCapacity: Map<String, InitialCapacityConfig>? = builder.initialCapacity
    /**
     * The interactive configuration object that enables the interactive use cases to use when running an application.
     */
    public val interactiveConfiguration: aws.sdk.kotlin.services.emrserverless.model.InteractiveConfiguration? = builder.interactiveConfiguration
    /**
     * The maximum capacity to allocate when the application is created. This is cumulative across all workers at any given point in time, not just when an application is created. No new resources will be created once any one of the defined limits is hit.
     */
    public val maximumCapacity: aws.sdk.kotlin.services.emrserverless.model.MaximumAllowedResources? = builder.maximumCapacity
    /**
     * The configuration setting for monitoring.
     */
    public val monitoringConfiguration: aws.sdk.kotlin.services.emrserverless.model.MonitoringConfiguration? = builder.monitoringConfiguration
    /**
     * The name of the application.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The network configuration for customer VPC connectivity.
     */
    public val networkConfiguration: aws.sdk.kotlin.services.emrserverless.model.NetworkConfiguration? = builder.networkConfiguration
    /**
     * The Amazon EMR release associated with the application.
     */
    public val releaseLabel: kotlin.String = requireNotNull(builder.releaseLabel) { "A non-null value must be provided for releaseLabel" }
    /**
     * The [Configuration](https://docs.aws.amazon.com/emr-serverless/latest/APIReference/API_Configuration.html) specifications to use when creating an application. Each configuration consists of a classification and properties. This configuration is applied to all the job runs submitted under the application.
     */
    public val runtimeConfiguration: List<Configuration>? = builder.runtimeConfiguration
    /**
     * The scheduler configuration for batch and streaming jobs running on this application. Supported with release labels emr-7.0.0 and above.
     */
    public val schedulerConfiguration: aws.sdk.kotlin.services.emrserverless.model.SchedulerConfiguration? = builder.schedulerConfiguration
    /**
     * The tags assigned to the application.
     */
    public val tags: Map<String, String>? = builder.tags
    /**
     * The type of application you want to start, such as Spark or Hive.
     */
    public val type: kotlin.String = requireNotNull(builder.type) { "A non-null value must be provided for type" }
    /**
     * The key-value pairs that specify worker type to `WorkerTypeSpecificationInput`. This parameter must contain all valid worker types for a Spark or Hive application. Valid worker types include `Driver` and `Executor` for Spark applications and `HiveDriver` and `TezTask` for Hive applications. You can either set image details in this parameter for each worker type, or in `imageConfiguration` for all worker types.
     */
    public val workerTypeSpecifications: Map<String, WorkerTypeSpecificationInput>? = builder.workerTypeSpecifications

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.emrserverless.model.CreateApplicationRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateApplicationRequest(")
        append("architecture=$architecture,")
        append("autoStartConfiguration=$autoStartConfiguration,")
        append("autoStopConfiguration=$autoStopConfiguration,")
        append("clientToken=$clientToken,")
        append("imageConfiguration=$imageConfiguration,")
        append("initialCapacity=$initialCapacity,")
        append("interactiveConfiguration=$interactiveConfiguration,")
        append("maximumCapacity=$maximumCapacity,")
        append("monitoringConfiguration=$monitoringConfiguration,")
        append("name=$name,")
        append("networkConfiguration=$networkConfiguration,")
        append("releaseLabel=$releaseLabel,")
        append("runtimeConfiguration=$runtimeConfiguration,")
        append("schedulerConfiguration=$schedulerConfiguration,")
        append("tags=$tags,")
        append("type=$type,")
        append("workerTypeSpecifications=$workerTypeSpecifications")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = architecture?.hashCode() ?: 0
        result = 31 * result + (autoStartConfiguration?.hashCode() ?: 0)
        result = 31 * result + (autoStopConfiguration?.hashCode() ?: 0)
        result = 31 * result + (clientToken.hashCode())
        result = 31 * result + (imageConfiguration?.hashCode() ?: 0)
        result = 31 * result + (initialCapacity?.hashCode() ?: 0)
        result = 31 * result + (interactiveConfiguration?.hashCode() ?: 0)
        result = 31 * result + (maximumCapacity?.hashCode() ?: 0)
        result = 31 * result + (monitoringConfiguration?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (networkConfiguration?.hashCode() ?: 0)
        result = 31 * result + (releaseLabel.hashCode())
        result = 31 * result + (runtimeConfiguration?.hashCode() ?: 0)
        result = 31 * result + (schedulerConfiguration?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (type.hashCode())
        result = 31 * result + (workerTypeSpecifications?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateApplicationRequest

        if (architecture != other.architecture) return false
        if (autoStartConfiguration != other.autoStartConfiguration) return false
        if (autoStopConfiguration != other.autoStopConfiguration) return false
        if (clientToken != other.clientToken) return false
        if (imageConfiguration != other.imageConfiguration) return false
        if (initialCapacity != other.initialCapacity) return false
        if (interactiveConfiguration != other.interactiveConfiguration) return false
        if (maximumCapacity != other.maximumCapacity) return false
        if (monitoringConfiguration != other.monitoringConfiguration) return false
        if (name != other.name) return false
        if (networkConfiguration != other.networkConfiguration) return false
        if (releaseLabel != other.releaseLabel) return false
        if (runtimeConfiguration != other.runtimeConfiguration) return false
        if (schedulerConfiguration != other.schedulerConfiguration) return false
        if (tags != other.tags) return false
        if (type != other.type) return false
        if (workerTypeSpecifications != other.workerTypeSpecifications) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.emrserverless.model.CreateApplicationRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The CPU architecture of an application.
         */
        public var architecture: aws.sdk.kotlin.services.emrserverless.model.Architecture? = null
        /**
         * The configuration for an application to automatically start on job submission.
         */
        public var autoStartConfiguration: aws.sdk.kotlin.services.emrserverless.model.AutoStartConfig? = null
        /**
         * The configuration for an application to automatically stop after a certain amount of time being idle.
         */
        public var autoStopConfiguration: aws.sdk.kotlin.services.emrserverless.model.AutoStopConfig? = null
        /**
         * The client idempotency token of the application to create. Its value must be unique for each request.
         */
        public var clientToken: kotlin.String? = null
        /**
         * The image configuration for all worker types. You can either set this parameter or `imageConfiguration` for each worker type in `workerTypeSpecifications`.
         */
        public var imageConfiguration: aws.sdk.kotlin.services.emrserverless.model.ImageConfigurationInput? = null
        /**
         * The capacity to initialize when the application is created.
         */
        public var initialCapacity: Map<String, InitialCapacityConfig>? = null
        /**
         * The interactive configuration object that enables the interactive use cases to use when running an application.
         */
        public var interactiveConfiguration: aws.sdk.kotlin.services.emrserverless.model.InteractiveConfiguration? = null
        /**
         * The maximum capacity to allocate when the application is created. This is cumulative across all workers at any given point in time, not just when an application is created. No new resources will be created once any one of the defined limits is hit.
         */
        public var maximumCapacity: aws.sdk.kotlin.services.emrserverless.model.MaximumAllowedResources? = null
        /**
         * The configuration setting for monitoring.
         */
        public var monitoringConfiguration: aws.sdk.kotlin.services.emrserverless.model.MonitoringConfiguration? = null
        /**
         * The name of the application.
         */
        public var name: kotlin.String? = null
        /**
         * The network configuration for customer VPC connectivity.
         */
        public var networkConfiguration: aws.sdk.kotlin.services.emrserverless.model.NetworkConfiguration? = null
        /**
         * The Amazon EMR release associated with the application.
         */
        public var releaseLabel: kotlin.String? = null
        /**
         * The [Configuration](https://docs.aws.amazon.com/emr-serverless/latest/APIReference/API_Configuration.html) specifications to use when creating an application. Each configuration consists of a classification and properties. This configuration is applied to all the job runs submitted under the application.
         */
        public var runtimeConfiguration: List<Configuration>? = null
        /**
         * The scheduler configuration for batch and streaming jobs running on this application. Supported with release labels emr-7.0.0 and above.
         */
        public var schedulerConfiguration: aws.sdk.kotlin.services.emrserverless.model.SchedulerConfiguration? = null
        /**
         * The tags assigned to the application.
         */
        public var tags: Map<String, String>? = null
        /**
         * The type of application you want to start, such as Spark or Hive.
         */
        public var type: kotlin.String? = null
        /**
         * The key-value pairs that specify worker type to `WorkerTypeSpecificationInput`. This parameter must contain all valid worker types for a Spark or Hive application. Valid worker types include `Driver` and `Executor` for Spark applications and `HiveDriver` and `TezTask` for Hive applications. You can either set image details in this parameter for each worker type, or in `imageConfiguration` for all worker types.
         */
        public var workerTypeSpecifications: Map<String, WorkerTypeSpecificationInput>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.emrserverless.model.CreateApplicationRequest) : this() {
            this.architecture = x.architecture
            this.autoStartConfiguration = x.autoStartConfiguration
            this.autoStopConfiguration = x.autoStopConfiguration
            this.clientToken = x.clientToken
            this.imageConfiguration = x.imageConfiguration
            this.initialCapacity = x.initialCapacity
            this.interactiveConfiguration = x.interactiveConfiguration
            this.maximumCapacity = x.maximumCapacity
            this.monitoringConfiguration = x.monitoringConfiguration
            this.name = x.name
            this.networkConfiguration = x.networkConfiguration
            this.releaseLabel = x.releaseLabel
            this.runtimeConfiguration = x.runtimeConfiguration
            this.schedulerConfiguration = x.schedulerConfiguration
            this.tags = x.tags
            this.type = x.type
            this.workerTypeSpecifications = x.workerTypeSpecifications
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.emrserverless.model.CreateApplicationRequest = CreateApplicationRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.emrserverless.model.AutoStartConfig] inside the given [block]
         */
        public fun autoStartConfiguration(block: aws.sdk.kotlin.services.emrserverless.model.AutoStartConfig.Builder.() -> kotlin.Unit) {
            this.autoStartConfiguration = aws.sdk.kotlin.services.emrserverless.model.AutoStartConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.emrserverless.model.AutoStopConfig] inside the given [block]
         */
        public fun autoStopConfiguration(block: aws.sdk.kotlin.services.emrserverless.model.AutoStopConfig.Builder.() -> kotlin.Unit) {
            this.autoStopConfiguration = aws.sdk.kotlin.services.emrserverless.model.AutoStopConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.emrserverless.model.ImageConfigurationInput] inside the given [block]
         */
        public fun imageConfiguration(block: aws.sdk.kotlin.services.emrserverless.model.ImageConfigurationInput.Builder.() -> kotlin.Unit) {
            this.imageConfiguration = aws.sdk.kotlin.services.emrserverless.model.ImageConfigurationInput.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.emrserverless.model.InteractiveConfiguration] inside the given [block]
         */
        public fun interactiveConfiguration(block: aws.sdk.kotlin.services.emrserverless.model.InteractiveConfiguration.Builder.() -> kotlin.Unit) {
            this.interactiveConfiguration = aws.sdk.kotlin.services.emrserverless.model.InteractiveConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.emrserverless.model.MaximumAllowedResources] inside the given [block]
         */
        public fun maximumCapacity(block: aws.sdk.kotlin.services.emrserverless.model.MaximumAllowedResources.Builder.() -> kotlin.Unit) {
            this.maximumCapacity = aws.sdk.kotlin.services.emrserverless.model.MaximumAllowedResources.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.emrserverless.model.MonitoringConfiguration] inside the given [block]
         */
        public fun monitoringConfiguration(block: aws.sdk.kotlin.services.emrserverless.model.MonitoringConfiguration.Builder.() -> kotlin.Unit) {
            this.monitoringConfiguration = aws.sdk.kotlin.services.emrserverless.model.MonitoringConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.emrserverless.model.NetworkConfiguration] inside the given [block]
         */
        public fun networkConfiguration(block: aws.sdk.kotlin.services.emrserverless.model.NetworkConfiguration.Builder.() -> kotlin.Unit) {
            this.networkConfiguration = aws.sdk.kotlin.services.emrserverless.model.NetworkConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.emrserverless.model.SchedulerConfiguration] inside the given [block]
         */
        public fun schedulerConfiguration(block: aws.sdk.kotlin.services.emrserverless.model.SchedulerConfiguration.Builder.() -> kotlin.Unit) {
            this.schedulerConfiguration = aws.sdk.kotlin.services.emrserverless.model.SchedulerConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (clientToken == null) clientToken = ""
            if (releaseLabel == null) releaseLabel = ""
            if (type == null) type = ""
            return this
        }
    }
}
