// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.emrserverless.serde

import aws.sdk.kotlin.services.emrserverless.model.ConfigurationOverrides
import aws.sdk.kotlin.services.emrserverless.model.JobDriver
import aws.sdk.kotlin.services.emrserverless.model.JobRunMode
import aws.sdk.kotlin.services.emrserverless.model.RetryPolicy
import aws.sdk.kotlin.services.emrserverless.model.StartJobRunRequest
import aws.smithy.kotlin.runtime.client.idempotencyTokenProvider
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class StartJobRunOperationSerializer: HttpSerializer.NonStreaming<StartJobRunRequest> {
    override fun serialize(context: ExecutionContext, input: StartJobRunRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path.encodedSegments {
                add(PercentEncoding.Path.encode("applications"))
                add(PercentEncoding.SmithyLabel.encode(input.applicationId))
                add(PercentEncoding.Path.encode("jobruns"))
            }
        }

        val payload = serializeStartJobRunOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeStartJobRunOperationBody(context: ExecutionContext, input: StartJobRunRequest): ByteArray {
    val serializer = JsonSerializer()
    val CLIENTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("clientToken"))
    val CONFIGURATIONOVERRIDES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("configurationOverrides"))
    val EXECUTIONROLEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("executionRoleArn"))
    val EXECUTIONTIMEOUTMINUTES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, JsonSerialName("executionTimeoutMinutes"))
    val JOBDRIVER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("jobDriver"))
    val MODE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("mode"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("name"))
    val RETRYPOLICY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("retryPolicy"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("tags"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CLIENTTOKEN_DESCRIPTOR)
        field(CONFIGURATIONOVERRIDES_DESCRIPTOR)
        field(EXECUTIONROLEARN_DESCRIPTOR)
        field(EXECUTIONTIMEOUTMINUTES_DESCRIPTOR)
        field(JOBDRIVER_DESCRIPTOR)
        field(MODE_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(RETRYPOLICY_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        field(CLIENTTOKEN_DESCRIPTOR, input.clientToken) ?: field(CLIENTTOKEN_DESCRIPTOR, context.idempotencyTokenProvider.generateToken())
        input.configurationOverrides?.let { field(CONFIGURATIONOVERRIDES_DESCRIPTOR, it, ::serializeConfigurationOverridesDocument) }
        field(EXECUTIONROLEARN_DESCRIPTOR, input.executionRoleArn)
        input.executionTimeoutMinutes?.let { field(EXECUTIONTIMEOUTMINUTES_DESCRIPTOR, it) }
        input.jobDriver?.let { field(JOBDRIVER_DESCRIPTOR, it, ::serializeJobDriverDocument) }
        input.mode?.let { field(MODE_DESCRIPTOR, it.value) }
        input.name?.let { field(NAME_DESCRIPTOR, it) }
        input.retryPolicy?.let { field(RETRYPOLICY_DESCRIPTOR, it, ::serializeRetryPolicyDocument) }
        if (input.tags != null) {
            mapField(TAGS_DESCRIPTOR) {
                input.tags.forEach { (key, value) ->
                    entry(key, value)
                }
            }
        }
    }
    return serializer.toByteArray()
}
