// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.emrserverless

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.client.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.config.endpoints.resolveEndpointUrl
import aws.sdk.kotlin.runtime.config.profile.AwsProfile
import aws.sdk.kotlin.runtime.config.profile.AwsSharedConfig
import aws.sdk.kotlin.runtime.http.retries.AwsRetryPolicy
import aws.sdk.kotlin.services.emrserverless.auth.DefaultEmrServerlessAuthSchemeProvider
import aws.sdk.kotlin.services.emrserverless.auth.EmrServerlessAuthSchemeProvider
import aws.sdk.kotlin.services.emrserverless.endpoints.DefaultEmrServerlessEndpointProvider
import aws.sdk.kotlin.services.emrserverless.endpoints.EmrServerlessEndpointParameters
import aws.sdk.kotlin.services.emrserverless.endpoints.EmrServerlessEndpointProvider
import aws.sdk.kotlin.services.emrserverless.model.CancelJobRunRequest
import aws.sdk.kotlin.services.emrserverless.model.CancelJobRunResponse
import aws.sdk.kotlin.services.emrserverless.model.CreateApplicationRequest
import aws.sdk.kotlin.services.emrserverless.model.CreateApplicationResponse
import aws.sdk.kotlin.services.emrserverless.model.DeleteApplicationRequest
import aws.sdk.kotlin.services.emrserverless.model.DeleteApplicationResponse
import aws.sdk.kotlin.services.emrserverless.model.GetApplicationRequest
import aws.sdk.kotlin.services.emrserverless.model.GetApplicationResponse
import aws.sdk.kotlin.services.emrserverless.model.GetDashboardForJobRunRequest
import aws.sdk.kotlin.services.emrserverless.model.GetDashboardForJobRunResponse
import aws.sdk.kotlin.services.emrserverless.model.GetJobRunRequest
import aws.sdk.kotlin.services.emrserverless.model.GetJobRunResponse
import aws.sdk.kotlin.services.emrserverless.model.ListApplicationsRequest
import aws.sdk.kotlin.services.emrserverless.model.ListApplicationsResponse
import aws.sdk.kotlin.services.emrserverless.model.ListJobRunAttemptsRequest
import aws.sdk.kotlin.services.emrserverless.model.ListJobRunAttemptsResponse
import aws.sdk.kotlin.services.emrserverless.model.ListJobRunsRequest
import aws.sdk.kotlin.services.emrserverless.model.ListJobRunsResponse
import aws.sdk.kotlin.services.emrserverless.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.emrserverless.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.emrserverless.model.StartApplicationRequest
import aws.sdk.kotlin.services.emrserverless.model.StartApplicationResponse
import aws.sdk.kotlin.services.emrserverless.model.StartJobRunRequest
import aws.sdk.kotlin.services.emrserverless.model.StartJobRunResponse
import aws.sdk.kotlin.services.emrserverless.model.StopApplicationRequest
import aws.sdk.kotlin.services.emrserverless.model.StopApplicationResponse
import aws.sdk.kotlin.services.emrserverless.model.TagResourceRequest
import aws.sdk.kotlin.services.emrserverless.model.TagResourceResponse
import aws.sdk.kotlin.services.emrserverless.model.UntagResourceRequest
import aws.sdk.kotlin.services.emrserverless.model.UntagResourceResponse
import aws.sdk.kotlin.services.emrserverless.model.UpdateApplicationRequest
import aws.sdk.kotlin.services.emrserverless.model.UpdateApplicationResponse
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.awsprotocol.ClockSkewInterceptor
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.AbstractSdkClientFactory
import aws.smithy.kotlin.runtime.client.IdempotencyTokenConfig
import aws.smithy.kotlin.runtime.client.IdempotencyTokenProvider
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.url.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.telemetry.Global
import aws.smithy.kotlin.runtime.telemetry.TelemetryConfig
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider
import aws.smithy.kotlin.runtime.util.LazyAsyncValue
import kotlin.collections.List
import kotlin.jvm.JvmStatic


public const val ServiceId: String = "EMR Serverless"
public const val SdkVersion: String = "1.3.2"
public const val ServiceApiVersion: String = "2021-07-13"

/**
 * Amazon EMR Serverless is a new deployment option for Amazon EMR. Amazon EMR Serverless provides a serverless runtime environment that simplifies running analytics applications using the latest open source frameworks such as Apache Spark and Apache Hive. With Amazon EMR Serverless, you don’t have to configure, optimize, secure, or operate clusters to run applications with these frameworks.
 *
 * The API reference to Amazon EMR Serverless is `emr-serverless`. The `emr-serverless` prefix is used in the following scenarios:
 * + It is the prefix in the CLI commands for Amazon EMR Serverless. For example, `aws emr-serverless start-job-run`.
 * + It is the prefix before IAM policy actions for Amazon EMR Serverless. For example, `"Action": ["emr-serverless:StartJobRun"]`. For more information, see [Policy actions for Amazon EMR Serverless](https://docs.aws.amazon.com/emr/latest/EMR-Serverless-UserGuide/security_iam_service-with-iam.html#security_iam_service-with-iam-id-based-policies-actions).
 * + It is the prefix used in Amazon EMR Serverless service endpoints. For example, `emr-serverless.us-east-2.amazonaws.com`.
 */
public interface EmrServerlessClient : SdkClient {
    /**
     * EmrServerlessClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, EmrServerlessClient, Builder>()
     {
        @JvmStatic
        override fun builder(): Builder = Builder()

        override fun finalizeConfig(builder: Builder) {
            super.finalizeConfig(builder)
            builder.config.interceptors.add(0, ClockSkewInterceptor())
        }

        override suspend fun finalizeEnvironmentalConfig(builder: Builder, sharedConfig: LazyAsyncValue<AwsSharedConfig>, activeProfile: LazyAsyncValue<AwsProfile>) {
            super.finalizeEnvironmentalConfig(builder, sharedConfig, activeProfile)
            builder.config.endpointUrl = builder.config.endpointUrl ?: resolveEndpointUrl(
                sharedConfig,
                "EmrServerless",
                "EMR_SERVERLESS",
                "emr_serverless",
            )
        }
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, EmrServerlessClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): EmrServerlessClient = DefaultEmrServerlessClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), IdempotencyTokenConfig, RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TelemetryConfig {
        override val clientName: String = builder.clientName
        override val region: String? = builder.region
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = builder.authSchemes
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointProvider: EmrServerlessEndpointProvider = builder.endpointProvider ?: DefaultEmrServerlessEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val idempotencyTokenProvider: IdempotencyTokenProvider = builder.idempotencyTokenProvider ?: IdempotencyTokenProvider.Default
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsRetryPolicy.Default
        override val telemetryProvider: TelemetryProvider = builder.telemetryProvider ?: TelemetryProvider.Global
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        override val applicationId: String? = builder.applicationId
        public val authSchemeProvider: EmrServerlessAuthSchemeProvider = builder.authSchemeProvider ?: DefaultEmrServerlessAuthSchemeProvider()
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            authSchemes = this@Config.authSchemes
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            idempotencyTokenProvider = this@Config.idempotencyTokenProvider
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            telemetryProvider = this@Config.telemetryProvider
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
            applicationId = this@Config.applicationId
            authSchemeProvider = this@Config.authSchemeProvider
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), IdempotencyTokenConfig.Builder, RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TelemetryConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "EMR Serverless"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more
             * information
             */
            override var region: String? = null

            /**
             * Register new or override default [AuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = emptyList()

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: EmrServerlessEndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Override the default idempotency token generator. SDK clients will generate tokens for members
             * that represent idempotent tokens when not explicitly set by the caller using this generator.
             */
            override var idempotencyTokenProvider: IdempotencyTokenProvider? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The telemetry provider used to instrument the SDK operations with. By default, the global telemetry
             * provider will be used.
             */
            override var telemetryProvider: TelemetryProvider? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            /**
             * An optional application specific identifier.
             * When set it will be appended to the User-Agent header of every request in the form of: `app/{applicationId}`.
             * When not explicitly set, the value will be loaded from the following locations:
             *
             * - JVM System Property: `aws.userAgentAppId`
             * - Environment variable: `AWS_SDK_UA_APP_ID`
             * - Shared configuration profile attribute: `sdk_ua_app_id`
             *
             * See [shared configuration settings](https://docs.aws.amazon.com/sdkref/latest/guide/settings-reference.html)
             * reference for more information on environment variables and shared config settings.
             */
            override var applicationId: String? = null

            /**
             * Configure the provider used to resolve the authentication scheme to use for a particular operation.
             */
            public var authSchemeProvider: EmrServerlessAuthSchemeProvider? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Cancels a job run.
     */
    public suspend fun cancelJobRun(input: CancelJobRunRequest): CancelJobRunResponse

    /**
     * Creates an application.
     */
    public suspend fun createApplication(input: CreateApplicationRequest): CreateApplicationResponse

    /**
     * Deletes an application. An application has to be in a stopped or created state in order to be deleted.
     */
    public suspend fun deleteApplication(input: DeleteApplicationRequest): DeleteApplicationResponse

    /**
     * Displays detailed information about a specified application.
     */
    public suspend fun getApplication(input: GetApplicationRequest): GetApplicationResponse

    /**
     * Creates and returns a URL that you can use to access the application UIs for a job run.
     *
     * For jobs in a running state, the application UI is a live user interface such as the Spark or Tez web UI. For completed jobs, the application UI is a persistent application user interface such as the Spark History Server or persistent Tez UI.
     *
     * The URL is valid for one hour after you generate it. To access the application UI after that hour elapses, you must invoke the API again to generate a new URL.
     */
    public suspend fun getDashboardForJobRun(input: GetDashboardForJobRunRequest): GetDashboardForJobRunResponse

    /**
     * Displays detailed information about a job run.
     */
    public suspend fun getJobRun(input: GetJobRunRequest): GetJobRunResponse

    /**
     * Lists applications based on a set of parameters.
     */
    public suspend fun listApplications(input: ListApplicationsRequest = ListApplicationsRequest { }): ListApplicationsResponse

    /**
     * Lists all attempt of a job run.
     */
    public suspend fun listJobRunAttempts(input: ListJobRunAttemptsRequest): ListJobRunAttemptsResponse

    /**
     * Lists job runs based on a set of parameters.
     */
    public suspend fun listJobRuns(input: ListJobRunsRequest): ListJobRunsResponse

    /**
     * Lists the tags assigned to the resources.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Starts a specified application and initializes initial capacity if configured.
     */
    public suspend fun startApplication(input: StartApplicationRequest): StartApplicationResponse

    /**
     * Starts a job run.
     */
    public suspend fun startJobRun(input: StartJobRunRequest): StartJobRunResponse

    /**
     * Stops a specified application and releases initial capacity if configured. All scheduled and running jobs must be completed or cancelled before stopping an application.
     */
    public suspend fun stopApplication(input: StopApplicationRequest): StopApplicationResponse

    /**
     * Assigns tags to resources. A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key and an optional value, both of which you define. Tags enable you to categorize your Amazon Web Services resources by attributes such as purpose, owner, or environment. When you have many resources of the same type, you can quickly identify a specific resource based on the tags you've assigned to it.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Removes tags from resources.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Updates a specified application. An application has to be in a stopped or created state in order to be updated.
     */
    public suspend fun updateApplication(input: UpdateApplicationRequest): UpdateApplicationResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun EmrServerlessClient.withConfig(block: EmrServerlessClient.Config.Builder.() -> Unit): EmrServerlessClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultEmrServerlessClient(newConfig)
}

/**
 * Cancels a job run.
 */
public suspend inline fun EmrServerlessClient.cancelJobRun(crossinline block: CancelJobRunRequest.Builder.() -> Unit): CancelJobRunResponse = cancelJobRun(CancelJobRunRequest.Builder().apply(block).build())

/**
 * Creates an application.
 */
public suspend inline fun EmrServerlessClient.createApplication(crossinline block: CreateApplicationRequest.Builder.() -> Unit): CreateApplicationResponse = createApplication(CreateApplicationRequest.Builder().apply(block).build())

/**
 * Deletes an application. An application has to be in a stopped or created state in order to be deleted.
 */
public suspend inline fun EmrServerlessClient.deleteApplication(crossinline block: DeleteApplicationRequest.Builder.() -> Unit): DeleteApplicationResponse = deleteApplication(DeleteApplicationRequest.Builder().apply(block).build())

/**
 * Displays detailed information about a specified application.
 */
public suspend inline fun EmrServerlessClient.getApplication(crossinline block: GetApplicationRequest.Builder.() -> Unit): GetApplicationResponse = getApplication(GetApplicationRequest.Builder().apply(block).build())

/**
 * Creates and returns a URL that you can use to access the application UIs for a job run.
 *
 * For jobs in a running state, the application UI is a live user interface such as the Spark or Tez web UI. For completed jobs, the application UI is a persistent application user interface such as the Spark History Server or persistent Tez UI.
 *
 * The URL is valid for one hour after you generate it. To access the application UI after that hour elapses, you must invoke the API again to generate a new URL.
 */
public suspend inline fun EmrServerlessClient.getDashboardForJobRun(crossinline block: GetDashboardForJobRunRequest.Builder.() -> Unit): GetDashboardForJobRunResponse = getDashboardForJobRun(GetDashboardForJobRunRequest.Builder().apply(block).build())

/**
 * Displays detailed information about a job run.
 */
public suspend inline fun EmrServerlessClient.getJobRun(crossinline block: GetJobRunRequest.Builder.() -> Unit): GetJobRunResponse = getJobRun(GetJobRunRequest.Builder().apply(block).build())

/**
 * Lists applications based on a set of parameters.
 */
public suspend inline fun EmrServerlessClient.listApplications(crossinline block: ListApplicationsRequest.Builder.() -> Unit): ListApplicationsResponse = listApplications(ListApplicationsRequest.Builder().apply(block).build())

/**
 * Lists all attempt of a job run.
 */
public suspend inline fun EmrServerlessClient.listJobRunAttempts(crossinline block: ListJobRunAttemptsRequest.Builder.() -> Unit): ListJobRunAttemptsResponse = listJobRunAttempts(ListJobRunAttemptsRequest.Builder().apply(block).build())

/**
 * Lists job runs based on a set of parameters.
 */
public suspend inline fun EmrServerlessClient.listJobRuns(crossinline block: ListJobRunsRequest.Builder.() -> Unit): ListJobRunsResponse = listJobRuns(ListJobRunsRequest.Builder().apply(block).build())

/**
 * Lists the tags assigned to the resources.
 */
public suspend inline fun EmrServerlessClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Starts a specified application and initializes initial capacity if configured.
 */
public suspend inline fun EmrServerlessClient.startApplication(crossinline block: StartApplicationRequest.Builder.() -> Unit): StartApplicationResponse = startApplication(StartApplicationRequest.Builder().apply(block).build())

/**
 * Starts a job run.
 */
public suspend inline fun EmrServerlessClient.startJobRun(crossinline block: StartJobRunRequest.Builder.() -> Unit): StartJobRunResponse = startJobRun(StartJobRunRequest.Builder().apply(block).build())

/**
 * Stops a specified application and releases initial capacity if configured. All scheduled and running jobs must be completed or cancelled before stopping an application.
 */
public suspend inline fun EmrServerlessClient.stopApplication(crossinline block: StopApplicationRequest.Builder.() -> Unit): StopApplicationResponse = stopApplication(StopApplicationRequest.Builder().apply(block).build())

/**
 * Assigns tags to resources. A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key and an optional value, both of which you define. Tags enable you to categorize your Amazon Web Services resources by attributes such as purpose, owner, or environment. When you have many resources of the same type, you can quickly identify a specific resource based on the tags you've assigned to it.
 */
public suspend inline fun EmrServerlessClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Removes tags from resources.
 */
public suspend inline fun EmrServerlessClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Updates a specified application. An application has to be in a stopped or created state in order to be updated.
 */
public suspend inline fun EmrServerlessClient.updateApplication(crossinline block: UpdateApplicationRequest.Builder.() -> Unit): UpdateApplicationResponse = updateApplication(UpdateApplicationRequest.Builder().apply(block).build())
