// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.emrserverless.serde

import aws.sdk.kotlin.services.emrserverless.model.EmrServerlessException
import aws.sdk.kotlin.services.emrserverless.model.GetDashboardForJobRunResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class GetDashboardForJobRunOperationDeserializer: HttpDeserializer.NonStreaming<GetDashboardForJobRunResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): GetDashboardForJobRunResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetDashboardForJobRunError(context, call, payload)
        }
        val builder = GetDashboardForJobRunResponse.Builder()

        if (payload != null) {
            deserializeGetDashboardForJobRunOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwGetDashboardForJobRunError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw EmrServerlessException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> EmrServerlessException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetDashboardForJobRunOperationBody(builder: GetDashboardForJobRunResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val URL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("url"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(URL_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                URL_DESCRIPTOR.index -> builder.url = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
