// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.emrserverless.model

import aws.smithy.kotlin.runtime.SdkDsl

public class StartJobRunRequest private constructor(builder: Builder) {
    /**
     * The ID of the application on which to run the job.
     */
    public val applicationId: kotlin.String = requireNotNull(builder.applicationId) { "A non-null value must be provided for applicationId" }
    /**
     * The client idempotency token of the job run to start. Its value must be unique for each request.
     */
    public val clientToken: kotlin.String = requireNotNull(builder.clientToken) { "A non-null value must be provided for clientToken" }
    /**
     * The configuration overrides for the job run.
     */
    public val configurationOverrides: aws.sdk.kotlin.services.emrserverless.model.ConfigurationOverrides? = builder.configurationOverrides
    /**
     * The execution role ARN for the job run.
     */
    public val executionRoleArn: kotlin.String = requireNotNull(builder.executionRoleArn) { "A non-null value must be provided for executionRoleArn" }
    /**
     * The maximum duration for the job run to run. If the job run runs beyond this duration, it will be automatically cancelled.
     */
    public val executionTimeoutMinutes: kotlin.Long? = builder.executionTimeoutMinutes
    /**
     * The job driver for the job run.
     */
    public val jobDriver: aws.sdk.kotlin.services.emrserverless.model.JobDriver? = builder.jobDriver
    /**
     * The mode of the job run when it starts.
     */
    public val mode: aws.sdk.kotlin.services.emrserverless.model.JobRunMode? = builder.mode
    /**
     * The optional job run name. This doesn't have to be unique.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The retry policy when job run starts.
     */
    public val retryPolicy: aws.sdk.kotlin.services.emrserverless.model.RetryPolicy? = builder.retryPolicy
    /**
     * The tags assigned to the job run.
     */
    public val tags: Map<String, String>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.emrserverless.model.StartJobRunRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("StartJobRunRequest(")
        append("applicationId=$applicationId,")
        append("clientToken=$clientToken,")
        append("configurationOverrides=$configurationOverrides,")
        append("executionRoleArn=$executionRoleArn,")
        append("executionTimeoutMinutes=$executionTimeoutMinutes,")
        append("jobDriver=$jobDriver,")
        append("mode=$mode,")
        append("name=$name,")
        append("retryPolicy=$retryPolicy,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = applicationId.hashCode()
        result = 31 * result + (clientToken.hashCode())
        result = 31 * result + (configurationOverrides?.hashCode() ?: 0)
        result = 31 * result + (executionRoleArn.hashCode())
        result = 31 * result + (executionTimeoutMinutes?.hashCode() ?: 0)
        result = 31 * result + (jobDriver?.hashCode() ?: 0)
        result = 31 * result + (mode?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (retryPolicy?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as StartJobRunRequest

        if (applicationId != other.applicationId) return false
        if (clientToken != other.clientToken) return false
        if (configurationOverrides != other.configurationOverrides) return false
        if (executionRoleArn != other.executionRoleArn) return false
        if (executionTimeoutMinutes != other.executionTimeoutMinutes) return false
        if (jobDriver != other.jobDriver) return false
        if (mode != other.mode) return false
        if (name != other.name) return false
        if (retryPolicy != other.retryPolicy) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.emrserverless.model.StartJobRunRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The ID of the application on which to run the job.
         */
        public var applicationId: kotlin.String? = null
        /**
         * The client idempotency token of the job run to start. Its value must be unique for each request.
         */
        public var clientToken: kotlin.String? = null
        /**
         * The configuration overrides for the job run.
         */
        public var configurationOverrides: aws.sdk.kotlin.services.emrserverless.model.ConfigurationOverrides? = null
        /**
         * The execution role ARN for the job run.
         */
        public var executionRoleArn: kotlin.String? = null
        /**
         * The maximum duration for the job run to run. If the job run runs beyond this duration, it will be automatically cancelled.
         */
        public var executionTimeoutMinutes: kotlin.Long? = null
        /**
         * The job driver for the job run.
         */
        public var jobDriver: aws.sdk.kotlin.services.emrserverless.model.JobDriver? = null
        /**
         * The mode of the job run when it starts.
         */
        public var mode: aws.sdk.kotlin.services.emrserverless.model.JobRunMode? = null
        /**
         * The optional job run name. This doesn't have to be unique.
         */
        public var name: kotlin.String? = null
        /**
         * The retry policy when job run starts.
         */
        public var retryPolicy: aws.sdk.kotlin.services.emrserverless.model.RetryPolicy? = null
        /**
         * The tags assigned to the job run.
         */
        public var tags: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.emrserverless.model.StartJobRunRequest) : this() {
            this.applicationId = x.applicationId
            this.clientToken = x.clientToken
            this.configurationOverrides = x.configurationOverrides
            this.executionRoleArn = x.executionRoleArn
            this.executionTimeoutMinutes = x.executionTimeoutMinutes
            this.jobDriver = x.jobDriver
            this.mode = x.mode
            this.name = x.name
            this.retryPolicy = x.retryPolicy
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.emrserverless.model.StartJobRunRequest = StartJobRunRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.emrserverless.model.ConfigurationOverrides] inside the given [block]
         */
        public fun configurationOverrides(block: aws.sdk.kotlin.services.emrserverless.model.ConfigurationOverrides.Builder.() -> kotlin.Unit) {
            this.configurationOverrides = aws.sdk.kotlin.services.emrserverless.model.ConfigurationOverrides.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.emrserverless.model.RetryPolicy] inside the given [block]
         */
        public fun retryPolicy(block: aws.sdk.kotlin.services.emrserverless.model.RetryPolicy.Builder.() -> kotlin.Unit) {
            this.retryPolicy = aws.sdk.kotlin.services.emrserverless.model.RetryPolicy.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (applicationId == null) applicationId = ""
            if (clientToken == null) clientToken = ""
            if (executionRoleArn == null) executionRoleArn = ""
            return this
        }
    }
}
