// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.emrserverless.transform

import aws.sdk.kotlin.services.emrserverless.model.JobRunState
import aws.sdk.kotlin.services.emrserverless.model.ListJobRunsRequest
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.http.util.encodeLabel
import aws.smithy.kotlin.runtime.net.parameters
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat


internal class ListJobRunsOperationSerializer: HttpSerialize<ListJobRunsRequest> {
    override suspend fun serialize(context: ExecutionContext, input: ListJobRunsRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.GET

        builder.url {
            val pathSegments = listOf<String>(
                "applications",
                "${input.applicationId}".encodeLabel(),
                "jobruns",
            )
            path = pathSegments.joinToString(separator = "/", prefix = "/")
            parameters {
                if (input.createdAtAfter != null) append("createdAtAfter", input.createdAtAfter.format(TimestampFormat.ISO_8601))
                if (input.createdAtBefore != null) append("createdAtBefore", input.createdAtBefore.format(TimestampFormat.ISO_8601))
                if (input.maxResults != null) append("maxResults", "${input.maxResults}")
                if (input.nextToken != null) append("nextToken", input.nextToken)
                if (input.states?.isNotEmpty() == true) appendAll("states", input.states.map { it.value })
            }
        }

        return builder
    }
}
