// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.emrserverless.transform

import aws.sdk.kotlin.services.emrserverless.model.Architecture
import aws.sdk.kotlin.services.emrserverless.model.AutoStartConfig
import aws.sdk.kotlin.services.emrserverless.model.AutoStopConfig
import aws.sdk.kotlin.services.emrserverless.model.CreateApplicationRequest
import aws.sdk.kotlin.services.emrserverless.model.ImageConfigurationInput
import aws.sdk.kotlin.services.emrserverless.model.InitialCapacityConfig
import aws.sdk.kotlin.services.emrserverless.model.MaximumAllowedResources
import aws.sdk.kotlin.services.emrserverless.model.NetworkConfiguration
import aws.sdk.kotlin.services.emrserverless.model.WorkerTypeSpecificationInput
import aws.smithy.kotlin.runtime.client.idempotencyTokenProvider
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateApplicationOperationSerializer: HttpSerialize<CreateApplicationRequest> {
    override suspend fun serialize(context: ExecutionContext, input: CreateApplicationRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path = "/applications"
        }

        val payload = serializeCreateApplicationOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeCreateApplicationOperationBody(context: ExecutionContext, input: CreateApplicationRequest): ByteArray {
    val serializer = JsonSerializer()
    val ARCHITECTURE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("architecture"))
    val AUTOSTARTCONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("autoStartConfiguration"))
    val AUTOSTOPCONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("autoStopConfiguration"))
    val CLIENTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("clientToken"))
    val IMAGECONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("imageConfiguration"))
    val INITIALCAPACITY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("initialCapacity"))
    val MAXIMUMCAPACITY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("maximumCapacity"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("name"))
    val NETWORKCONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("networkConfiguration"))
    val RELEASELABEL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("releaseLabel"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("tags"))
    val TYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("type"))
    val WORKERTYPESPECIFICATIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("workerTypeSpecifications"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ARCHITECTURE_DESCRIPTOR)
        field(AUTOSTARTCONFIGURATION_DESCRIPTOR)
        field(AUTOSTOPCONFIGURATION_DESCRIPTOR)
        field(CLIENTTOKEN_DESCRIPTOR)
        field(IMAGECONFIGURATION_DESCRIPTOR)
        field(INITIALCAPACITY_DESCRIPTOR)
        field(MAXIMUMCAPACITY_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(NETWORKCONFIGURATION_DESCRIPTOR)
        field(RELEASELABEL_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
        field(TYPE_DESCRIPTOR)
        field(WORKERTYPESPECIFICATIONS_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.architecture?.let { field(ARCHITECTURE_DESCRIPTOR, it.value) }
        input.autoStartConfiguration?.let { field(AUTOSTARTCONFIGURATION_DESCRIPTOR, it, ::serializeAutoStartConfigDocument) }
        input.autoStopConfiguration?.let { field(AUTOSTOPCONFIGURATION_DESCRIPTOR, it, ::serializeAutoStopConfigDocument) }
        input.clientToken?.let { field(CLIENTTOKEN_DESCRIPTOR, it) } ?: field(CLIENTTOKEN_DESCRIPTOR, context.idempotencyTokenProvider.generateToken())
        input.imageConfiguration?.let { field(IMAGECONFIGURATION_DESCRIPTOR, it, ::serializeImageConfigurationInputDocument) }
        if (input.initialCapacity != null) {
            mapField(INITIALCAPACITY_DESCRIPTOR) {
                input.initialCapacity.forEach { (key, value) -> entry(key, asSdkSerializable(value, ::serializeInitialCapacityConfigDocument)) }
            }
        }
        input.maximumCapacity?.let { field(MAXIMUMCAPACITY_DESCRIPTOR, it, ::serializeMaximumAllowedResourcesDocument) }
        input.name?.let { field(NAME_DESCRIPTOR, it) }
        input.networkConfiguration?.let { field(NETWORKCONFIGURATION_DESCRIPTOR, it, ::serializeNetworkConfigurationDocument) }
        input.releaseLabel?.let { field(RELEASELABEL_DESCRIPTOR, it) }
        if (input.tags != null) {
            mapField(TAGS_DESCRIPTOR) {
                input.tags.forEach { (key, value) -> entry(key, value) }
            }
        }
        input.type?.let { field(TYPE_DESCRIPTOR, it) }
        if (input.workerTypeSpecifications != null) {
            mapField(WORKERTYPESPECIFICATIONS_DESCRIPTOR) {
                input.workerTypeSpecifications.forEach { (key, value) -> entry(key, asSdkSerializable(value, ::serializeWorkerTypeSpecificationInputDocument)) }
            }
        }
    }
    return serializer.toByteArray()
}
