// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.emrserverless.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Information about an application. Amazon EMR Serverless uses applications to run jobs.
 */
public class Application private constructor(builder: Builder) {
    /**
     * The ID of the application.
     */
    public val applicationId: kotlin.String? = builder.applicationId
    /**
     * The CPU architecture of an application.
     */
    public val architecture: aws.sdk.kotlin.services.emrserverless.model.Architecture? = builder.architecture
    /**
     * The ARN of the application.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * The configuration for an application to automatically start on job submission.
     */
    public val autoStartConfiguration: aws.sdk.kotlin.services.emrserverless.model.AutoStartConfig? = builder.autoStartConfiguration
    /**
     * The configuration for an application to automatically stop after a certain amount of time being idle.
     */
    public val autoStopConfiguration: aws.sdk.kotlin.services.emrserverless.model.AutoStopConfig? = builder.autoStopConfiguration
    /**
     * The date and time when the application run was created.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant? = builder.createdAt
    /**
     * The image configuration applied to all worker types.
     */
    public val imageConfiguration: aws.sdk.kotlin.services.emrserverless.model.ImageConfiguration? = builder.imageConfiguration
    /**
     * The initial capacity of the application.
     */
    public val initialCapacity: Map<String, InitialCapacityConfig>? = builder.initialCapacity
    /**
     * The maximum capacity of the application. This is cumulative across all workers at any given point in time during the lifespan of the application is created. No new resources will be created once any one of the defined limits is hit.
     */
    public val maximumCapacity: aws.sdk.kotlin.services.emrserverless.model.MaximumAllowedResources? = builder.maximumCapacity
    /**
     * The name of the application.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The network configuration for customer VPC connectivity for the application.
     */
    public val networkConfiguration: aws.sdk.kotlin.services.emrserverless.model.NetworkConfiguration? = builder.networkConfiguration
    /**
     * The Amazon EMR release associated with the application.
     */
    public val releaseLabel: kotlin.String? = builder.releaseLabel
    /**
     * The state of the application.
     */
    public val state: aws.sdk.kotlin.services.emrserverless.model.ApplicationState? = builder.state
    /**
     * The state details of the application.
     */
    public val stateDetails: kotlin.String? = builder.stateDetails
    /**
     * The tags assigned to the application.
     */
    public val tags: Map<String, String>? = builder.tags
    /**
     * The type of application, such as Spark or Hive.
     */
    public val type: kotlin.String? = builder.type
    /**
     * The date and time when the application run was last updated.
     */
    public val updatedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.updatedAt
    /**
     * The specification applied to each worker type.
     */
    public val workerTypeSpecifications: Map<String, WorkerTypeSpecification>? = builder.workerTypeSpecifications

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.emrserverless.model.Application = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Application(")
        append("applicationId=$applicationId,")
        append("architecture=$architecture,")
        append("arn=$arn,")
        append("autoStartConfiguration=$autoStartConfiguration,")
        append("autoStopConfiguration=$autoStopConfiguration,")
        append("createdAt=$createdAt,")
        append("imageConfiguration=$imageConfiguration,")
        append("initialCapacity=$initialCapacity,")
        append("maximumCapacity=$maximumCapacity,")
        append("name=$name,")
        append("networkConfiguration=$networkConfiguration,")
        append("releaseLabel=$releaseLabel,")
        append("state=$state,")
        append("stateDetails=$stateDetails,")
        append("tags=$tags,")
        append("type=$type,")
        append("updatedAt=$updatedAt,")
        append("workerTypeSpecifications=$workerTypeSpecifications")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = applicationId?.hashCode() ?: 0
        result = 31 * result + (architecture?.hashCode() ?: 0)
        result = 31 * result + (arn?.hashCode() ?: 0)
        result = 31 * result + (autoStartConfiguration?.hashCode() ?: 0)
        result = 31 * result + (autoStopConfiguration?.hashCode() ?: 0)
        result = 31 * result + (createdAt?.hashCode() ?: 0)
        result = 31 * result + (imageConfiguration?.hashCode() ?: 0)
        result = 31 * result + (initialCapacity?.hashCode() ?: 0)
        result = 31 * result + (maximumCapacity?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (networkConfiguration?.hashCode() ?: 0)
        result = 31 * result + (releaseLabel?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        result = 31 * result + (stateDetails?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        result = 31 * result + (updatedAt?.hashCode() ?: 0)
        result = 31 * result + (workerTypeSpecifications?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Application

        if (applicationId != other.applicationId) return false
        if (architecture != other.architecture) return false
        if (arn != other.arn) return false
        if (autoStartConfiguration != other.autoStartConfiguration) return false
        if (autoStopConfiguration != other.autoStopConfiguration) return false
        if (createdAt != other.createdAt) return false
        if (imageConfiguration != other.imageConfiguration) return false
        if (initialCapacity != other.initialCapacity) return false
        if (maximumCapacity != other.maximumCapacity) return false
        if (name != other.name) return false
        if (networkConfiguration != other.networkConfiguration) return false
        if (releaseLabel != other.releaseLabel) return false
        if (state != other.state) return false
        if (stateDetails != other.stateDetails) return false
        if (tags != other.tags) return false
        if (type != other.type) return false
        if (updatedAt != other.updatedAt) return false
        if (workerTypeSpecifications != other.workerTypeSpecifications) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.emrserverless.model.Application = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The ID of the application.
         */
        public var applicationId: kotlin.String? = null
        /**
         * The CPU architecture of an application.
         */
        public var architecture: aws.sdk.kotlin.services.emrserverless.model.Architecture? = null
        /**
         * The ARN of the application.
         */
        public var arn: kotlin.String? = null
        /**
         * The configuration for an application to automatically start on job submission.
         */
        public var autoStartConfiguration: aws.sdk.kotlin.services.emrserverless.model.AutoStartConfig? = null
        /**
         * The configuration for an application to automatically stop after a certain amount of time being idle.
         */
        public var autoStopConfiguration: aws.sdk.kotlin.services.emrserverless.model.AutoStopConfig? = null
        /**
         * The date and time when the application run was created.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The image configuration applied to all worker types.
         */
        public var imageConfiguration: aws.sdk.kotlin.services.emrserverless.model.ImageConfiguration? = null
        /**
         * The initial capacity of the application.
         */
        public var initialCapacity: Map<String, InitialCapacityConfig>? = null
        /**
         * The maximum capacity of the application. This is cumulative across all workers at any given point in time during the lifespan of the application is created. No new resources will be created once any one of the defined limits is hit.
         */
        public var maximumCapacity: aws.sdk.kotlin.services.emrserverless.model.MaximumAllowedResources? = null
        /**
         * The name of the application.
         */
        public var name: kotlin.String? = null
        /**
         * The network configuration for customer VPC connectivity for the application.
         */
        public var networkConfiguration: aws.sdk.kotlin.services.emrserverless.model.NetworkConfiguration? = null
        /**
         * The Amazon EMR release associated with the application.
         */
        public var releaseLabel: kotlin.String? = null
        /**
         * The state of the application.
         */
        public var state: aws.sdk.kotlin.services.emrserverless.model.ApplicationState? = null
        /**
         * The state details of the application.
         */
        public var stateDetails: kotlin.String? = null
        /**
         * The tags assigned to the application.
         */
        public var tags: Map<String, String>? = null
        /**
         * The type of application, such as Spark or Hive.
         */
        public var type: kotlin.String? = null
        /**
         * The date and time when the application run was last updated.
         */
        public var updatedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The specification applied to each worker type.
         */
        public var workerTypeSpecifications: Map<String, WorkerTypeSpecification>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.emrserverless.model.Application) : this() {
            this.applicationId = x.applicationId
            this.architecture = x.architecture
            this.arn = x.arn
            this.autoStartConfiguration = x.autoStartConfiguration
            this.autoStopConfiguration = x.autoStopConfiguration
            this.createdAt = x.createdAt
            this.imageConfiguration = x.imageConfiguration
            this.initialCapacity = x.initialCapacity
            this.maximumCapacity = x.maximumCapacity
            this.name = x.name
            this.networkConfiguration = x.networkConfiguration
            this.releaseLabel = x.releaseLabel
            this.state = x.state
            this.stateDetails = x.stateDetails
            this.tags = x.tags
            this.type = x.type
            this.updatedAt = x.updatedAt
            this.workerTypeSpecifications = x.workerTypeSpecifications
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.emrserverless.model.Application = Application(this)

        /**
         * construct an [aws.sdk.kotlin.services.emrserverless.model.AutoStartConfig] inside the given [block]
         */
        public fun autoStartConfiguration(block: aws.sdk.kotlin.services.emrserverless.model.AutoStartConfig.Builder.() -> kotlin.Unit) {
            this.autoStartConfiguration = aws.sdk.kotlin.services.emrserverless.model.AutoStartConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.emrserverless.model.AutoStopConfig] inside the given [block]
         */
        public fun autoStopConfiguration(block: aws.sdk.kotlin.services.emrserverless.model.AutoStopConfig.Builder.() -> kotlin.Unit) {
            this.autoStopConfiguration = aws.sdk.kotlin.services.emrserverless.model.AutoStopConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.emrserverless.model.ImageConfiguration] inside the given [block]
         */
        public fun imageConfiguration(block: aws.sdk.kotlin.services.emrserverless.model.ImageConfiguration.Builder.() -> kotlin.Unit) {
            this.imageConfiguration = aws.sdk.kotlin.services.emrserverless.model.ImageConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.emrserverless.model.MaximumAllowedResources] inside the given [block]
         */
        public fun maximumCapacity(block: aws.sdk.kotlin.services.emrserverless.model.MaximumAllowedResources.Builder.() -> kotlin.Unit) {
            this.maximumCapacity = aws.sdk.kotlin.services.emrserverless.model.MaximumAllowedResources.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.emrserverless.model.NetworkConfiguration] inside the given [block]
         */
        public fun networkConfiguration(block: aws.sdk.kotlin.services.emrserverless.model.NetworkConfiguration.Builder.() -> kotlin.Unit) {
            this.networkConfiguration = aws.sdk.kotlin.services.emrserverless.model.NetworkConfiguration.invoke(block)
        }
    }
}
