// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.emrserverless.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * The summary of attributes associated with a job run.
 */
public class JobRunSummary private constructor(builder: Builder) {
    /**
     * The ID of the application the job is running on.
     */
    public val applicationId: kotlin.String? = builder.applicationId
    /**
     * The ARN of the job run.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * The date and time when the job run was created.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant? = builder.createdAt
    /**
     * The user who created the job run.
     */
    public val createdBy: kotlin.String? = builder.createdBy
    /**
     * The execution role ARN of the job run.
     */
    public val executionRole: kotlin.String? = builder.executionRole
    /**
     * The ID of the job run.
     */
    public val id: kotlin.String? = builder.id
    /**
     * The optional job run name. This doesn't have to be unique.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The Amazon EMR release associated with the application your job is running on.
     */
    public val releaseLabel: kotlin.String? = builder.releaseLabel
    /**
     * The state of the job run.
     */
    public val state: aws.sdk.kotlin.services.emrserverless.model.JobRunState? = builder.state
    /**
     * The state details of the job run.
     */
    public val stateDetails: kotlin.String? = builder.stateDetails
    /**
     * The type of job run, such as Spark or Hive.
     */
    public val type: kotlin.String? = builder.type
    /**
     * The date and time when the job run was last updated.
     */
    public val updatedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.updatedAt

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.emrserverless.model.JobRunSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("JobRunSummary(")
        append("applicationId=$applicationId,")
        append("arn=$arn,")
        append("createdAt=$createdAt,")
        append("createdBy=$createdBy,")
        append("executionRole=$executionRole,")
        append("id=$id,")
        append("name=$name,")
        append("releaseLabel=$releaseLabel,")
        append("state=$state,")
        append("stateDetails=$stateDetails,")
        append("type=$type,")
        append("updatedAt=$updatedAt")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = applicationId?.hashCode() ?: 0
        result = 31 * result + (arn?.hashCode() ?: 0)
        result = 31 * result + (createdAt?.hashCode() ?: 0)
        result = 31 * result + (createdBy?.hashCode() ?: 0)
        result = 31 * result + (executionRole?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (releaseLabel?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        result = 31 * result + (stateDetails?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        result = 31 * result + (updatedAt?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as JobRunSummary

        if (applicationId != other.applicationId) return false
        if (arn != other.arn) return false
        if (createdAt != other.createdAt) return false
        if (createdBy != other.createdBy) return false
        if (executionRole != other.executionRole) return false
        if (id != other.id) return false
        if (name != other.name) return false
        if (releaseLabel != other.releaseLabel) return false
        if (state != other.state) return false
        if (stateDetails != other.stateDetails) return false
        if (type != other.type) return false
        if (updatedAt != other.updatedAt) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.emrserverless.model.JobRunSummary = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The ID of the application the job is running on.
         */
        public var applicationId: kotlin.String? = null
        /**
         * The ARN of the job run.
         */
        public var arn: kotlin.String? = null
        /**
         * The date and time when the job run was created.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The user who created the job run.
         */
        public var createdBy: kotlin.String? = null
        /**
         * The execution role ARN of the job run.
         */
        public var executionRole: kotlin.String? = null
        /**
         * The ID of the job run.
         */
        public var id: kotlin.String? = null
        /**
         * The optional job run name. This doesn't have to be unique.
         */
        public var name: kotlin.String? = null
        /**
         * The Amazon EMR release associated with the application your job is running on.
         */
        public var releaseLabel: kotlin.String? = null
        /**
         * The state of the job run.
         */
        public var state: aws.sdk.kotlin.services.emrserverless.model.JobRunState? = null
        /**
         * The state details of the job run.
         */
        public var stateDetails: kotlin.String? = null
        /**
         * The type of job run, such as Spark or Hive.
         */
        public var type: kotlin.String? = null
        /**
         * The date and time when the job run was last updated.
         */
        public var updatedAt: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.emrserverless.model.JobRunSummary) : this() {
            this.applicationId = x.applicationId
            this.arn = x.arn
            this.createdAt = x.createdAt
            this.createdBy = x.createdBy
            this.executionRole = x.executionRole
            this.id = x.id
            this.name = x.name
            this.releaseLabel = x.releaseLabel
            this.state = x.state
            this.stateDetails = x.stateDetails
            this.type = x.type
            this.updatedAt = x.updatedAt
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.emrserverless.model.JobRunSummary = JobRunSummary(this)
    }
}
