// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.emrserverless.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Information about a job run. A job run is a unit of work, such as a Spark JAR, Hive query, or SparkSQL query, that you submit to an EMR Serverless application.
 */
public class JobRun private constructor(builder: Builder) {
    /**
     * The ID of the application the job is running on.
     */
    public val applicationId: kotlin.String? = builder.applicationId
    /**
     * The execution role ARN of the job run.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * The aggregate vCPU, memory, and storage that AWS has billed for the job run. The billed resources include a 1-minute minimum usage for workers, plus additional storage over 20 GB per worker. Note that billed resources do not include usage for idle pre-initialized workers.
     */
    public val billedResourceUtilization: aws.sdk.kotlin.services.emrserverless.model.ResourceUtilization? = builder.billedResourceUtilization
    /**
     * The configuration settings that are used to override default configuration.
     */
    public val configurationOverrides: aws.sdk.kotlin.services.emrserverless.model.ConfigurationOverrides? = builder.configurationOverrides
    /**
     * The date and time when the job run was created.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant? = builder.createdAt
    /**
     * The user who created the job run.
     */
    public val createdBy: kotlin.String? = builder.createdBy
    /**
     * The execution role ARN of the job run.
     */
    public val executionRole: kotlin.String? = builder.executionRole
    /**
     * Returns the job run timeout value from the `StartJobRun` call. If no timeout was specified, then it returns the default timeout of 720 minutes.
     */
    public val executionTimeoutMinutes: kotlin.Long? = builder.executionTimeoutMinutes
    /**
     * The job driver for the job run.
     */
    public val jobDriver: aws.sdk.kotlin.services.emrserverless.model.JobDriver? = builder.jobDriver
    /**
     * The ID of the job run.
     */
    public val jobRunId: kotlin.String? = builder.jobRunId
    /**
     * The optional job run name. This doesn't have to be unique.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The network configuration for customer VPC connectivity.
     */
    public val networkConfiguration: aws.sdk.kotlin.services.emrserverless.model.NetworkConfiguration? = builder.networkConfiguration
    /**
     * The EMR release associated with the application your job is running on.
     */
    public val releaseLabel: kotlin.String? = builder.releaseLabel
    /**
     * The state of the job run.
     */
    public val state: aws.sdk.kotlin.services.emrserverless.model.JobRunState? = builder.state
    /**
     * The state details of the job run.
     */
    public val stateDetails: kotlin.String? = builder.stateDetails
    /**
     * The tags assigned to the job run.
     */
    public val tags: Map<String, String>? = builder.tags
    /**
     * The job run total execution duration in seconds. This field is only available for job runs in a `COMPLETED`, `FAILED`, or `CANCELLED` state.
     */
    public val totalExecutionDurationSeconds: kotlin.Int? = builder.totalExecutionDurationSeconds
    /**
     * The aggregate vCPU, memory, and storage resources used from the time the job starts to execute, until the time the job terminates, rounded up to the nearest second.
     */
    public val totalResourceUtilization: aws.sdk.kotlin.services.emrserverless.model.TotalResourceUtilization? = builder.totalResourceUtilization
    /**
     * The date and time when the job run was updated.
     */
    public val updatedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.updatedAt

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.emrserverless.model.JobRun = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("JobRun(")
        append("applicationId=$applicationId,")
        append("arn=$arn,")
        append("billedResourceUtilization=$billedResourceUtilization,")
        append("configurationOverrides=$configurationOverrides,")
        append("createdAt=$createdAt,")
        append("createdBy=$createdBy,")
        append("executionRole=$executionRole,")
        append("executionTimeoutMinutes=$executionTimeoutMinutes,")
        append("jobDriver=$jobDriver,")
        append("jobRunId=$jobRunId,")
        append("name=$name,")
        append("networkConfiguration=$networkConfiguration,")
        append("releaseLabel=$releaseLabel,")
        append("state=$state,")
        append("stateDetails=$stateDetails,")
        append("tags=$tags,")
        append("totalExecutionDurationSeconds=$totalExecutionDurationSeconds,")
        append("totalResourceUtilization=$totalResourceUtilization,")
        append("updatedAt=$updatedAt")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = applicationId?.hashCode() ?: 0
        result = 31 * result + (arn?.hashCode() ?: 0)
        result = 31 * result + (billedResourceUtilization?.hashCode() ?: 0)
        result = 31 * result + (configurationOverrides?.hashCode() ?: 0)
        result = 31 * result + (createdAt?.hashCode() ?: 0)
        result = 31 * result + (createdBy?.hashCode() ?: 0)
        result = 31 * result + (executionRole?.hashCode() ?: 0)
        result = 31 * result + (executionTimeoutMinutes?.hashCode() ?: 0)
        result = 31 * result + (jobDriver?.hashCode() ?: 0)
        result = 31 * result + (jobRunId?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (networkConfiguration?.hashCode() ?: 0)
        result = 31 * result + (releaseLabel?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        result = 31 * result + (stateDetails?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (totalExecutionDurationSeconds ?: 0)
        result = 31 * result + (totalResourceUtilization?.hashCode() ?: 0)
        result = 31 * result + (updatedAt?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as JobRun

        if (applicationId != other.applicationId) return false
        if (arn != other.arn) return false
        if (billedResourceUtilization != other.billedResourceUtilization) return false
        if (configurationOverrides != other.configurationOverrides) return false
        if (createdAt != other.createdAt) return false
        if (createdBy != other.createdBy) return false
        if (executionRole != other.executionRole) return false
        if (executionTimeoutMinutes != other.executionTimeoutMinutes) return false
        if (jobDriver != other.jobDriver) return false
        if (jobRunId != other.jobRunId) return false
        if (name != other.name) return false
        if (networkConfiguration != other.networkConfiguration) return false
        if (releaseLabel != other.releaseLabel) return false
        if (state != other.state) return false
        if (stateDetails != other.stateDetails) return false
        if (tags != other.tags) return false
        if (totalExecutionDurationSeconds != other.totalExecutionDurationSeconds) return false
        if (totalResourceUtilization != other.totalResourceUtilization) return false
        if (updatedAt != other.updatedAt) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.emrserverless.model.JobRun = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The ID of the application the job is running on.
         */
        public var applicationId: kotlin.String? = null
        /**
         * The execution role ARN of the job run.
         */
        public var arn: kotlin.String? = null
        /**
         * The aggregate vCPU, memory, and storage that AWS has billed for the job run. The billed resources include a 1-minute minimum usage for workers, plus additional storage over 20 GB per worker. Note that billed resources do not include usage for idle pre-initialized workers.
         */
        public var billedResourceUtilization: aws.sdk.kotlin.services.emrserverless.model.ResourceUtilization? = null
        /**
         * The configuration settings that are used to override default configuration.
         */
        public var configurationOverrides: aws.sdk.kotlin.services.emrserverless.model.ConfigurationOverrides? = null
        /**
         * The date and time when the job run was created.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The user who created the job run.
         */
        public var createdBy: kotlin.String? = null
        /**
         * The execution role ARN of the job run.
         */
        public var executionRole: kotlin.String? = null
        /**
         * Returns the job run timeout value from the `StartJobRun` call. If no timeout was specified, then it returns the default timeout of 720 minutes.
         */
        public var executionTimeoutMinutes: kotlin.Long? = null
        /**
         * The job driver for the job run.
         */
        public var jobDriver: aws.sdk.kotlin.services.emrserverless.model.JobDriver? = null
        /**
         * The ID of the job run.
         */
        public var jobRunId: kotlin.String? = null
        /**
         * The optional job run name. This doesn't have to be unique.
         */
        public var name: kotlin.String? = null
        /**
         * The network configuration for customer VPC connectivity.
         */
        public var networkConfiguration: aws.sdk.kotlin.services.emrserverless.model.NetworkConfiguration? = null
        /**
         * The EMR release associated with the application your job is running on.
         */
        public var releaseLabel: kotlin.String? = null
        /**
         * The state of the job run.
         */
        public var state: aws.sdk.kotlin.services.emrserverless.model.JobRunState? = null
        /**
         * The state details of the job run.
         */
        public var stateDetails: kotlin.String? = null
        /**
         * The tags assigned to the job run.
         */
        public var tags: Map<String, String>? = null
        /**
         * The job run total execution duration in seconds. This field is only available for job runs in a `COMPLETED`, `FAILED`, or `CANCELLED` state.
         */
        public var totalExecutionDurationSeconds: kotlin.Int? = null
        /**
         * The aggregate vCPU, memory, and storage resources used from the time the job starts to execute, until the time the job terminates, rounded up to the nearest second.
         */
        public var totalResourceUtilization: aws.sdk.kotlin.services.emrserverless.model.TotalResourceUtilization? = null
        /**
         * The date and time when the job run was updated.
         */
        public var updatedAt: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.emrserverless.model.JobRun) : this() {
            this.applicationId = x.applicationId
            this.arn = x.arn
            this.billedResourceUtilization = x.billedResourceUtilization
            this.configurationOverrides = x.configurationOverrides
            this.createdAt = x.createdAt
            this.createdBy = x.createdBy
            this.executionRole = x.executionRole
            this.executionTimeoutMinutes = x.executionTimeoutMinutes
            this.jobDriver = x.jobDriver
            this.jobRunId = x.jobRunId
            this.name = x.name
            this.networkConfiguration = x.networkConfiguration
            this.releaseLabel = x.releaseLabel
            this.state = x.state
            this.stateDetails = x.stateDetails
            this.tags = x.tags
            this.totalExecutionDurationSeconds = x.totalExecutionDurationSeconds
            this.totalResourceUtilization = x.totalResourceUtilization
            this.updatedAt = x.updatedAt
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.emrserverless.model.JobRun = JobRun(this)

        /**
         * construct an [aws.sdk.kotlin.services.emrserverless.model.ResourceUtilization] inside the given [block]
         */
        public fun billedResourceUtilization(block: aws.sdk.kotlin.services.emrserverless.model.ResourceUtilization.Builder.() -> kotlin.Unit) {
            this.billedResourceUtilization = aws.sdk.kotlin.services.emrserverless.model.ResourceUtilization.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.emrserverless.model.ConfigurationOverrides] inside the given [block]
         */
        public fun configurationOverrides(block: aws.sdk.kotlin.services.emrserverless.model.ConfigurationOverrides.Builder.() -> kotlin.Unit) {
            this.configurationOverrides = aws.sdk.kotlin.services.emrserverless.model.ConfigurationOverrides.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.emrserverless.model.NetworkConfiguration] inside the given [block]
         */
        public fun networkConfiguration(block: aws.sdk.kotlin.services.emrserverless.model.NetworkConfiguration.Builder.() -> kotlin.Unit) {
            this.networkConfiguration = aws.sdk.kotlin.services.emrserverless.model.NetworkConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.emrserverless.model.TotalResourceUtilization] inside the given [block]
         */
        public fun totalResourceUtilization(block: aws.sdk.kotlin.services.emrserverless.model.TotalResourceUtilization.Builder.() -> kotlin.Unit) {
            this.totalResourceUtilization = aws.sdk.kotlin.services.emrserverless.model.TotalResourceUtilization.invoke(block)
        }
    }
}
