// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.emrcontainers

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.config.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.endpoints.resolveEndpointUrl
import aws.sdk.kotlin.runtime.config.profile.AwsProfile
import aws.sdk.kotlin.runtime.config.profile.AwsSharedConfig
import aws.sdk.kotlin.runtime.http.retries.AwsRetryPolicy
import aws.sdk.kotlin.runtime.region.DefaultRegionProviderChain
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.emrcontainers.auth.DefaultEmrContainersAuthSchemeProvider
import aws.sdk.kotlin.services.emrcontainers.auth.EmrContainersAuthSchemeProvider
import aws.sdk.kotlin.services.emrcontainers.endpoints.DefaultEmrContainersEndpointProvider
import aws.sdk.kotlin.services.emrcontainers.endpoints.EmrContainersEndpointParameters
import aws.sdk.kotlin.services.emrcontainers.endpoints.EmrContainersEndpointProvider
import aws.sdk.kotlin.services.emrcontainers.model.CancelJobRunRequest
import aws.sdk.kotlin.services.emrcontainers.model.CancelJobRunResponse
import aws.sdk.kotlin.services.emrcontainers.model.CreateJobTemplateRequest
import aws.sdk.kotlin.services.emrcontainers.model.CreateJobTemplateResponse
import aws.sdk.kotlin.services.emrcontainers.model.CreateManagedEndpointRequest
import aws.sdk.kotlin.services.emrcontainers.model.CreateManagedEndpointResponse
import aws.sdk.kotlin.services.emrcontainers.model.CreateSecurityConfigurationRequest
import aws.sdk.kotlin.services.emrcontainers.model.CreateSecurityConfigurationResponse
import aws.sdk.kotlin.services.emrcontainers.model.CreateVirtualClusterRequest
import aws.sdk.kotlin.services.emrcontainers.model.CreateVirtualClusterResponse
import aws.sdk.kotlin.services.emrcontainers.model.DeleteJobTemplateRequest
import aws.sdk.kotlin.services.emrcontainers.model.DeleteJobTemplateResponse
import aws.sdk.kotlin.services.emrcontainers.model.DeleteManagedEndpointRequest
import aws.sdk.kotlin.services.emrcontainers.model.DeleteManagedEndpointResponse
import aws.sdk.kotlin.services.emrcontainers.model.DeleteVirtualClusterRequest
import aws.sdk.kotlin.services.emrcontainers.model.DeleteVirtualClusterResponse
import aws.sdk.kotlin.services.emrcontainers.model.DescribeJobRunRequest
import aws.sdk.kotlin.services.emrcontainers.model.DescribeJobRunResponse
import aws.sdk.kotlin.services.emrcontainers.model.DescribeJobTemplateRequest
import aws.sdk.kotlin.services.emrcontainers.model.DescribeJobTemplateResponse
import aws.sdk.kotlin.services.emrcontainers.model.DescribeManagedEndpointRequest
import aws.sdk.kotlin.services.emrcontainers.model.DescribeManagedEndpointResponse
import aws.sdk.kotlin.services.emrcontainers.model.DescribeSecurityConfigurationRequest
import aws.sdk.kotlin.services.emrcontainers.model.DescribeSecurityConfigurationResponse
import aws.sdk.kotlin.services.emrcontainers.model.DescribeVirtualClusterRequest
import aws.sdk.kotlin.services.emrcontainers.model.DescribeVirtualClusterResponse
import aws.sdk.kotlin.services.emrcontainers.model.GetManagedEndpointSessionCredentialsRequest
import aws.sdk.kotlin.services.emrcontainers.model.GetManagedEndpointSessionCredentialsResponse
import aws.sdk.kotlin.services.emrcontainers.model.ListJobRunsRequest
import aws.sdk.kotlin.services.emrcontainers.model.ListJobRunsResponse
import aws.sdk.kotlin.services.emrcontainers.model.ListJobTemplatesRequest
import aws.sdk.kotlin.services.emrcontainers.model.ListJobTemplatesResponse
import aws.sdk.kotlin.services.emrcontainers.model.ListManagedEndpointsRequest
import aws.sdk.kotlin.services.emrcontainers.model.ListManagedEndpointsResponse
import aws.sdk.kotlin.services.emrcontainers.model.ListSecurityConfigurationsRequest
import aws.sdk.kotlin.services.emrcontainers.model.ListSecurityConfigurationsResponse
import aws.sdk.kotlin.services.emrcontainers.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.emrcontainers.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.emrcontainers.model.ListVirtualClustersRequest
import aws.sdk.kotlin.services.emrcontainers.model.ListVirtualClustersResponse
import aws.sdk.kotlin.services.emrcontainers.model.StartJobRunRequest
import aws.sdk.kotlin.services.emrcontainers.model.StartJobRunResponse
import aws.sdk.kotlin.services.emrcontainers.model.TagResourceRequest
import aws.sdk.kotlin.services.emrcontainers.model.TagResourceResponse
import aws.sdk.kotlin.services.emrcontainers.model.UntagResourceRequest
import aws.sdk.kotlin.services.emrcontainers.model.UntagResourceResponse
import aws.smithy.kotlin.runtime.auth.AuthSchemeId
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.awsprotocol.ClockSkewInterceptor
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.AbstractSdkClientFactory
import aws.smithy.kotlin.runtime.client.IdempotencyTokenConfig
import aws.smithy.kotlin.runtime.client.IdempotencyTokenProvider
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.client.region.RegionProvider
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.url.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.telemetry.Global
import aws.smithy.kotlin.runtime.telemetry.TelemetryConfig
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider
import aws.smithy.kotlin.runtime.util.LazyAsyncValue
import kotlin.collections.List
import kotlin.jvm.JvmStatic
import kotlinx.coroutines.runBlocking


public const val ServiceId: String = "EMR containers"
public const val SdkVersion: String = "1.5.12"
public const val ServiceApiVersion: String = "2020-10-01"

/**
 * Amazon EMR on EKS provides a deployment option for Amazon EMR that allows you to run open-source big data frameworks on Amazon Elastic Kubernetes Service (Amazon EKS). With this deployment option, you can focus on running analytics workloads while Amazon EMR on EKS builds, configures, and manages containers for open-source applications. For more information about Amazon EMR on EKS concepts and tasks, see [What is Amazon EMR on EKS](https://docs.aws.amazon.com/emr/latest/EMR-on-EKS-DevelopmentGuide/emr-eks.html).
 *
 * *Amazon EMR containers* is the API name for Amazon EMR on EKS. The `emr-containers` prefix is used in the following scenarios:
 * + It is the prefix in the CLI commands for Amazon EMR on EKS. For example, `aws emr-containers start-job-run`.
 * + It is the prefix before IAM policy actions for Amazon EMR on EKS. For example, `"Action": [ "emr-containers:StartJobRun"]`. For more information, see [Policy actions for Amazon EMR on EKS](https://docs.aws.amazon.com/emr/latest/EMR-on-EKS-DevelopmentGuide/security_iam_service-with-iam.html#security_iam_service-with-iam-id-based-policies-actions).
 * + It is the prefix used in Amazon EMR on EKS service endpoints. For example, `emr-containers.us-east-2.amazonaws.com`. For more information, see [Amazon EMR on EKSService Endpoints](https://docs.aws.amazon.com/emr/latest/EMR-on-EKS-DevelopmentGuide/service-quotas.html#service-endpoints).
 */
public interface EmrContainersClient : SdkClient {
    /**
     * EmrContainersClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, EmrContainersClient, Builder>()
     {
        @JvmStatic
        override fun builder(): Builder = Builder()

        override fun finalizeConfig(builder: Builder) {
            super.finalizeConfig(builder)
            builder.config.interceptors.add(0, ClockSkewInterceptor())
        }

        override suspend fun finalizeEnvironmentalConfig(builder: Builder, sharedConfig: LazyAsyncValue<AwsSharedConfig>, activeProfile: LazyAsyncValue<AwsProfile>) {
            super.finalizeEnvironmentalConfig(builder, sharedConfig, activeProfile)
            builder.config.endpointUrl = builder.config.endpointUrl ?: resolveEndpointUrl(
                sharedConfig,
                "EmrContainers",
                "EMR_CONTAINERS",
                "emr_containers",
            )
        }
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, EmrContainersClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): EmrContainersClient = DefaultEmrContainersClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), IdempotencyTokenConfig, RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TelemetryConfig {
        override val clientName: String = builder.clientName
        override val region: String? = builder.region ?: runBlocking { builder.regionProvider?.getRegion() ?: resolveRegion() }
        override val regionProvider: RegionProvider = builder.regionProvider ?: DefaultRegionProviderChain()
        override val authSchemePreference: kotlin.collections.List<aws.smithy.kotlin.runtime.auth.AuthSchemeId>? = builder.authSchemePreference
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = builder.authSchemes
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointProvider: EmrContainersEndpointProvider = builder.endpointProvider ?: DefaultEmrContainersEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val idempotencyTokenProvider: IdempotencyTokenProvider = builder.idempotencyTokenProvider ?: IdempotencyTokenProvider.Default
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsRetryPolicy.Default
        override val telemetryProvider: TelemetryProvider = builder.telemetryProvider ?: TelemetryProvider.Global
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        override val applicationId: String? = builder.applicationId
        public val authSchemeProvider: EmrContainersAuthSchemeProvider = builder.authSchemeProvider ?: DefaultEmrContainersAuthSchemeProvider(authSchemePreference = authSchemePreference)
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            regionProvider = this@Config.regionProvider
            authSchemePreference = this@Config.authSchemePreference
            authSchemes = this@Config.authSchemes
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            idempotencyTokenProvider = this@Config.idempotencyTokenProvider
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            telemetryProvider = this@Config.telemetryProvider
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
            applicationId = this@Config.applicationId
            authSchemeProvider = this@Config.authSchemeProvider
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), IdempotencyTokenConfig.Builder, RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TelemetryConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "EMR containers"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more information.
             * When specified, this static region configuration takes precedence over other region resolution methods.
             *
             * The region resolution order is:
             * 1. Static region (if specified)
             * 2. Custom region provider (if configured)
             * 3. Default region provider chain
             */
            override var region: String? = null

            /**
             * An optional region provider that determines the AWS region for client operations. When specified, this provider
             * takes precedence over the default region provider chain, unless a static region is explicitly configured.
             *
             * The region resolution order is:
             * 1. Static region (if specified)
             * 2. Custom region provider (if configured)
             * 3. Default region provider chain
             */
            override var regionProvider: RegionProvider? = null

            /**
             * The ordered preference of [AuthScheme] that this client will use.
             */
            override var authSchemePreference: kotlin.collections.List<aws.smithy.kotlin.runtime.auth.AuthSchemeId>? = null

            /**
             * Register new or override default [AuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = emptyList()

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: EmrContainersEndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Override the default idempotency token generator. SDK clients will generate tokens for members
             * that represent idempotent tokens when not explicitly set by the caller using this generator.
             */
            override var idempotencyTokenProvider: IdempotencyTokenProvider? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The telemetry provider used to instrument the SDK operations with. By default, the global telemetry
             * provider will be used.
             */
            override var telemetryProvider: TelemetryProvider? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            /**
             * An optional application specific identifier.
             * When set it will be appended to the User-Agent header of every request in the form of: `app/{applicationId}`.
             * When not explicitly set, the value will be loaded from the following locations:
             *
             * - JVM System Property: `aws.userAgentAppId`
             * - Environment variable: `AWS_SDK_UA_APP_ID`
             * - Shared configuration profile attribute: `sdk_ua_app_id`
             *
             * See [shared configuration settings](https://docs.aws.amazon.com/sdkref/latest/guide/settings-reference.html)
             * reference for more information on environment variables and shared config settings.
             */
            override var applicationId: String? = null

            /**
             * Configure the provider used to resolve the authentication scheme to use for a particular operation.
             */
            public var authSchemeProvider: EmrContainersAuthSchemeProvider? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Cancels a job run. A job run is a unit of work, such as a Spark jar, PySpark script, or SparkSQL query, that you submit to Amazon EMR on EKS.
     */
    public suspend fun cancelJobRun(input: CancelJobRunRequest): CancelJobRunResponse

    /**
     * Creates a job template. Job template stores values of StartJobRun API request in a template and can be used to start a job run. Job template allows two use cases: avoid repeating recurring StartJobRun API request values, enforcing certain values in StartJobRun API request.
     */
    public suspend fun createJobTemplate(input: CreateJobTemplateRequest): CreateJobTemplateResponse

    /**
     * Creates a managed endpoint. A managed endpoint is a gateway that connects Amazon EMR Studio to Amazon EMR on EKS so that Amazon EMR Studio can communicate with your virtual cluster.
     */
    public suspend fun createManagedEndpoint(input: CreateManagedEndpointRequest): CreateManagedEndpointResponse

    /**
     * Creates a security configuration. Security configurations in Amazon EMR on EKS are templates for different security setups. You can use security configurations to configure the Lake Formation integration setup. You can also create a security configuration to re-use a security setup each time you create a virtual cluster.
     */
    public suspend fun createSecurityConfiguration(input: CreateSecurityConfigurationRequest): CreateSecurityConfigurationResponse

    /**
     * Creates a virtual cluster. Virtual cluster is a managed entity on Amazon EMR on EKS. You can create, describe, list and delete virtual clusters. They do not consume any additional resource in your system. A single virtual cluster maps to a single Kubernetes namespace. Given this relationship, you can model virtual clusters the same way you model Kubernetes namespaces to meet your requirements.
     */
    public suspend fun createVirtualCluster(input: CreateVirtualClusterRequest): CreateVirtualClusterResponse

    /**
     * Deletes a job template. Job template stores values of StartJobRun API request in a template and can be used to start a job run. Job template allows two use cases: avoid repeating recurring StartJobRun API request values, enforcing certain values in StartJobRun API request.
     */
    public suspend fun deleteJobTemplate(input: DeleteJobTemplateRequest): DeleteJobTemplateResponse

    /**
     * Deletes a managed endpoint. A managed endpoint is a gateway that connects Amazon EMR Studio to Amazon EMR on EKS so that Amazon EMR Studio can communicate with your virtual cluster.
     */
    public suspend fun deleteManagedEndpoint(input: DeleteManagedEndpointRequest): DeleteManagedEndpointResponse

    /**
     * Deletes a virtual cluster. Virtual cluster is a managed entity on Amazon EMR on EKS. You can create, describe, list and delete virtual clusters. They do not consume any additional resource in your system. A single virtual cluster maps to a single Kubernetes namespace. Given this relationship, you can model virtual clusters the same way you model Kubernetes namespaces to meet your requirements.
     */
    public suspend fun deleteVirtualCluster(input: DeleteVirtualClusterRequest): DeleteVirtualClusterResponse

    /**
     * Displays detailed information about a job run. A job run is a unit of work, such as a Spark jar, PySpark script, or SparkSQL query, that you submit to Amazon EMR on EKS.
     */
    public suspend fun describeJobRun(input: DescribeJobRunRequest): DescribeJobRunResponse

    /**
     * Displays detailed information about a specified job template. Job template stores values of StartJobRun API request in a template and can be used to start a job run. Job template allows two use cases: avoid repeating recurring StartJobRun API request values, enforcing certain values in StartJobRun API request.
     */
    public suspend fun describeJobTemplate(input: DescribeJobTemplateRequest): DescribeJobTemplateResponse

    /**
     * Displays detailed information about a managed endpoint. A managed endpoint is a gateway that connects Amazon EMR Studio to Amazon EMR on EKS so that Amazon EMR Studio can communicate with your virtual cluster.
     */
    public suspend fun describeManagedEndpoint(input: DescribeManagedEndpointRequest): DescribeManagedEndpointResponse

    /**
     * Displays detailed information about a specified security configuration. Security configurations in Amazon EMR on EKS are templates for different security setups. You can use security configurations to configure the Lake Formation integration setup. You can also create a security configuration to re-use a security setup each time you create a virtual cluster.
     */
    public suspend fun describeSecurityConfiguration(input: DescribeSecurityConfigurationRequest): DescribeSecurityConfigurationResponse

    /**
     * Displays detailed information about a specified virtual cluster. Virtual cluster is a managed entity on Amazon EMR on EKS. You can create, describe, list and delete virtual clusters. They do not consume any additional resource in your system. A single virtual cluster maps to a single Kubernetes namespace. Given this relationship, you can model virtual clusters the same way you model Kubernetes namespaces to meet your requirements.
     */
    public suspend fun describeVirtualCluster(input: DescribeVirtualClusterRequest): DescribeVirtualClusterResponse

    /**
     * Generate a session token to connect to a managed endpoint.
     */
    public suspend fun getManagedEndpointSessionCredentials(input: GetManagedEndpointSessionCredentialsRequest): GetManagedEndpointSessionCredentialsResponse

    /**
     * Lists job runs based on a set of parameters. A job run is a unit of work, such as a Spark jar, PySpark script, or SparkSQL query, that you submit to Amazon EMR on EKS.
     */
    public suspend fun listJobRuns(input: ListJobRunsRequest): ListJobRunsResponse

    /**
     * Lists job templates based on a set of parameters. Job template stores values of StartJobRun API request in a template and can be used to start a job run. Job template allows two use cases: avoid repeating recurring StartJobRun API request values, enforcing certain values in StartJobRun API request.
     */
    public suspend fun listJobTemplates(input: ListJobTemplatesRequest = ListJobTemplatesRequest { }): ListJobTemplatesResponse

    /**
     * Lists managed endpoints based on a set of parameters. A managed endpoint is a gateway that connects Amazon EMR Studio to Amazon EMR on EKS so that Amazon EMR Studio can communicate with your virtual cluster.
     */
    public suspend fun listManagedEndpoints(input: ListManagedEndpointsRequest): ListManagedEndpointsResponse

    /**
     * Lists security configurations based on a set of parameters. Security configurations in Amazon EMR on EKS are templates for different security setups. You can use security configurations to configure the Lake Formation integration setup. You can also create a security configuration to re-use a security setup each time you create a virtual cluster.
     */
    public suspend fun listSecurityConfigurations(input: ListSecurityConfigurationsRequest = ListSecurityConfigurationsRequest { }): ListSecurityConfigurationsResponse

    /**
     * Lists the tags assigned to the resources.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Lists information about the specified virtual cluster. Virtual cluster is a managed entity on Amazon EMR on EKS. You can create, describe, list and delete virtual clusters. They do not consume any additional resource in your system. A single virtual cluster maps to a single Kubernetes namespace. Given this relationship, you can model virtual clusters the same way you model Kubernetes namespaces to meet your requirements.
     */
    public suspend fun listVirtualClusters(input: ListVirtualClustersRequest = ListVirtualClustersRequest { }): ListVirtualClustersResponse

    /**
     * Starts a job run. A job run is a unit of work, such as a Spark jar, PySpark script, or SparkSQL query, that you submit to Amazon EMR on EKS.
     */
    public suspend fun startJobRun(input: StartJobRunRequest): StartJobRunResponse

    /**
     * Assigns tags to resources. A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key and an optional value, both of which you define. Tags enable you to categorize your Amazon Web Services resources by attributes such as purpose, owner, or environment. When you have many resources of the same type, you can quickly identify a specific resource based on the tags you've assigned to it. For example, you can define a set of tags for your Amazon EMR on EKS clusters to help you track each cluster's owner and stack level. We recommend that you devise a consistent set of tag keys for each resource type. You can then search and filter the resources based on the tags that you add.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Removes tags from resources.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun EmrContainersClient.withConfig(block: EmrContainersClient.Config.Builder.() -> Unit): EmrContainersClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultEmrContainersClient(newConfig)
}

/**
 * Cancels a job run. A job run is a unit of work, such as a Spark jar, PySpark script, or SparkSQL query, that you submit to Amazon EMR on EKS.
 */
public suspend inline fun EmrContainersClient.cancelJobRun(crossinline block: CancelJobRunRequest.Builder.() -> Unit): CancelJobRunResponse = cancelJobRun(CancelJobRunRequest.Builder().apply(block).build())

/**
 * Creates a job template. Job template stores values of StartJobRun API request in a template and can be used to start a job run. Job template allows two use cases: avoid repeating recurring StartJobRun API request values, enforcing certain values in StartJobRun API request.
 */
public suspend inline fun EmrContainersClient.createJobTemplate(crossinline block: CreateJobTemplateRequest.Builder.() -> Unit): CreateJobTemplateResponse = createJobTemplate(CreateJobTemplateRequest.Builder().apply(block).build())

/**
 * Creates a managed endpoint. A managed endpoint is a gateway that connects Amazon EMR Studio to Amazon EMR on EKS so that Amazon EMR Studio can communicate with your virtual cluster.
 */
public suspend inline fun EmrContainersClient.createManagedEndpoint(crossinline block: CreateManagedEndpointRequest.Builder.() -> Unit): CreateManagedEndpointResponse = createManagedEndpoint(CreateManagedEndpointRequest.Builder().apply(block).build())

/**
 * Creates a security configuration. Security configurations in Amazon EMR on EKS are templates for different security setups. You can use security configurations to configure the Lake Formation integration setup. You can also create a security configuration to re-use a security setup each time you create a virtual cluster.
 */
public suspend inline fun EmrContainersClient.createSecurityConfiguration(crossinline block: CreateSecurityConfigurationRequest.Builder.() -> Unit): CreateSecurityConfigurationResponse = createSecurityConfiguration(CreateSecurityConfigurationRequest.Builder().apply(block).build())

/**
 * Creates a virtual cluster. Virtual cluster is a managed entity on Amazon EMR on EKS. You can create, describe, list and delete virtual clusters. They do not consume any additional resource in your system. A single virtual cluster maps to a single Kubernetes namespace. Given this relationship, you can model virtual clusters the same way you model Kubernetes namespaces to meet your requirements.
 */
public suspend inline fun EmrContainersClient.createVirtualCluster(crossinline block: CreateVirtualClusterRequest.Builder.() -> Unit): CreateVirtualClusterResponse = createVirtualCluster(CreateVirtualClusterRequest.Builder().apply(block).build())

/**
 * Deletes a job template. Job template stores values of StartJobRun API request in a template and can be used to start a job run. Job template allows two use cases: avoid repeating recurring StartJobRun API request values, enforcing certain values in StartJobRun API request.
 */
public suspend inline fun EmrContainersClient.deleteJobTemplate(crossinline block: DeleteJobTemplateRequest.Builder.() -> Unit): DeleteJobTemplateResponse = deleteJobTemplate(DeleteJobTemplateRequest.Builder().apply(block).build())

/**
 * Deletes a managed endpoint. A managed endpoint is a gateway that connects Amazon EMR Studio to Amazon EMR on EKS so that Amazon EMR Studio can communicate with your virtual cluster.
 */
public suspend inline fun EmrContainersClient.deleteManagedEndpoint(crossinline block: DeleteManagedEndpointRequest.Builder.() -> Unit): DeleteManagedEndpointResponse = deleteManagedEndpoint(DeleteManagedEndpointRequest.Builder().apply(block).build())

/**
 * Deletes a virtual cluster. Virtual cluster is a managed entity on Amazon EMR on EKS. You can create, describe, list and delete virtual clusters. They do not consume any additional resource in your system. A single virtual cluster maps to a single Kubernetes namespace. Given this relationship, you can model virtual clusters the same way you model Kubernetes namespaces to meet your requirements.
 */
public suspend inline fun EmrContainersClient.deleteVirtualCluster(crossinline block: DeleteVirtualClusterRequest.Builder.() -> Unit): DeleteVirtualClusterResponse = deleteVirtualCluster(DeleteVirtualClusterRequest.Builder().apply(block).build())

/**
 * Displays detailed information about a job run. A job run is a unit of work, such as a Spark jar, PySpark script, or SparkSQL query, that you submit to Amazon EMR on EKS.
 */
public suspend inline fun EmrContainersClient.describeJobRun(crossinline block: DescribeJobRunRequest.Builder.() -> Unit): DescribeJobRunResponse = describeJobRun(DescribeJobRunRequest.Builder().apply(block).build())

/**
 * Displays detailed information about a specified job template. Job template stores values of StartJobRun API request in a template and can be used to start a job run. Job template allows two use cases: avoid repeating recurring StartJobRun API request values, enforcing certain values in StartJobRun API request.
 */
public suspend inline fun EmrContainersClient.describeJobTemplate(crossinline block: DescribeJobTemplateRequest.Builder.() -> Unit): DescribeJobTemplateResponse = describeJobTemplate(DescribeJobTemplateRequest.Builder().apply(block).build())

/**
 * Displays detailed information about a managed endpoint. A managed endpoint is a gateway that connects Amazon EMR Studio to Amazon EMR on EKS so that Amazon EMR Studio can communicate with your virtual cluster.
 */
public suspend inline fun EmrContainersClient.describeManagedEndpoint(crossinline block: DescribeManagedEndpointRequest.Builder.() -> Unit): DescribeManagedEndpointResponse = describeManagedEndpoint(DescribeManagedEndpointRequest.Builder().apply(block).build())

/**
 * Displays detailed information about a specified security configuration. Security configurations in Amazon EMR on EKS are templates for different security setups. You can use security configurations to configure the Lake Formation integration setup. You can also create a security configuration to re-use a security setup each time you create a virtual cluster.
 */
public suspend inline fun EmrContainersClient.describeSecurityConfiguration(crossinline block: DescribeSecurityConfigurationRequest.Builder.() -> Unit): DescribeSecurityConfigurationResponse = describeSecurityConfiguration(DescribeSecurityConfigurationRequest.Builder().apply(block).build())

/**
 * Displays detailed information about a specified virtual cluster. Virtual cluster is a managed entity on Amazon EMR on EKS. You can create, describe, list and delete virtual clusters. They do not consume any additional resource in your system. A single virtual cluster maps to a single Kubernetes namespace. Given this relationship, you can model virtual clusters the same way you model Kubernetes namespaces to meet your requirements.
 */
public suspend inline fun EmrContainersClient.describeVirtualCluster(crossinline block: DescribeVirtualClusterRequest.Builder.() -> Unit): DescribeVirtualClusterResponse = describeVirtualCluster(DescribeVirtualClusterRequest.Builder().apply(block).build())

/**
 * Generate a session token to connect to a managed endpoint.
 */
public suspend inline fun EmrContainersClient.getManagedEndpointSessionCredentials(crossinline block: GetManagedEndpointSessionCredentialsRequest.Builder.() -> Unit): GetManagedEndpointSessionCredentialsResponse = getManagedEndpointSessionCredentials(GetManagedEndpointSessionCredentialsRequest.Builder().apply(block).build())

/**
 * Lists job runs based on a set of parameters. A job run is a unit of work, such as a Spark jar, PySpark script, or SparkSQL query, that you submit to Amazon EMR on EKS.
 */
public suspend inline fun EmrContainersClient.listJobRuns(crossinline block: ListJobRunsRequest.Builder.() -> Unit): ListJobRunsResponse = listJobRuns(ListJobRunsRequest.Builder().apply(block).build())

/**
 * Lists job templates based on a set of parameters. Job template stores values of StartJobRun API request in a template and can be used to start a job run. Job template allows two use cases: avoid repeating recurring StartJobRun API request values, enforcing certain values in StartJobRun API request.
 */
public suspend inline fun EmrContainersClient.listJobTemplates(crossinline block: ListJobTemplatesRequest.Builder.() -> Unit): ListJobTemplatesResponse = listJobTemplates(ListJobTemplatesRequest.Builder().apply(block).build())

/**
 * Lists managed endpoints based on a set of parameters. A managed endpoint is a gateway that connects Amazon EMR Studio to Amazon EMR on EKS so that Amazon EMR Studio can communicate with your virtual cluster.
 */
public suspend inline fun EmrContainersClient.listManagedEndpoints(crossinline block: ListManagedEndpointsRequest.Builder.() -> Unit): ListManagedEndpointsResponse = listManagedEndpoints(ListManagedEndpointsRequest.Builder().apply(block).build())

/**
 * Lists security configurations based on a set of parameters. Security configurations in Amazon EMR on EKS are templates for different security setups. You can use security configurations to configure the Lake Formation integration setup. You can also create a security configuration to re-use a security setup each time you create a virtual cluster.
 */
public suspend inline fun EmrContainersClient.listSecurityConfigurations(crossinline block: ListSecurityConfigurationsRequest.Builder.() -> Unit): ListSecurityConfigurationsResponse = listSecurityConfigurations(ListSecurityConfigurationsRequest.Builder().apply(block).build())

/**
 * Lists the tags assigned to the resources.
 */
public suspend inline fun EmrContainersClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Lists information about the specified virtual cluster. Virtual cluster is a managed entity on Amazon EMR on EKS. You can create, describe, list and delete virtual clusters. They do not consume any additional resource in your system. A single virtual cluster maps to a single Kubernetes namespace. Given this relationship, you can model virtual clusters the same way you model Kubernetes namespaces to meet your requirements.
 */
public suspend inline fun EmrContainersClient.listVirtualClusters(crossinline block: ListVirtualClustersRequest.Builder.() -> Unit): ListVirtualClustersResponse = listVirtualClusters(ListVirtualClustersRequest.Builder().apply(block).build())

/**
 * Starts a job run. A job run is a unit of work, such as a Spark jar, PySpark script, or SparkSQL query, that you submit to Amazon EMR on EKS.
 */
public suspend inline fun EmrContainersClient.startJobRun(crossinline block: StartJobRunRequest.Builder.() -> Unit): StartJobRunResponse = startJobRun(StartJobRunRequest.Builder().apply(block).build())

/**
 * Assigns tags to resources. A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key and an optional value, both of which you define. Tags enable you to categorize your Amazon Web Services resources by attributes such as purpose, owner, or environment. When you have many resources of the same type, you can quickly identify a specific resource based on the tags you've assigned to it. For example, you can define a set of tags for your Amazon EMR on EKS clusters to help you track each cluster's owner and stack level. We recommend that you devise a consistent set of tag keys for each resource type. You can then search and filter the resources based on the tags that you add.
 */
public suspend inline fun EmrContainersClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Removes tags from resources.
 */
public suspend inline fun EmrContainersClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())
