// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.emrcontainers.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Inputs related to the security configuration. Security configurations in Amazon EMR on EKS are templates for different security setups. You can use security configurations to configure the Lake Formation integration setup. You can also create a security configuration to re-use a security setup each time you create a virtual cluster.
 */
public class SecurityConfiguration private constructor(builder: Builder) {
    /**
     * The ARN (Amazon Resource Name) of the security configuration.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * The date and time that the job run was created.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant? = builder.createdAt
    /**
     * The user who created the job run.
     */
    public val createdBy: kotlin.String? = builder.createdBy
    /**
     * The ID of the security configuration.
     */
    public val id: kotlin.String? = builder.id
    /**
     * The name of the security configuration.
     */
    public val name: kotlin.String? = builder.name
    /**
     * Security configuration inputs for the request.
     */
    public val securityConfigurationData: aws.sdk.kotlin.services.emrcontainers.model.SecurityConfigurationData? = builder.securityConfigurationData
    /**
     * The tags to assign to the security configuration.
     */
    public val tags: Map<String, String>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.emrcontainers.model.SecurityConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SecurityConfiguration(")
        append("arn=$arn,")
        append("createdAt=$createdAt,")
        append("createdBy=$createdBy,")
        append("id=$id,")
        append("name=$name,")
        append("securityConfigurationData=$securityConfigurationData,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (createdAt?.hashCode() ?: 0)
        result = 31 * result + (createdBy?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (securityConfigurationData?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SecurityConfiguration

        if (arn != other.arn) return false
        if (createdAt != other.createdAt) return false
        if (createdBy != other.createdBy) return false
        if (id != other.id) return false
        if (name != other.name) return false
        if (securityConfigurationData != other.securityConfigurationData) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.emrcontainers.model.SecurityConfiguration = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The ARN (Amazon Resource Name) of the security configuration.
         */
        public var arn: kotlin.String? = null
        /**
         * The date and time that the job run was created.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The user who created the job run.
         */
        public var createdBy: kotlin.String? = null
        /**
         * The ID of the security configuration.
         */
        public var id: kotlin.String? = null
        /**
         * The name of the security configuration.
         */
        public var name: kotlin.String? = null
        /**
         * Security configuration inputs for the request.
         */
        public var securityConfigurationData: aws.sdk.kotlin.services.emrcontainers.model.SecurityConfigurationData? = null
        /**
         * The tags to assign to the security configuration.
         */
        public var tags: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.emrcontainers.model.SecurityConfiguration) : this() {
            this.arn = x.arn
            this.createdAt = x.createdAt
            this.createdBy = x.createdBy
            this.id = x.id
            this.name = x.name
            this.securityConfigurationData = x.securityConfigurationData
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.emrcontainers.model.SecurityConfiguration = SecurityConfiguration(this)

        /**
         * construct an [aws.sdk.kotlin.services.emrcontainers.model.SecurityConfigurationData] inside the given [block]
         */
        public fun securityConfigurationData(block: aws.sdk.kotlin.services.emrcontainers.model.SecurityConfigurationData.Builder.() -> kotlin.Unit) {
            this.securityConfigurationData = aws.sdk.kotlin.services.emrcontainers.model.SecurityConfigurationData.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
