// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.emrcontainers.serde

import aws.sdk.kotlin.services.emrcontainers.model.EndpointState
import aws.sdk.kotlin.services.emrcontainers.model.ListManagedEndpointsRequest
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat


internal class ListManagedEndpointsOperationSerializer: HttpSerializer.NonStreaming<ListManagedEndpointsRequest> {
    override fun serialize(context: ExecutionContext, input: ListManagedEndpointsRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.GET

        builder.url {
            requireNotNull(input.virtualClusterId) { "virtualClusterId is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("virtualclusters"))
                add(PercentEncoding.SmithyLabel.encode(input.virtualClusterId))
                add(PercentEncoding.Path.encode("endpoints"))
            }
            parameters.decodedParameters(PercentEncoding.SmithyLabel) {
                if (input.createdAfter != null) add("createdAfter", input.createdAfter.format(TimestampFormat.ISO_8601))
                if (input.createdBefore != null) add("createdBefore", input.createdBefore.format(TimestampFormat.ISO_8601))
                if (input.maxResults != null) add("maxResults", input.maxResults.toString())
                if (input.nextToken != null) add("nextToken", input.nextToken)
                if (input.states?.isNotEmpty() == true) addAll("states", input.states.map { it.value })
                if (input.types?.isNotEmpty() == true) addAll("types", input.types)
            }
        }

        return builder
    }
}
