// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.emrcontainers.serde

import aws.sdk.kotlin.services.emrcontainers.model.JobRunState
import aws.sdk.kotlin.services.emrcontainers.model.ListJobRunsRequest
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat


internal class ListJobRunsOperationSerializer: HttpSerializer.NonStreaming<ListJobRunsRequest> {
    override fun serialize(context: ExecutionContext, input: ListJobRunsRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.GET

        builder.url {
            requireNotNull(input.virtualClusterId) { "virtualClusterId is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("virtualclusters"))
                add(PercentEncoding.SmithyLabel.encode(input.virtualClusterId))
                add(PercentEncoding.Path.encode("jobruns"))
            }
            parameters.decodedParameters(PercentEncoding.SmithyLabel) {
                if (input.createdAfter != null) add("createdAfter", input.createdAfter.format(TimestampFormat.ISO_8601))
                if (input.createdBefore != null) add("createdBefore", input.createdBefore.format(TimestampFormat.ISO_8601))
                if (input.maxResults != null) add("maxResults", input.maxResults.toString())
                if (input.name != null) add("name", input.name)
                if (input.nextToken != null) add("nextToken", input.nextToken)
                if (input.states?.isNotEmpty() == true) addAll("states", input.states.map { it.value })
            }
        }

        return builder
    }
}
