// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.emrcontainers.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Lake Formation related configuration inputs for the security configuration.
 */
public class LakeFormationConfiguration private constructor(builder: Builder) {
    /**
     * The session tag to authorize Amazon EMR on EKS for API calls to Lake Formation.
     */
    public val authorizedSessionTagValue: kotlin.String? = builder.authorizedSessionTagValue
    /**
     * The query engine IAM role ARN that is tied to the secure Spark job. The `QueryEngine` role assumes the `JobExecutionRole` to execute all the Lake Formation calls.
     */
    public val queryEngineRoleArn: kotlin.String? = builder.queryEngineRoleArn
    /**
     * The namespace input of the system job.
     */
    public val secureNamespaceInfo: aws.sdk.kotlin.services.emrcontainers.model.SecureNamespaceInfo? = builder.secureNamespaceInfo

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.emrcontainers.model.LakeFormationConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("LakeFormationConfiguration(")
        append("authorizedSessionTagValue=$authorizedSessionTagValue,")
        append("queryEngineRoleArn=$queryEngineRoleArn,")
        append("secureNamespaceInfo=$secureNamespaceInfo")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = authorizedSessionTagValue?.hashCode() ?: 0
        result = 31 * result + (queryEngineRoleArn?.hashCode() ?: 0)
        result = 31 * result + (secureNamespaceInfo?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as LakeFormationConfiguration

        if (authorizedSessionTagValue != other.authorizedSessionTagValue) return false
        if (queryEngineRoleArn != other.queryEngineRoleArn) return false
        if (secureNamespaceInfo != other.secureNamespaceInfo) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.emrcontainers.model.LakeFormationConfiguration = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The session tag to authorize Amazon EMR on EKS for API calls to Lake Formation.
         */
        public var authorizedSessionTagValue: kotlin.String? = null
        /**
         * The query engine IAM role ARN that is tied to the secure Spark job. The `QueryEngine` role assumes the `JobExecutionRole` to execute all the Lake Formation calls.
         */
        public var queryEngineRoleArn: kotlin.String? = null
        /**
         * The namespace input of the system job.
         */
        public var secureNamespaceInfo: aws.sdk.kotlin.services.emrcontainers.model.SecureNamespaceInfo? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.emrcontainers.model.LakeFormationConfiguration) : this() {
            this.authorizedSessionTagValue = x.authorizedSessionTagValue
            this.queryEngineRoleArn = x.queryEngineRoleArn
            this.secureNamespaceInfo = x.secureNamespaceInfo
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.emrcontainers.model.LakeFormationConfiguration = LakeFormationConfiguration(this)

        /**
         * construct an [aws.sdk.kotlin.services.emrcontainers.model.SecureNamespaceInfo] inside the given [block]
         */
        public fun secureNamespaceInfo(block: aws.sdk.kotlin.services.emrcontainers.model.SecureNamespaceInfo.Builder.() -> kotlin.Unit) {
            this.secureNamespaceInfo = aws.sdk.kotlin.services.emrcontainers.model.SecureNamespaceInfo.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
