// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.emrcontainers.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A configuration specification to be used when provisioning virtual clusters, which can include configurations for applications and software bundled with Amazon EMR on EKS. A configuration consists of a classification, properties, and optional nested configurations. A classification refers to an application-specific configuration file. Properties are the settings you want to change in that file.
 */
public class Configuration private constructor(builder: Builder) {
    /**
     * The classification within a configuration.
     */
    public val classification: kotlin.String = requireNotNull(builder.classification) { "A non-null value must be provided for classification" }
    /**
     * A list of additional configurations to apply within a configuration object.
     */
    public val configurations: List<Configuration>? = builder.configurations
    /**
     * A set of properties specified within a configuration classification.
     */
    public val properties: Map<String, String>? = builder.properties

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.emrcontainers.model.Configuration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Configuration(")
        append("classification=$classification,")
        append("configurations=$configurations,")
        append("properties=*** Sensitive Data Redacted ***")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = classification.hashCode()
        result = 31 * result + (configurations?.hashCode() ?: 0)
        result = 31 * result + (properties?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Configuration

        if (classification != other.classification) return false
        if (configurations != other.configurations) return false
        if (properties != other.properties) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.emrcontainers.model.Configuration = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The classification within a configuration.
         */
        public var classification: kotlin.String? = null
        /**
         * A list of additional configurations to apply within a configuration object.
         */
        public var configurations: List<Configuration>? = null
        /**
         * A set of properties specified within a configuration classification.
         */
        public var properties: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.emrcontainers.model.Configuration) : this() {
            this.classification = x.classification
            this.configurations = x.configurations
            this.properties = x.properties
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.emrcontainers.model.Configuration = Configuration(this)

        internal fun correctErrors(): Builder {
            if (classification == null) classification = ""
            return this
        }
    }
}
