// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.emrcontainers.serde

import aws.sdk.kotlin.services.emrcontainers.model.Credentials
import aws.sdk.kotlin.services.emrcontainers.model.EmrContainersException
import aws.sdk.kotlin.services.emrcontainers.model.GetManagedEndpointSessionCredentialsResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant


internal class GetManagedEndpointSessionCredentialsOperationDeserializer: HttpDeserialize<GetManagedEndpointSessionCredentialsResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): GetManagedEndpointSessionCredentialsResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetManagedEndpointSessionCredentialsError(context, call)
        }
        val builder = GetManagedEndpointSessionCredentialsResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetManagedEndpointSessionCredentialsOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwGetManagedEndpointSessionCredentialsError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw EmrContainersException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "RequestThrottledException" -> RequestThrottledExceptionDeserializer().deserialize(context, wrappedCall)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        else -> EmrContainersException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetManagedEndpointSessionCredentialsOperationBody(builder: GetManagedEndpointSessionCredentialsResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CREDENTIALS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("credentials"))
    val EXPIRESAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("expiresAt"))
    val ID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("id"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CREDENTIALS_DESCRIPTOR)
        field(EXPIRESAT_DESCRIPTOR)
        field(ID_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CREDENTIALS_DESCRIPTOR.index -> builder.credentials = deserializeCredentialsDocument(deserializer)
                EXPIRESAT_DESCRIPTOR.index -> builder.expiresAt = deserializeString().let { Instant.fromIso8601(it) }
                ID_DESCRIPTOR.index -> builder.id = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
