// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.emrcontainers.paginators

import aws.sdk.kotlin.services.emrcontainers.EmrContainersClient
import aws.sdk.kotlin.services.emrcontainers.model.Endpoint
import aws.sdk.kotlin.services.emrcontainers.model.JobRun
import aws.sdk.kotlin.services.emrcontainers.model.JobTemplate
import aws.sdk.kotlin.services.emrcontainers.model.ListJobRunsRequest
import aws.sdk.kotlin.services.emrcontainers.model.ListJobRunsResponse
import aws.sdk.kotlin.services.emrcontainers.model.ListJobTemplatesRequest
import aws.sdk.kotlin.services.emrcontainers.model.ListJobTemplatesResponse
import aws.sdk.kotlin.services.emrcontainers.model.ListManagedEndpointsRequest
import aws.sdk.kotlin.services.emrcontainers.model.ListManagedEndpointsResponse
import aws.sdk.kotlin.services.emrcontainers.model.ListVirtualClustersRequest
import aws.sdk.kotlin.services.emrcontainers.model.ListVirtualClustersResponse
import aws.sdk.kotlin.services.emrcontainers.model.VirtualCluster
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [ListJobRunsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListJobRunsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListJobRunsResponse]
 */
public fun EmrContainersClient.listJobRunsPaginated(initialRequest: ListJobRunsRequest): Flow<ListJobRunsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listJobRunsPaginated.listJobRuns(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListJobRunsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListJobRunsResponse]
 */
public fun EmrContainersClient.listJobRunsPaginated(block: ListJobRunsRequest.Builder.() -> Unit): Flow<ListJobRunsResponse> =
    listJobRunsPaginated(ListJobRunsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listJobRunsPaginated]
 * to access the nested member [JobRun]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [JobRun]
 */
@JvmName("listJobRunsResponseJobRun")
public fun Flow<ListJobRunsResponse>.jobRuns(): Flow<JobRun> =
    transform() { response ->
        response.jobRuns?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListJobTemplatesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListJobTemplatesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListJobTemplatesResponse]
 */
public fun EmrContainersClient.listJobTemplatesPaginated(initialRequest: ListJobTemplatesRequest = ListJobTemplatesRequest { }): Flow<ListJobTemplatesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listJobTemplatesPaginated.listJobTemplates(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListJobTemplatesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListJobTemplatesResponse]
 */
public fun EmrContainersClient.listJobTemplatesPaginated(block: ListJobTemplatesRequest.Builder.() -> Unit): Flow<ListJobTemplatesResponse> =
    listJobTemplatesPaginated(ListJobTemplatesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listJobTemplatesPaginated]
 * to access the nested member [JobTemplate]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [JobTemplate]
 */
@JvmName("listJobTemplatesResponseJobTemplate")
public fun Flow<ListJobTemplatesResponse>.templates(): Flow<JobTemplate> =
    transform() { response ->
        response.templates?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListManagedEndpointsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListManagedEndpointsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListManagedEndpointsResponse]
 */
public fun EmrContainersClient.listManagedEndpointsPaginated(initialRequest: ListManagedEndpointsRequest): Flow<ListManagedEndpointsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listManagedEndpointsPaginated.listManagedEndpoints(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListManagedEndpointsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListManagedEndpointsResponse]
 */
public fun EmrContainersClient.listManagedEndpointsPaginated(block: ListManagedEndpointsRequest.Builder.() -> Unit): Flow<ListManagedEndpointsResponse> =
    listManagedEndpointsPaginated(ListManagedEndpointsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listManagedEndpointsPaginated]
 * to access the nested member [Endpoint]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Endpoint]
 */
@JvmName("listManagedEndpointsResponseEndpoint")
public fun Flow<ListManagedEndpointsResponse>.endpoints(): Flow<Endpoint> =
    transform() { response ->
        response.endpoints?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListVirtualClustersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListVirtualClustersRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListVirtualClustersResponse]
 */
public fun EmrContainersClient.listVirtualClustersPaginated(initialRequest: ListVirtualClustersRequest = ListVirtualClustersRequest { }): Flow<ListVirtualClustersResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listVirtualClustersPaginated.listVirtualClusters(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListVirtualClustersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListVirtualClustersResponse]
 */
public fun EmrContainersClient.listVirtualClustersPaginated(block: ListVirtualClustersRequest.Builder.() -> Unit): Flow<ListVirtualClustersResponse> =
    listVirtualClustersPaginated(ListVirtualClustersRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listVirtualClustersPaginated]
 * to access the nested member [VirtualCluster]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [VirtualCluster]
 */
@JvmName("listVirtualClustersResponseVirtualCluster")
public fun Flow<ListVirtualClustersResponse>.virtualClusters(): Flow<VirtualCluster> =
    transform() { response ->
        response.virtualClusters?.forEach {
            emit(it)
        }
    }
