// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.emrcontainers.transform

import aws.sdk.kotlin.services.emrcontainers.model.JobRunState
import aws.sdk.kotlin.services.emrcontainers.model.ListJobRunsRequest
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.http.util.encodeLabel
import aws.smithy.kotlin.runtime.net.parameters
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat


internal class ListJobRunsOperationSerializer: HttpSerialize<ListJobRunsRequest> {
    override suspend fun serialize(context: ExecutionContext, input: ListJobRunsRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.GET

        builder.url {
            val pathSegments = listOf<String>(
                "virtualclusters",
                "${input.virtualClusterId}".encodeLabel(),
                "jobruns",
            )
            path = pathSegments.joinToString(separator = "/", prefix = "/")
            parameters {
                if (input.createdAfter != null) append("createdAfter", input.createdAfter.format(TimestampFormat.ISO_8601))
                if (input.createdBefore != null) append("createdBefore", input.createdBefore.format(TimestampFormat.ISO_8601))
                if (input.maxResults != null) append("maxResults", "${input.maxResults}")
                if (input.name != null) append("name", input.name)
                if (input.nextToken != null) append("nextToken", input.nextToken)
                if (input.states?.isNotEmpty() == true) appendAll("states", input.states.map { "$it" })
            }
        }

        return builder
    }
}
