// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.emrcontainers.transform

import aws.sdk.kotlin.services.emrcontainers.model.GetManagedEndpointSessionCredentialsRequest
import aws.smithy.kotlin.runtime.client.idempotencyTokenProvider
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.http.util.encodeLabel
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class GetManagedEndpointSessionCredentialsOperationSerializer: HttpSerialize<GetManagedEndpointSessionCredentialsRequest> {
    override suspend fun serialize(context: ExecutionContext, input: GetManagedEndpointSessionCredentialsRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            val pathSegments = listOf<String>(
                "virtualclusters",
                "${input.virtualClusterIdentifier}".encodeLabel(),
                "endpoints",
                "${input.endpointIdentifier}".encodeLabel(),
                "credentials",
            )
            path = pathSegments.joinToString(separator = "/", prefix = "/")
        }

        val payload = serializeGetManagedEndpointSessionCredentialsOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeGetManagedEndpointSessionCredentialsOperationBody(context: ExecutionContext, input: GetManagedEndpointSessionCredentialsRequest): ByteArray {
    val serializer = JsonSerializer()
    val CLIENTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("clientToken"))
    val CREDENTIALTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("credentialType"))
    val DURATIONINSECONDS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("durationInSeconds"))
    val EXECUTIONROLEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("executionRoleArn"))
    val LOGCONTEXT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("logContext"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CLIENTTOKEN_DESCRIPTOR)
        field(CREDENTIALTYPE_DESCRIPTOR)
        field(DURATIONINSECONDS_DESCRIPTOR)
        field(EXECUTIONROLEARN_DESCRIPTOR)
        field(LOGCONTEXT_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.clientToken?.let { field(CLIENTTOKEN_DESCRIPTOR, it) } ?: field(CLIENTTOKEN_DESCRIPTOR, context.idempotencyTokenProvider.generateToken())
        input.credentialType?.let { field(CREDENTIALTYPE_DESCRIPTOR, it) }
        input.durationInSeconds?.let { field(DURATIONINSECONDS_DESCRIPTOR, it) }
        input.executionRoleArn?.let { field(EXECUTIONROLEARN_DESCRIPTOR, it) }
        input.logContext?.let { field(LOGCONTEXT_DESCRIPTOR, it) }
    }
    return serializer.toByteArray()
}
