// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.emrcontainers.transform

import aws.sdk.kotlin.services.emrcontainers.model.ConfigurationOverrides
import aws.sdk.kotlin.services.emrcontainers.model.JobDriver
import aws.sdk.kotlin.services.emrcontainers.model.StartJobRunRequest
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.client.idempotencyTokenProvider
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.http.util.encodeLabel
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class StartJobRunOperationSerializer: HttpSerialize<StartJobRunRequest> {
    override suspend fun serialize(context: ExecutionContext, input: StartJobRunRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            val pathSegments = listOf<String>(
                "virtualclusters",
                "${input.virtualClusterId}".encodeLabel(),
                "jobruns",
            )
            path = pathSegments.joinToString(separator = "/", prefix = "/")
        }

        val payload = serializeStartJobRunOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeStartJobRunOperationBody(context: ExecutionContext, input: StartJobRunRequest): ByteArray {
    val serializer = JsonSerializer()
    val CLIENTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("clientToken"))
    val CONFIGURATIONOVERRIDES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("configurationOverrides"))
    val EXECUTIONROLEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("executionRoleArn"))
    val JOBDRIVER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("jobDriver"))
    val JOBTEMPLATEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("jobTemplateId"))
    val JOBTEMPLATEPARAMETERS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("jobTemplateParameters"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("name"))
    val RELEASELABEL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("releaseLabel"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("tags"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CLIENTTOKEN_DESCRIPTOR)
        field(CONFIGURATIONOVERRIDES_DESCRIPTOR)
        field(EXECUTIONROLEARN_DESCRIPTOR)
        field(JOBDRIVER_DESCRIPTOR)
        field(JOBTEMPLATEID_DESCRIPTOR)
        field(JOBTEMPLATEPARAMETERS_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(RELEASELABEL_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.clientToken?.let { field(CLIENTTOKEN_DESCRIPTOR, it) } ?: field(CLIENTTOKEN_DESCRIPTOR, context.idempotencyTokenProvider.generateToken())
        input.configurationOverrides?.let { field(CONFIGURATIONOVERRIDES_DESCRIPTOR, it, ::serializeConfigurationOverridesDocument) }
        input.executionRoleArn?.let { field(EXECUTIONROLEARN_DESCRIPTOR, it) }
        input.jobDriver?.let { field(JOBDRIVER_DESCRIPTOR, it, ::serializeJobDriverDocument) }
        input.jobTemplateId?.let { field(JOBTEMPLATEID_DESCRIPTOR, it) }
        if (input.jobTemplateParameters != null) {
            mapField(JOBTEMPLATEPARAMETERS_DESCRIPTOR) {
                input.jobTemplateParameters.forEach { (key, value) -> entry(key, value) }
            }
        }
        input.name?.let { field(NAME_DESCRIPTOR, it) }
        input.releaseLabel?.let { field(RELEASELABEL_DESCRIPTOR, it) }
        if (input.tags != null) {
            mapField(TAGS_DESCRIPTOR) {
                input.tags.forEach { (key, value) -> entry(key, value) }
            }
        }
    }
    return serializer.toByteArray()
}
